package ungp.api.backgrounds;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CargoAPI.CargoItemType;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import org.jetbrains.annotations.Nullable;
import ungp.api.backgrounds.UNGP_BackgroundPluginAPI;
import ungp.api.saves.UNGP_DataSaverAPI;
import ungp.impl.saves.UNGP_BlueprintsDataSaver;
import ungp.impl.saves.UNGP_CreditsDataSaver;
import ungp.scripts.campaign.inherit.UNGP_InheritData;
import ungp.scripts.utils.Constants;

public abstract class UNGP_BaseBackgroundPlugin implements UNGP_BackgroundPluginAPI {

   protected Map cycleBonusMap = new LinkedHashMap();


   public UNGP_BaseBackgroundPlugin() {
      this.initCycleBonus();
   }

   public abstract void initCycleBonus();

   protected void addCycleBonus(int cycle, UNGP_BaseBackgroundPlugin.BackgroundBonus bonus) {
      Object bonusList = (List)this.cycleBonusMap.get(Integer.valueOf(cycle));
      if(bonusList == null) {
         bonusList = new LinkedList();
         this.cycleBonusMap.put(Integer.valueOf(cycle), bonusList);
      }

      ((List)bonusList).add(bonus);
   }

   public float getInheritCreditsFactor() {
      return 0.0F;
   }

   public float getInheritBlueprintsFactor() {
      return 0.0F;
   }

   public void addPostDescTooltip(TooltipMakerAPI tooltip, @Nullable UNGP_InheritData pickedInheritData) {
   }

   public void addInheritCreditsAndBPsTooltip(TooltipMakerAPI tooltip, @Nullable UNGP_InheritData pickedInheritData) {
      tooltip.addSectionHeading(Constants.backgrounds_i18n.get("heading_basic"), Alignment.LMID, 0.0F);
      tooltip.addSpacer(5.0F);
      float inheritCreditsFactor = this.getInheritCreditsFactor();
      float inheritBlueprintsFactor = this.getInheritBlueprintsFactor();
      float mayInheritCreditsAmount = 0.0F;
      float mayInheritBlueprintsAmount = 0.0F;
      if(pickedInheritData != null) {
         Iterator positiveHighlightColor = pickedInheritData.dataSavers.iterator();

         while(positiveHighlightColor.hasNext()) {
            UNGP_DataSaverAPI grayColor = (UNGP_DataSaverAPI)positiveHighlightColor.next();
            if(grayColor instanceof UNGP_BlueprintsDataSaver) {
               UNGP_BlueprintsDataSaver imageWithText = (UNGP_BlueprintsDataSaver)grayColor;
               mayInheritBlueprintsAmount = (float)((int)((float)imageWithText.bpAmount * inheritBlueprintsFactor));
            }

            if(grayColor instanceof UNGP_CreditsDataSaver) {
               UNGP_CreditsDataSaver imageWithText1 = (UNGP_CreditsDataSaver)grayColor;
               mayInheritCreditsAmount = (float)((int)((float)imageWithText1.getCredits() * inheritCreditsFactor));
            }
         }
      }

      Color positiveHighlightColor1 = Misc.getPositiveHighlightColor();
      Color grayColor1 = Misc.getGrayColor();
      TooltipMakerAPI imageWithText2 = tooltip.beginImageWithText("graphics/icons/intel/income_report.png", 24.0F);
      if(mayInheritCreditsAmount > 0.0F) {
         imageWithText2.addPara(Constants.root_i18n.get("inheritCredits"), 0.0F, new Color[]{positiveHighlightColor1, grayColor1}, new String[]{(int)(inheritCreditsFactor * 100.0F), Misc.getDGSCredits(mayInheritCreditsAmount)});
      } else {
         imageWithText2.addPara(Constants.root_i18n.get("inheritCredits"), 0.0F, new Color[]{positiveHighlightColor1, grayColor1}, new String[]{(int)(inheritCreditsFactor * 100.0F), "(-)"});
      }

      tooltip.addImageWithText(0.0F);
      TooltipMakerAPI imageWithText2 = tooltip.beginImageWithText("graphics/icons/intel/fleet_log3.png", 24.0F);
      if(mayInheritBlueprintsAmount > 0.0F) {
         imageWithText2.addPara(Constants.root_i18n.get("inheritBPs"), 0.0F, new Color[]{positiveHighlightColor1, grayColor1}, new String[]{(int)(inheritBlueprintsFactor * 100.0F), (int)mayInheritBlueprintsAmount});
      } else {
         imageWithText2.addPara(Constants.root_i18n.get("inheritBPs"), 0.0F, new Color[]{positiveHighlightColor1, grayColor1}, new String[]{(int)(inheritBlueprintsFactor * 100.0F), "(-)"});
      }

      tooltip.addImageWithText(0.0F);
   }

   public Color getOverrideNameColor() {
      return null;
   }

   public void addBonusTooltip(TooltipMakerAPI tooltip, @Nullable UNGP_InheritData pickedInheritData, boolean showLimit) {
      if(!this.cycleBonusMap.isEmpty()) {
         tooltip.addSectionHeading(Constants.backgrounds_i18n.get("heading_bonus"), Alignment.LMID, 0.0F);
         tooltip.addSpacer(5.0F);
         Color hl = Misc.getHighlightColor();
         Color gray = Misc.getGrayColor();
         Color base = Misc.getTextColor();
         float pad = 0.0F;
         int curCycle = 1;
         if(pickedInheritData != null) {
            curCycle = pickedInheritData.cycle;
         }

         Iterator var9 = this.cycleBonusMap.entrySet().iterator();

         while(var9.hasNext()) {
            Entry entry = (Entry)var9.next();
            int cycle = ((Integer)entry.getKey()).intValue();
            boolean isLimited = false;
            if(curCycle < cycle) {
               isLimited = true;
               if(!showLimit) {
                  continue;
               }
            }

            boolean isActuallyLocked = isLimited || showLimit;
            Color baseColor = isLimited?gray:base;
            Color highlightColor = isLimited?gray:hl;
            Iterator var16 = ((List)entry.getValue()).iterator();

            while(var16.hasNext()) {
               UNGP_BaseBackgroundPlugin.BackgroundBonus bonus = (UNGP_BaseBackgroundPlugin.BackgroundBonus)var16.next();
               switch(null.$SwitchMap$ungp$api$backgrounds$UNGP_BaseBackgroundPlugin$BackgroundBonusType[bonus.type.ordinal()]) {
               case 1:
                  String skillId = (String)bonus.params[0];
                  SkillSpecAPI skillSpec = Global.getSettings().getSkillSpec(skillId);
                  if(skillSpec != null) {
                     int level;
                     if(bonus.params[1] instanceof Integer) {
                        level = ((Integer)bonus.params[1]).intValue();
                     } else {
                        level = 1;
                     }

                     if(level < 2) {
                        tooltip.addPara(Constants.backgrounds_i18n.get("bonus_skill"), pad, baseColor, highlightColor, new String[]{skillSpec.getName()});
                     } else {
                        tooltip.addPara(Constants.backgrounds_i18n.get("bonus_skill_elite"), pad, baseColor, isLimited?gray:Misc.getStoryOptionColor(), new String[]{skillSpec.getName()});
                     }

                     if(isActuallyLocked) {
                        this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                     }
                  }
                  break;
               case 2:
                  CargoStackAPI stack = bonus.createCargoStack();
                  tooltip.addPara(Constants.backgrounds_i18n.get("bonus_item"), pad, baseColor, highlightColor, new String[]{stack.getDisplayName(), (int)stack.getSize()});
                  if(isActuallyLocked) {
                     this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                  }
                  break;
               case 3:
                  String variantId = (String)bonus.params[0];
                  Object size;
                  if(bonus.params[1] instanceof Integer) {
                     size = ((Integer)bonus.params[1]).intValue();
                  } else {
                     size = 1;
                  }

                  ShipVariantAPI variant = Global.getSettings().getVariant(variantId);
                  ShipHullSpecAPI hullSpec = variant.getHullSpec();
                  tooltip.addPara(Constants.backgrounds_i18n.get("bonus_ship"), pad, baseColor, highlightColor, new String[]{hullSpec.getHullNameWithDashClass(), (String)size});
                  if(isActuallyLocked) {
                     this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                  }
                  break;
               case 4:
                  tooltip.addPara(Constants.backgrounds_i18n.get("bonus_skill_point"), pad, baseColor, highlightColor, new String[]{((Integer)bonus.params[0]).intValue()});
                  if(isActuallyLocked) {
                     this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                  }
                  break;
               case 5:
                  tooltip.addPara(Constants.backgrounds_i18n.get("bonus_story_point"), pad, baseColor, highlightColor, new String[]{((Integer)bonus.params[0]).intValue()});
                  if(isActuallyLocked) {
                     this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                  }
                  break;
               case 6:
                  UNGP_BaseBackgroundPlugin.BackgroundBonusScript script = (UNGP_BaseBackgroundPlugin.BackgroundBonusScript)bonus.params[0];
                  script.addBonusTooltip(tooltip, pickedInheritData, isLimited, showLimit);
               }
            }

            tooltip.addSpacer(0.0F);
         }
      }

   }

   public void afterConfirm(UNGP_InheritData pickedInheritData) {
      if(!this.cycleBonusMap.isEmpty()) {
         HashMap skillGonnaLearnMap = new HashMap();
         int curCycle = 1;
         if(pickedInheritData != null) {
            curCycle = pickedInheritData.cycle;
         }

         MutableCharacterStatsAPI playerStats = Global.getSector().getPlayerStats();
         CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
         Iterator var6 = this.cycleBonusMap.entrySet().iterator();

         Entry entry;
         while(var6.hasNext()) {
            entry = (Entry)var6.next();
            int skillId = ((Integer)entry.getKey()).intValue();
            if(curCycle >= skillId) {
               Iterator level = ((List)entry.getValue()).iterator();

               label82:
               while(level.hasNext()) {
                  UNGP_BaseBackgroundPlugin.BackgroundBonus curLevel = (UNGP_BaseBackgroundPlugin.BackgroundBonus)level.next();
                  switch(null.$SwitchMap$ungp$api$backgrounds$UNGP_BaseBackgroundPlugin$BackgroundBonusType[curLevel.type.ordinal()]) {
                  case 1:
                     String skillId1 = (String)curLevel.params[0];
                     int level1;
                     if(curLevel.params[1] instanceof Integer) {
                        level1 = ((Integer)curLevel.params[1]).intValue();
                     } else {
                        level1 = 1;
                     }

                     Integer targetLevel = (Integer)skillGonnaLearnMap.get(skillId1);
                     if(targetLevel == null) {
                        targetLevel = Integer.valueOf(level1);
                     }

                     if(level1 > targetLevel.intValue()) {
                        skillGonnaLearnMap.put(skillId1, targetLevel);
                     }

                     skillGonnaLearnMap.put(skillId1, Integer.valueOf(level1));
                     break;
                  case 2:
                     CargoStackAPI stack = curLevel.createCargoStack();
                     playerFleet.getCargo().addFromStack(stack);
                     break;
                  case 3:
                     String variantId = (String)curLevel.params[0];
                     int size;
                     if(curLevel.params[1] instanceof Integer) {
                        size = ((Integer)curLevel.params[1]).intValue();
                     } else {
                        size = 1;
                     }

                     ShipVariantAPI variant = Global.getSettings().getVariant(variantId);
                     int var23 = 0;

                     while(true) {
                        if(var23 >= size) {
                           continue label82;
                        }

                        FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variant);
                        member.getRepairTracker().setCR(1.0F);
                        playerFleet.getFleetData().addFleetMember(member);
                        ++var23;
                     }
                  case 4:
                     playerStats.addPoints(((Integer)curLevel.params[0]).intValue());
                     break;
                  case 5:
                     playerStats.addStoryPoints(((Integer)curLevel.params[0]).intValue());
                     break;
                  case 6:
                     UNGP_BaseBackgroundPlugin.BackgroundBonusScript script = (UNGP_BaseBackgroundPlugin.BackgroundBonusScript)curLevel.params[0];
                     script.afterConfirm(pickedInheritData);
                  }
               }
            }
         }

         if(!skillGonnaLearnMap.isEmpty()) {
            var6 = skillGonnaLearnMap.entrySet().iterator();

            while(var6.hasNext()) {
               entry = (Entry)var6.next();
               String var20 = (String)entry.getKey();
               int var21 = ((Integer)entry.getValue()).intValue();
               int var22 = (int)playerStats.getSkillLevel(var20);
               if(var22 > 0 && var21 >= var22) {
                  playerStats.addPoints(1);
                  if(var22 >= 2) {
                     playerStats.addStoryPoints(1);
                  }
               }

               if(var21 > var22) {
                  playerStats.setSkillLevel(var20, (float)var21);
               }
            }
         }
      }

   }

   protected String getUnlockCycleString(int cycle) {
      return Constants.backgrounds_i18n.format("bonus_cycle_unlock_tip", new Object[]{cycle});
   }

   protected void addUnlockCycleStringToTooltipAtRight(TooltipMakerAPI tooltip, int cycle, Color gray, float pad) {
      tooltip.addSpacer(-tooltip.getPrev().getPosition().getHeight());
      tooltip.addPara(this.getUnlockCycleString(cycle), gray, pad).setAlignment(Alignment.RMID);
   }

   public void addAfterConfirmTooltip(TooltipMakerAPI tooltip, UNGP_InheritData pickedInheritData) {
      this.addBonusTooltip(tooltip, pickedInheritData, false);
   }

   public boolean isUnlocked(UNGP_InheritData pickedInheritData) {
      return false;
   }

   protected static class BackgroundBonus {

      protected UNGP_BaseBackgroundPlugin.BackgroundBonusType type;
      protected Object[] params;


      public BackgroundBonus(UNGP_BaseBackgroundPlugin.BackgroundBonusType type, Object ... params) {
         this.type = type;
         this.params = params;
      }

      public CargoStackAPI createCargoStack() {
         CargoStackAPI stack = Global.getFactory().createCargoStack((CargoItemType)this.params[0], this.params[1], (CargoAPI)null);
         stack.setSize(Float.parseFloat(this.params[2].toString()));
         return stack;
      }
   }

   protected static enum BackgroundBonusType {

      SKILL,
      CARGO_STACK,
      SHIP,
      SKILL_POINTS,
      STORY_POINTS,
      SCRIPT;
      // $FF: synthetic field
      private static final UNGP_BaseBackgroundPlugin.BackgroundBonusType[] $VALUES = $values();


      // $FF: synthetic method
      private static UNGP_BaseBackgroundPlugin.BackgroundBonusType[] $values() {
         return new UNGP_BaseBackgroundPlugin.BackgroundBonusType[]{SKILL, CARGO_STACK, SHIP, SKILL_POINTS, STORY_POINTS, SCRIPT};
      }

   }

   protected interface BackgroundBonusScript {

      void addBonusTooltip(TooltipMakerAPI var1, UNGP_InheritData var2, boolean var3, boolean var4);

      void afterConfirm(UNGP_InheritData var1);
   }
}
