/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.utils;

import cn.hutool.core.util.StrUtil;
import com.icarus.sdk.llm.client.LLMClient;
import com.icarus.sdk.llm.client.api.completion.chat.ChatCompletionRequest;
import com.icarus.sdk.llm.client.api.completion.chat.ChatMessage;
import com.icarus.sdk.llm.client.api.completion.chat.ChatMessageRole;
import com.icarus.sdk.llm.client.api.embedding.Embedding;
import com.icarus.sdk.llm.client.api.embedding.EmbeddingRequest;
import com.icarus.sdk.llm.client.cfg.LLMClientConfig;
import com.icarus.sdk.llm.client.cfg.LLMClientConfigExtender;
import com.icarus.sdk.llm.client.constant.ModelParam;
import com.icarus.sdk.llm.client.context.LLMCallContext;
import com.icarus.sdk.llm.client.entity.LLMClientParam;
import com.icarus.sdk.llm.client.remote.LLMProviderBuilder;
import com.icarus.sdk.llm.client.remote.servcie.LLMProvider;
import com.icarus.sdk.springboot.base.utils.SpringContextUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LLMClientUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LLMClientUtil.class);
    private static LLMClientConfig llmClientConfig;
    private static List<LLMClientConfigExtender> configExtenders;
    @Resource(name="llmClientConfig")
    private LLMClientConfig llmClientConfigBean;
    @Autowired(required=false)
    private List<LLMClientConfigExtender> configExtenderBeans;

    @PostConstruct
    public void init() {
        llmClientConfig = this.llmClientConfigBean;
        configExtenders = this.configExtenderBeans != null ? this.configExtenderBeans : new ArrayList<LLMClientConfigExtender>();
        configExtenders.sort(Comparator.comparingInt(LLMClientConfigExtender::getPriority));
    }

    public static Builder builder() {
        return new Builder();
    }

    private static LLMClientParam getLLMClientConfigs(String modelName, String type) {
        return LLMClientUtil.getLLMClientConfigs(modelName, type, null);
    }

    private static LLMClientParam getLLMClientConfigs(String modelName, String type, LLMCallContext context) {
        if (llmClientConfig == null) {
            llmClientConfig = (LLMClientConfig)SpringContextUtils.getBean(LLMClientConfig.class);
        }
        if (configExtenders == null) {
            try {
                configExtenders = SpringContextUtils.getApplicationContext().getBeansOfType(LLMClientConfigExtender.class).values().stream().sorted(Comparator.comparingInt(LLMClientConfigExtender::getPriority)).collect(Collectors.toList());
            }
            catch (Exception e) {
                configExtenders = new ArrayList<LLMClientConfigExtender>();
            }
        }
        if (llmClientConfig.getModels().isEmpty()) {
            throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u83b7\u53d6\u5230\u6a21\u578b\u914d\u7f6e");
        }
        if (StrUtil.isBlank((CharSequence)modelName)) {
            modelName = StrUtil.equals((CharSequence)type, (CharSequence)"chat") ? llmClientConfig.getDefaults().getChat() : (StrUtil.equals((CharSequence)type, (CharSequence)"embedding") ? llmClientConfig.getDefaults().getEmbedding() : (StrUtil.equals((CharSequence)type, (CharSequence)"vl") ? llmClientConfig.getDefaults().getVl() : (StrUtil.equals((CharSequence)type, (CharSequence)"stt") ? llmClientConfig.getDefaults().getStt() : (StrUtil.equals((CharSequence)type, (CharSequence)"tts") ? llmClientConfig.getDefaults().getTts() : (StrUtil.equals((CharSequence)type, (CharSequence)"image") ? llmClientConfig.getDefaults().getImage() : (StrUtil.equals((CharSequence)type, (CharSequence)"video") ? llmClientConfig.getDefaults().getVideo() : llmClientConfig.getDefaults().getChat()))))));
        }
        for (LLMClientConfigExtender extender : configExtenders) {
            LLMClientParam extendedParam;
            if (!extender.supports(modelName) || (extendedParam = extender.getExtendedClientParam(modelName, context)) == null) continue;
            log.debug("\u4f7f\u7528\u6269\u5c55\u5668 {} \u83b7\u53d6\u6a21\u578b {} \u7684\u914d\u7f6e", (Object)extender.getClass().getSimpleName(), (Object)modelName);
            return extendedParam;
        }
        if (!llmClientConfig.getModels().containsKey(modelName)) {
            throw new IllegalArgumentException("\u6a21\u578b\u914d\u7f6e\u4e0d\u5b58\u5728:" + modelName);
        }
        LLMClientParam clientParam = LLMClientParam.builder().baseUrl(llmClientConfig.getModels().get(modelName).getBaseUrl()).uriPath(llmClientConfig.getModels().get(modelName).getUriPath()).apiKey(llmClientConfig.getModels().get(modelName).getApiKey()).aiType(llmClientConfig.getModels().get(modelName).getAiType()).model(llmClientConfig.getModels().get(modelName).getModel()).deployment(llmClientConfig.getModels().get(modelName).getDeployment()).build();
        if (clientParam == null) {
            throw new RuntimeException("\u83b7\u53d6LLM client\u914d\u7f6e\u5f02\u5e38");
        }
        return clientParam;
    }

    public static String embedding(String content) {
        ArrayList<String> contents = new ArrayList<String>();
        contents.add(content);
        List<Embedding> results = LLMClientUtil.embeddings(contents, ModelParam.builder().build());
        return results.get(0).getEmbedding().toString();
    }

    public static String embedding(String modelName, String content) {
        ArrayList<String> contents = new ArrayList<String>();
        contents.add(content);
        List<Embedding> results = LLMClientUtil.embeddings(contents, ModelParam.builder().modelName(modelName).build());
        return results.get(0).getEmbedding().toString();
    }

    public static List<Embedding> embeddings(List<String> contents, ModelParam params) {
        return LLMClientUtil.embeddings(contents, params, null);
    }

    public static List<Embedding> embeddings(List<String> contents, ModelParam params, LLMCallContext context) {
        LLMClientParam llmClientParam = LLMClientUtil.getLLMClientConfigs(params.getModelName(), "embedding", context);
        LLMProvider llmProvider = LLMProviderBuilder.getLLMClient(llmClientParam);
        LLMClient llm = new LLMClient(llmProvider);
        EmbeddingRequest embeddingRequest = EmbeddingRequest.builder().model(llmClientParam.getModel()).input(contents).build();
        return llm.runEmbedding(embeddingRequest);
    }

    public static String chatCompletion(String content) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (content != null && !content.equals("")) {
            ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), content);
            messages.add(chatMessage);
        }
        return LLMClientUtil.chatCompletion(messages, ModelParam.builder().build());
    }

    public static String chatCompletion(String modelName, String content) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (content != null && !content.equals("")) {
            ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), content);
            messages.add(chatMessage);
        }
        return LLMClientUtil.chatCompletion(messages, ModelParam.builder().modelName(modelName).build());
    }

    public static String chatCompletion(List<ChatMessage> messages, ModelParam params) {
        return LLMClientUtil.chatCompletion(messages, params, null);
    }

    public static String chatCompletion(List<ChatMessage> messages, ModelParam params, LLMCallContext context) {
        LLMClientParam llmClientParam = LLMClientUtil.getLLMClientConfigs(params.getModelName(), "chat", context);
        LLMProvider llmProvider = LLMProviderBuilder.getLLMClient(llmClientParam);
        LLMClient llmClient = new LLMClient(llmProvider);
        ChatCompletionRequest chatCompletionRequest = ChatCompletionRequest.builder().model(llmClientParam.getModel()).messages(messages).n(1).stream(params.isStream()).temperature(params.getTemperature()).maxTokens(params.getMaxTokens()).build();
        return llmClient.runChatCompletion(chatCompletionRequest);
    }

    public String chat(String content) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (content != null && !content.equals("")) {
            ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), content);
            messages.add(chatMessage);
        }
        return LLMClientUtil.chatCompletion(messages, ModelParam.builder().build());
    }

    public String chat(String modelName, String content) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (content != null && !content.equals("")) {
            ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), content);
            messages.add(chatMessage);
        }
        return LLMClientUtil.chatCompletion(messages, ModelParam.builder().modelName(modelName).build());
    }

    public static String chatCompletionWithContext(String content, LLMCallContext context) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (content != null && !content.equals("")) {
            ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), content);
            messages.add(chatMessage);
        }
        return LLMClientUtil.chatCompletion(messages, ModelParam.builder().build(), context);
    }

    public static String chatCompletionWithContext(String modelName, String content, LLMCallContext context) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (content != null && !content.equals("")) {
            ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), content);
            messages.add(chatMessage);
        }
        return LLMClientUtil.chatCompletion(messages, ModelParam.builder().modelName(modelName).build(), context);
    }

    public static String chatCompletionWithContext(List<ChatMessage> messages, ModelParam modelParam, LLMCallContext context) {
        return LLMClientUtil.chatCompletion(messages, modelParam, context);
    }

    public static List<Embedding> embeddingsWithContext(List<String> contents, ModelParam modelParam, LLMCallContext context) {
        return LLMClientUtil.embeddings(contents, modelParam, context);
    }

    public String chatWithContext(String content, LLMCallContext context) {
        return LLMClientUtil.chatCompletionWithContext(content, context);
    }

    public String chatWithContext(String modelName, String content, LLMCallContext context) {
        return LLMClientUtil.chatCompletionWithContext(modelName, content, context);
    }

    public static class Builder {
        private List<ChatMessage> messages;
        private List<String> embeddings;
        private ModelParam modelParam = ModelParam.builder().build();
        private boolean removeThinkTag = false;
        private boolean removeScriptQuote = false;
        private boolean jsonFormat = false;
        private LLMCallContext context;

        public Builder() {
            this.messages = new ArrayList<ChatMessage>();
            this.embeddings = new ArrayList<String>();
            this.context = new LLMCallContext();
        }

        public Builder modelName(String modelName) {
            this.modelParam.setModelName(modelName);
            return this;
        }

        public Builder systemPrompt(String content) {
            if (StrUtil.isNotBlank((CharSequence)content)) {
                ChatMessage chatMessage = new ChatMessage(ChatMessageRole.SYSTEM.value(), content);
                this.messages.add(chatMessage);
            }
            return this;
        }

        public Builder embedding(String content) {
            this.embeddings.add(content);
            return this;
        }

        public Builder embedding(List<String> contents) {
            this.embeddings.addAll(contents);
            return this;
        }

        public Builder chat(String content) {
            if (StrUtil.isNotBlank((CharSequence)content)) {
                ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), content);
                this.messages.add(chatMessage);
            }
            return this;
        }

        public Builder chat(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder chat(ChatMessage message) {
            this.messages.add(message);
            return this;
        }

        public Builder temperature(Double temperature) {
            this.modelParam.setTemperature(temperature);
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.modelParam.setMaxTokens(maxTokens);
            return this;
        }

        public Builder topP(Double topP) {
            this.modelParam.setTopP(topP);
            return this;
        }

        public Builder topK(Integer topK) {
            this.modelParam.setTopK(topK);
            return this;
        }

        public Builder stream(boolean stream) {
            this.modelParam.setStream(stream);
            return this;
        }

        public Builder think(boolean think) {
            this.modelParam.setThink(think);
            return this;
        }

        public Builder stop(String stop) {
            this.modelParam.setStop(stop);
            return this;
        }

        public Builder logitBias(String logitBias) {
            this.modelParam.setLogitBias(logitBias);
            return this;
        }

        public Builder removeThinkTAG() {
            this.removeThinkTag = true;
            return this;
        }

        public Builder removeScriptQuote() {
            this.removeScriptQuote = true;
            return this;
        }

        public Builder jsonFormat() {
            this.jsonFormat = true;
            return this;
        }

        public Builder context(LLMCallContext context) {
            this.context = context != null ? context : new LLMCallContext();
            return this;
        }

        public Builder customParam(String key, Object value) {
            this.context.setParam(key, value);
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.context.setSessionId(sessionId);
            return this;
        }

        public Builder userInfo(String userId, String userName, String deptName, String company) {
            this.context.setUserInfo(userId, userName, deptName, company);
            return this;
        }

        public Builder appId(String appId) {
            this.context.setAppId(appId);
            return this;
        }

        public List<Embedding> runEmbedding() {
            List<Embedding> response = LLMClientUtil.embeddings(this.embeddings, this.modelParam, this.context);
            return response;
        }

        public String runCompletion() {
            return "\u90fd\u5565\u5e74\u4ee3\u4e86\uff0c\u8fd8\u7528Completion..\u6362Chat\u6a21\u5f0f\u5427";
        }

        public String runChatCompletion() {
            if (this.messages.size() > 0) {
                String response = LLMClientUtil.chatCompletion(this.messages, this.modelParam, this.context);
                if (this.removeThinkTag) {
                    log.debug("\u53bb\u9664think\u6807\u7b7e");
                    response = response.replaceAll("[\\s\\S]*?</think>", "");
                }
                if (this.removeScriptQuote) {
                    log.debug("\u53bb\u9664quote\u5982'''json\u548c'''");
                    response = response.replaceAll("```json", "").replaceAll("```", "");
                }
                response = response.trim();
                return response;
            }
            return "\u9519\u8bef\uff1a\u5bf9\u8bdd\u5185\u5bb9\u4e3a\u7a7a";
        }
    }
}

