/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.icarus.sdk.llm.client.api.OpenAiError;
import com.icarus.sdk.llm.client.api.OpenAiHttpException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final int MAX_TOTAL_CONN = 6000;
    private static final int MAX_CONN_PER_HOST = 3000;
    private static final int SOCKET_TIMEOUT = 18000000;
    private static final int CONNECTION_TIMEOUT = 2000;
    private static final int CONNECTION_MANAGER_TIMEOUT = 1000;
    private static final String encoding = "UTF-8";
    private static CloseableHttpClient httpclient;
    private static PoolingHttpClientConnectionManager connMrg;

    private static void init() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build();
            connMrg = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build());
            connMrg.setMaxTotal(6000);
            connMrg.setDefaultMaxPerRoute(3000);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(18000000).setConnectionRequestTimeout(1000).build();
            httpclient = HttpClients.custom().setSSLContext(sslContext).setConnectionManager((HttpClientConnectionManager)connMrg).setDefaultRequestConfig(defaultRequestConfig).build();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u521d\u59cb\u5316HttpClient\u5931\u8d25:NoSuchAlgorithmException,\u7cfb\u7edf\u5c06\u65e0\u6cd5\u542f\u52a8\u3002\u8fd9\u4e2a\u9519\u8bef\u662f\u7531NoSuchAlgorithmException\u5bfc\u81f4\uff0c\u8bf7\u68c0\u67e5x509\u6709\u5173\u73af\u5883\u548cjdk\u3002", (Throwable)e);
        }
        catch (KeyStoreException e) {
            log.error("\u521d\u59cb\u5316HttpClient\u5931\u8d25:KeyStoreException,\u7cfb\u7edf\u5c06\u65e0\u6cd5\u542f\u52a8\u3002\u8fd9\u4e2a\u9519\u8bef\u662f\u7531KeyStoreException\u5bfc\u81f4\uff0c\u8bf7\u68c0\u67e5x509\u6709\u5173\u73af\u5883\u548cjdk\u3002", (Throwable)e);
        }
        catch (KeyManagementException e) {
            log.error("\u521d\u59cb\u5316HttpClient\u5931\u8d25:KeyManagementException,\u7cfb\u7edf\u5c06\u65e0\u6cd5\u542f\u52a8\u3002\u8fd9\u4e2a\u9519\u8bef\u662f\u7531KeyManagementException\u5bfc\u81f4\uff0c\u8bf7\u68c0\u67e5x509\u6709\u5173\u73af\u5883\u548cjdk\u3002", (Throwable)e);
        }
    }

    public static String sendPost(String url, Map<String, String> headers, JSONObject data) {
        return HttpClientUtil.sendPost(url, headers, data, encoding, msg -> log.info("\u610f\u5916\u63a5\u6536\u5230\u6d88\u606f:{}", msg));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPost(String url, Map<String, String> headers, JSONObject data, String encoding, Consumer<String> callback) {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u5165\u53c2\uff1a\nheaders={}, \nURL={}, \ndata={}", new Object[]{JSONUtil.toJsonStr(headers), url, JSONUtil.toJsonStr((JSON)data)});
        }
        HttpPost httpPost = new HttpPost();
        try {
            if (url != null) {
                httpPost.setURI(new URI(url));
            }
            if (headers != null) {
                headers.forEach((arg_0, arg_1) -> ((HttpPost)httpPost).setHeader(arg_0, arg_1));
            }
            if (data != null) {
                StringEntity entity = new StringEntity(JSONUtil.toJsonStr((JSON)data), encoding);
                httpPost.setEntity((HttpEntity)entity);
            }
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                int status = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    String string = String.valueOf(status);
                    return string;
                }
                if (HttpClientUtil.isStreamResponse(response, entity)) {
                    log.debug("\u54cd\u5e94\u4e3a\u6d41\u5f0f");
                    HttpClientUtil.processStreamResponse(entity.getContent(), encoding, callback);
                    String string = String.valueOf(status);
                    return string;
                }
                String string = HttpClientUtil.parseData(response);
                return string;
            }
        }
        catch (Exception e) {
            StringBuilder errmsg = new StringBuilder();
            errmsg.append("\u53d1\u9001POST\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42\u4fe1\u606f\u5982\u4e0b:\n");
            errmsg.append("[URL]\n").append(url).append("\n");
            errmsg.append("[Headers]\n").append(JSONUtil.toJsonStr(headers)).append("\n");
            errmsg.append("[Request]\n").append(JSONUtil.toJsonStr((JSON)data)).append("\n");
            errmsg.append("[Encoding]\n").append(encoding).append("\n");
            errmsg.append("[Exception]\n").append(e.getMessage());
            throw new RuntimeException(errmsg.toString());
        }
    }

    private static boolean isStreamResponse(CloseableHttpResponse response, HttpEntity entity) {
        Header contentType = response.getFirstHeader("Content-Type");
        return contentType != null && contentType.getValue().contains("text/event-stream");
    }

    public static String parseData(CloseableHttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)encoding);
            if (log.isDebugEnabled()) {
                log.debug("\u6210\u529f\u54cd\u5e94Response\uff1a\nheaders={}, \ndata={}", (Object)JSONUtil.toJsonStr((Object)response.getAllHeaders()), (Object)JSONUtil.toJsonStr((Object)result));
            }
            return result;
        }
        String errorBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)encoding);
        OpenAiError error = null;
        if (StrUtil.isNotBlank((CharSequence)errorBody)) {
            error = (OpenAiError)JSONUtil.toBean((String)errorBody, OpenAiError.class);
        }
        if (error == null) {
            error = new OpenAiError();
            OpenAiError.OpenAiErrorDetails openAiErrorDetails = new OpenAiError.OpenAiErrorDetails();
            openAiErrorDetails.setMessage("\u672a\u77e5\u9519\u8bef\uff0cAI\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
            error.setError(openAiErrorDetails);
        }
        String errorMessage = error.getError().getMessage();
        error.getError().setMessage(errorMessage);
        throw new OpenAiHttpException(error, status);
    }

    private static void processStreamResponse(InputStream inputStream, String encoding, Consumer<String> callback) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("data: ") || line.equals("data: [DONE]")) continue;
                String data = line.substring(6);
                callback.accept(data);
            }
        }
    }

    static {
        HttpClientUtil.init();
    }
}

