/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.remote.servcie.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.icarus.sdk.llm.client.api.LLMServiceException;
import com.icarus.sdk.llm.client.api.completion.CompletionChoice;
import com.icarus.sdk.llm.client.api.completion.CompletionRequest;
import com.icarus.sdk.llm.client.api.completion.CompletionResult;
import com.icarus.sdk.llm.client.api.completion.chat.ChatCompletionRequest;
import com.icarus.sdk.llm.client.api.completion.chat.ChatCompletionResult;
import com.icarus.sdk.llm.client.api.completion.chat.SunshineGptChatCompletionRequest;
import com.icarus.sdk.llm.client.api.completion.chat.SunshineGptSimpleChatRequest;
import com.icarus.sdk.llm.client.api.completion.chat.SunshineGptSimpleChatResponse;
import com.icarus.sdk.llm.client.api.embedding.EmbeddingRequest;
import com.icarus.sdk.llm.client.api.embedding.EmbeddingResult;
import com.icarus.sdk.llm.client.entity.LLMClientParam;
import com.icarus.sdk.llm.client.entity.SunshineGptClientParam;
import com.icarus.sdk.llm.client.remote.servcie.LLMProvider;
import com.icarus.sdk.llm.client.utils.HttpClientUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SunshineGptLLMProvider
implements LLMProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SunshineGptLLMProvider.class);
    private final SunshineGptClientParam sunshineGptClientParam;
    Map<String, String> headers = new HashMap<String, String>();

    public LLMClientParam getLlmClientParam() {
        return this.sunshineGptClientParam;
    }

    public SunshineGptLLMProvider(LLMClientParam llmClientParam) {
        if (!(llmClientParam instanceof SunshineGptClientParam)) {
            throw new IllegalArgumentException("\u9633\u5149\u6b63\u8a00 GPT Provider \u9700\u8981 SunshineGptClientParam \u7c7b\u578b\u53c2\u6570");
        }
        this.sunshineGptClientParam = (SunshineGptClientParam)llmClientParam;
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Authorization", this.sunshineGptClientParam.getApiKey());
        this.headers.put("App-Id", this.sunshineGptClientParam.getAppId());
        this.headers.put("Model-Type", this.sunshineGptClientParam.getModel());
    }

    @Override
    public CompletionResult createCompletion(CompletionRequest request) {
        return this.createCompletionUsingSimpleChat(request);
    }

    @Override
    public ChatCompletionResult createChatCompletion(ChatCompletionRequest request) throws LLMServiceException {
        String baseUrl = this.sunshineGptClientParam.getBaseUrl();
        String uriPath = this.sunshineGptClientParam.getUriPath();
        if (StrUtil.isBlank((CharSequence)uriPath)) {
            uriPath = "/ai/ability/gpt/v2/chat/completions";
        }
        String url = String.format("%s%s", baseUrl, uriPath);
        SunshineGptChatCompletionRequest sunshineRequest = this.convertToSunshineRequest(request);
        log.debug("\u9633\u5149\u6b63\u8a00 GPT \u8bf7\u6c42URL: {}", (Object)url);
        log.debug("\u9633\u5149\u6b63\u8a00 GPT \u8bf7\u6c42\u4f53: {}", (Object)JSONUtil.toJsonStr((Object)sunshineRequest));
        String result = HttpClientUtil.sendPost(url, this.headers, JSONUtil.parseObj((Object)sunshineRequest));
        log.debug("\u9633\u5149\u6b63\u8a00 GPT \u54cd\u5e94: {}", (Object)result);
        if (result == null || result.trim().isEmpty()) {
            throw LLMServiceException.fromHttpError("\u9633\u5149\u6b63\u8a00 GPT \u670d\u52a1\u8fd4\u56de\u7a7a\u54cd\u5e94\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u548c\u670d\u52a1\u914d\u7f6e", "\u9633\u5149\u6b63\u8a00 GPT");
        }
        if (!ChatCompletionResult.valid(result).booleanValue()) {
            throw LLMServiceException.fromHttpError(result, "\u9633\u5149\u6b63\u8a00 GPT");
        }
        return (ChatCompletionResult)JSONUtil.toBean((String)result, ChatCompletionResult.class);
    }

    @Override
    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        throw new UnsupportedOperationException("\u9633\u5149\u6b63\u8a00 GPT \u6682\u4e0d\u652f\u6301 Embedding \u529f\u80fd");
    }

    private SunshineGptChatCompletionRequest convertToSunshineRequest(ChatCompletionRequest request) {
        String sessionId = this.generateSessionId();
        SunshineGptChatCompletionRequest.UserInfo userInfo = SunshineGptChatCompletionRequest.UserInfo.builder().userId(this.getDefaultOrThrow(this.sunshineGptClientParam.getDefaultUserId(), "\u9ed8\u8ba4\u7528\u6237ID")).userName(this.getDefaultOrThrow(this.sunshineGptClientParam.getDefaultUserName(), "\u9ed8\u8ba4\u7528\u6237\u540d\u79f0")).userDeptName(this.getDefaultOrThrow(this.sunshineGptClientParam.getDefaultUserDeptName(), "\u9ed8\u8ba4\u7528\u6237\u90e8\u95e8")).userCompany(this.getDefaultOrThrow(this.sunshineGptClientParam.getDefaultUserCompany(), "\u9ed8\u8ba4\u7528\u6237\u516c\u53f8")).build();
        SunshineGptChatCompletionRequest.SunshineGptChatCompletionRequestBuilder builder = SunshineGptChatCompletionRequest.builder().sessionId(sessionId).model(this.sunshineGptClientParam.getModel()).messages(request.getMessages()).userInfo(userInfo);
        if (request.getMaxTokens() != null) {
            builder.maxTokens(request.getMaxTokens());
        }
        if (request.getTemperature() != null) {
            builder.temperature(request.getTemperature());
        }
        if (request.getTopP() != null) {
            builder.topP(request.getTopP());
        }
        if (request.getStream() != null) {
            builder.stream(request.getStream());
        }
        if (request.getStop() != null) {
            builder.stop(request.getStop());
        }
        return builder.build();
    }

    private String generateSessionId() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + IdUtil.randomUUID().substring(0, 8);
    }

    private String getDefaultOrThrow(String value, String fieldName) {
        if (StrUtil.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("\u9633\u5149\u6b63\u8a00 GPT \u5fc5\u9700\u914d\u7f6e " + fieldName + "\uff0c\u8bf7\u5728 LLMClientParam \u4e2d\u8bbe\u7f6e\u76f8\u5e94\u7684\u9ed8\u8ba4\u503c");
        }
        return value;
    }

    private CompletionResult createCompletionUsingSimpleChat(CompletionRequest request) {
        String baseUrl = this.sunshineGptClientParam.getBaseUrl();
        String uriPath = "/ai/ability/gpt/v1/chat";
        String url = String.format("%s%s", baseUrl, uriPath);
        SunshineGptSimpleChatRequest simpleChatRequest = this.convertToSimpleChatRequest(request);
        log.debug("\u9633\u5149\u6b63\u8a00 GPT \u7b80\u5355\u5bf9\u8bdd\u8bf7\u6c42URL: {}", (Object)url);
        log.debug("\u9633\u5149\u6b63\u8a00 GPT \u7b80\u5355\u5bf9\u8bdd\u8bf7\u6c42\u4f53: {}", (Object)JSONUtil.toJsonStr((Object)simpleChatRequest));
        HashMap<String, String> simpleChatHeaders = new HashMap<String, String>(this.headers);
        String appId = StrUtil.isNotBlank((CharSequence)this.sunshineGptClientParam.getAppId()) ? this.sunshineGptClientParam.getAppId() : "\u9633\u5149\u6570\u667eLLM\u5ba2\u6237\u7aef";
        simpleChatHeaders.put("App-Id", appId);
        if (StrUtil.isNotBlank((CharSequence)this.sunshineGptClientParam.getModel())) {
            simpleChatHeaders.put("Model-Type", this.sunshineGptClientParam.getModel());
        }
        String result = HttpClientUtil.sendPost(url, simpleChatHeaders, JSONUtil.parseObj((Object)simpleChatRequest));
        SunshineGptSimpleChatResponse response = (SunshineGptSimpleChatResponse)JSONUtil.toBean((String)result, SunshineGptSimpleChatResponse.class);
        return this.convertToCompletionResult(response);
    }

    private SunshineGptSimpleChatRequest convertToSimpleChatRequest(CompletionRequest request) {
        String sessionId = this.generateSessionId();
        SunshineGptSimpleChatRequest.UserInfo userInfo = SunshineGptSimpleChatRequest.UserInfo.builder().userId(this.getDefaultOrThrow(this.sunshineGptClientParam.getDefaultUserId(), "\u9ed8\u8ba4\u7528\u6237ID")).userName(this.getDefaultOrThrow(this.sunshineGptClientParam.getDefaultUserName(), "\u9ed8\u8ba4\u7528\u6237\u540d\u79f0")).userDeptName(this.getDefaultOrThrow(this.sunshineGptClientParam.getDefaultUserDeptName(), "\u9ed8\u8ba4\u7528\u6237\u90e8\u95e8")).userCompany(this.getDefaultOrThrow(this.sunshineGptClientParam.getDefaultUserCompany(), "\u9ed8\u8ba4\u7528\u6237\u516c\u53f8")).build();
        SunshineGptSimpleChatRequest.ExtModel.ExtModelBuilder extModelBuilder = SunshineGptSimpleChatRequest.ExtModel.builder();
        if (request.getMaxTokens() != null) {
            extModelBuilder.maxTokens(request.getMaxTokens());
        }
        if (request.getTemperature() != null) {
            extModelBuilder.temperature(request.getTemperature());
        }
        if (request.getTopP() != null) {
            extModelBuilder.topP(request.getTopP());
        }
        if (request.getStream() != null) {
            extModelBuilder.stream(request.getStream());
        }
        if (request.getStop() != null) {
            extModelBuilder.stop(request.getStop());
        }
        return SunshineGptSimpleChatRequest.builder().sessionId(sessionId).input(request.getPrompt()).userInfo(userInfo).extModel(extModelBuilder.build()).build();
    }

    private CompletionResult convertToCompletionResult(SunshineGptSimpleChatResponse response) {
        if (!"200".equals(response.getCode())) {
            throw new RuntimeException("\u9633\u5149\u6b63\u8a00 GPT \u8c03\u7528\u5931\u8d25: " + response.getMsg());
        }
        CompletionResult result = new CompletionResult();
        result.setId(response.getData().getLogId());
        result.setObject("text_completion");
        result.setCreated(System.currentTimeMillis() / 1000L);
        result.setModel(response.getData().getGptModel().getValue());
        CompletionChoice choice = new CompletionChoice();
        choice.setText(response.getData().getAnswer());
        choice.setIndex(0);
        choice.setFinish_reason("stop");
        ArrayList<CompletionChoice> choices = new ArrayList<CompletionChoice>();
        choices.add(choice);
        result.setChoices(choices);
        return result;
    }
}

