/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.remote.servcie.impl;

import cn.hutool.json.JSONUtil;
import com.icarus.sdk.llm.client.api.LLMServiceException;
import com.icarus.sdk.llm.client.api.completion.CompletionRequest;
import com.icarus.sdk.llm.client.api.completion.CompletionResult;
import com.icarus.sdk.llm.client.api.completion.chat.ChatCompletionRequest;
import com.icarus.sdk.llm.client.api.completion.chat.ChatCompletionResult;
import com.icarus.sdk.llm.client.api.embedding.EmbeddingRequest;
import com.icarus.sdk.llm.client.api.embedding.EmbeddingResult;
import com.icarus.sdk.llm.client.entity.LLMClientParam;
import com.icarus.sdk.llm.client.remote.servcie.LLMProvider;
import com.icarus.sdk.llm.client.utils.HttpClientUtil;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAiLLMProvider
implements LLMProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureAiLLMProvider.class);
    private static final String API_VERSION = "openAi-api-version";
    private final LLMClientParam llmClientParam;
    private final String apiUrl;
    Map<String, String> headers = new HashMap<String, String>();

    public LLMClientParam getLlmClientParam() {
        return this.llmClientParam;
    }

    public AzureAiLLMProvider(LLMClientParam llmClientParam) {
        this.llmClientParam = llmClientParam;
        this.headers.put("content-type", "application/json;charset=utf-8");
        this.headers.put("api-key", llmClientParam.getApiKey());
        this.apiUrl = String.format("%s%s/", llmClientParam.getBaseUrl(), llmClientParam.getDeployment());
    }

    @Override
    public CompletionResult createCompletion(CompletionRequest request) {
        String url = String.format("%s%s", this.apiUrl, String.format("completions?api-version=%s", this.llmClientParam.getApiVersion()));
        String result = HttpClientUtil.sendPost(url, this.headers, JSONUtil.parseObj((Object)request));
        return (CompletionResult)JSONUtil.toBean((String)result, CompletionResult.class);
    }

    @Override
    public ChatCompletionResult createChatCompletion(ChatCompletionRequest request) throws LLMServiceException {
        String url = String.format("%s%s", this.apiUrl, String.format("chat/completions?api-version=%s", this.llmClientParam.getApiVersion()));
        String result = HttpClientUtil.sendPost(url, this.headers, JSONUtil.parseObj((Object)request));
        log.debug("AzureAi\u8fdc\u7a0b\u8c03\u7528\u54cd\u5e94: {}", (Object)result);
        if (result == null || result.trim().isEmpty()) {
            throw LLMServiceException.fromHttpError("AzureAi\u8fdc\u7a0b\u8c03\u7528\u670d\u52a1\u8fd4\u56de\u7a7a\u54cd\u5e94\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u548c\u670d\u52a1\u914d\u7f6e", "AzureAi\u8fdc\u7a0b\u8c03\u7528");
        }
        if (!ChatCompletionResult.valid(result).booleanValue()) {
            throw LLMServiceException.fromHttpError(result, "AzureAi\u8fdc\u7a0b\u8c03\u7528");
        }
        return (ChatCompletionResult)JSONUtil.toBean((String)result, ChatCompletionResult.class);
    }

    @Override
    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        String url = String.format("%s%s", this.apiUrl, String.format("embeddings?api-version=%s", this.llmClientParam.getApiVersion()));
        String result = HttpClientUtil.sendPost(url, this.headers, JSONUtil.parseObj((Object)request));
        return (EmbeddingResult)JSONUtil.toBean((String)result, EmbeddingResult.class);
    }
}

