/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.remote;

import cn.hutool.core.util.ObjectUtil;
import com.icarus.sdk.llm.client.constant.AiTypeEnum;
import com.icarus.sdk.llm.client.entity.LLMClientParam;
import com.icarus.sdk.llm.client.remote.servcie.LLMProvider;
import com.icarus.sdk.llm.client.remote.servcie.impl.AzureAiLLMProvider;
import com.icarus.sdk.llm.client.remote.servcie.impl.OpenAiLLMProvider;
import com.icarus.sdk.llm.client.remote.servcie.impl.SunshineGptLLMProvider;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLMProviderBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LLMProviderBuilder.class);
    public static Map<LLMClientParam, LLMProvider> llmClientCache = new HashMap<LLMClientParam, LLMProvider>();

    public static LLMProvider getLLMClient(LLMClientParam llmClientParam) {
        LLMProvider llmProvider = llmClientCache.get(llmClientParam);
        if (!ObjectUtil.isEmpty((Object)llmProvider)) {
            return llmProvider;
        }
        AiTypeEnum aiType = llmClientParam.getAiType();
        switch (aiType) {
            case AZURE_AI: {
                AzureAiLLMProvider azureAiLLMProvider = new AzureAiLLMProvider(llmClientParam);
                llmClientCache.put(llmClientParam, azureAiLLMProvider);
                return azureAiLLMProvider;
            }
            case OPEN_AI: {
                OpenAiLLMProvider openAiLLMProvider = new OpenAiLLMProvider(llmClientParam);
                llmClientCache.put(llmClientParam, openAiLLMProvider);
                return openAiLLMProvider;
            }
            case SUNSHINE_GPT: {
                SunshineGptLLMProvider sunshineGptLLMProvider = new SunshineGptLLMProvider(llmClientParam);
                llmClientCache.put(llmClientParam, sunshineGptLLMProvider);
                return sunshineGptLLMProvider;
            }
        }
        AzureAiLLMProvider defaultClient = new AzureAiLLMProvider(llmClientParam);
        llmClientCache.put(llmClientParam, defaultClient);
        return defaultClient;
    }
}

