/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LLMCallContext {
    private final Map<String, Object> customParams = new ConcurrentHashMap<String, Object>();
    private String sessionId;
    private UserInfo userInfo;
    private String appId;

    public LLMCallContext() {
    }

    public LLMCallContext(String sessionId) {
        this.sessionId = sessionId;
    }

    public LLMCallContext setParam(String key, Object value) {
        this.customParams.put(key, value);
        return this;
    }

    public <T> T getParam(String key) {
        return (T)this.customParams.get(key);
    }

    public <T> T getParam(String key, T defaultValue) {
        Object value = this.customParams.get(key);
        return (T)(value != null ? value : defaultValue);
    }

    public boolean hasParam(String key) {
        return this.customParams.containsKey(key);
    }

    public Map<String, Object> getAllParams() {
        return new ConcurrentHashMap<String, Object>(this.customParams);
    }

    public LLMCallContext setUserInfo(String userId, String userName, String deptName, String company) {
        this.userInfo = new UserInfo(userId, userName, deptName, company);
        return this;
    }

    public LLMCallContext setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public LLMCallContext setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public String getAppId() {
        return this.appId;
    }

    public static LLMCallContext create() {
        return new LLMCallContext();
    }

    public static LLMCallContext withSessionId(String sessionId) {
        return new LLMCallContext(sessionId);
    }

    public static LLMCallContext forSunshineGpt(String userId, String userName, String deptName, String company) {
        return new LLMCallContext().setUserInfo(userId, userName, deptName, company).setAppId("\u9633\u5149\u6570\u667aLLM\u5ba2\u6237\u7aef");
    }

    public static class UserInfo {
        private final String userId;
        private final String userName;
        private final String deptName;
        private final String company;

        public UserInfo(String userId, String userName, String deptName, String company) {
            this.userId = userId;
            this.userName = userName;
            this.deptName = deptName;
            this.company = company;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getDeptName() {
            return this.deptName;
        }

        public String getCompany() {
            return this.company;
        }
    }
}

