/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.constant;

import lombok.Generated;

public class ModelParam {
    private String modelName;
    private Double temperature = 0.7;
    private Integer maxTokens = 1024;
    private Double topP = 1.0;
    private Integer topK = 50;
    private boolean stream = false;
    private boolean think = false;
    private String stop;
    private String logitBias;

    public void setTemperature(Double temperature) {
        if (temperature != null && (temperature < 0.0 || temperature > 2.0)) {
            throw new IllegalArgumentException("Temperature must be between 0.0 and 2.0");
        }
        this.temperature = temperature;
    }

    public void setMaxTokens(Integer maxTokens) {
        if (maxTokens != null && maxTokens <= 0) {
            throw new IllegalArgumentException("MaxTokens must be a positive integer");
        }
        this.maxTokens = maxTokens;
    }

    public void setTopP(Double topP) {
        if (topP != null && (topP < 0.0 || topP > 1.0)) {
            throw new IllegalArgumentException("TopP must be between 0.0 and 1.0");
        }
        this.topP = topP;
    }

    public void setTopK(Integer topK) {
        if (topK != null && topK <= 0) {
            throw new IllegalArgumentException("TopK must be a positive integer");
        }
        this.topK = topK;
    }

    private ModelParam() {
    }

    @Generated
    public static ModelParamBuilder builder() {
        return new ModelParamBuilder();
    }

    @Generated
    public ModelParamBuilder toBuilder() {
        return new ModelParamBuilder().modelName(this.modelName).temperature(this.temperature).maxTokens(this.maxTokens).topP(this.topP).topK(this.topK).stream(this.stream).think(this.think).stop(this.stop).logitBias(this.logitBias);
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    @Generated
    public Double getTopP() {
        return this.topP;
    }

    @Generated
    public Integer getTopK() {
        return this.topK;
    }

    @Generated
    public boolean isStream() {
        return this.stream;
    }

    @Generated
    public boolean isThink() {
        return this.think;
    }

    @Generated
    public String getStop() {
        return this.stop;
    }

    @Generated
    public String getLogitBias() {
        return this.logitBias;
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Generated
    public void setStream(boolean stream) {
        this.stream = stream;
    }

    @Generated
    public void setThink(boolean think) {
        this.think = think;
    }

    @Generated
    public void setStop(String stop) {
        this.stop = stop;
    }

    @Generated
    public void setLogitBias(String logitBias) {
        this.logitBias = logitBias;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelParam)) {
            return false;
        }
        ModelParam other = (ModelParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (this.isThink() != other.isThink()) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$stop = this.getStop();
        String other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !this$stop.equals(other$stop)) {
            return false;
        }
        String this$logitBias = this.getLogitBias();
        String other$logitBias = other.getLogitBias();
        return !(this$logitBias == null ? other$logitBias != null : !this$logitBias.equals(other$logitBias));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModelParam;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStream() ? 79 : 97);
        result = result * 59 + (this.isThink() ? 79 : 97);
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : $stop.hashCode());
        String $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : $logitBias.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ModelParam(modelName=" + this.getModelName() + ", temperature=" + this.getTemperature() + ", maxTokens=" + this.getMaxTokens() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", stream=" + this.isStream() + ", think=" + this.isThink() + ", stop=" + this.getStop() + ", logitBias=" + this.getLogitBias() + ")";
    }

    @Generated
    public ModelParam(String modelName, Double temperature, Integer maxTokens, Double topP, Integer topK, boolean stream, boolean think, String stop, String logitBias) {
        this.modelName = modelName;
        this.temperature = temperature;
        this.maxTokens = maxTokens;
        this.topP = topP;
        this.topK = topK;
        this.stream = stream;
        this.think = think;
        this.stop = stop;
        this.logitBias = logitBias;
    }

    public static class ModelParamBuilder {
        @Generated
        private String modelName;
        @Generated
        private Double temperature;
        @Generated
        private Integer maxTokens;
        @Generated
        private Double topP;
        @Generated
        private Integer topK;
        @Generated
        private boolean stream;
        @Generated
        private boolean think;
        @Generated
        private String stop;
        @Generated
        private String logitBias;

        public ModelParam build() {
            return new ModelParam(this.modelName, this.temperature, this.maxTokens, this.topP, this.topK, this.stream, this.think, this.stop, this.logitBias);
        }

        @Generated
        ModelParamBuilder() {
        }

        @Generated
        public ModelParamBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public ModelParamBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public ModelParamBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Generated
        public ModelParamBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public ModelParamBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        @Generated
        public ModelParamBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public ModelParamBuilder think(boolean think) {
            this.think = think;
            return this;
        }

        @Generated
        public ModelParamBuilder stop(String stop) {
            this.stop = stop;
            return this;
        }

        @Generated
        public ModelParamBuilder logitBias(String logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        @Generated
        public String toString() {
            return "ModelParam.ModelParamBuilder(modelName=" + this.modelName + ", temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ", topP=" + this.topP + ", topK=" + this.topK + ", stream=" + this.stream + ", think=" + this.think + ", stop=" + this.stop + ", logitBias=" + this.logitBias + ")";
        }
    }
}

