/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.cfg;

import com.icarus.sdk.llm.client.cfg.LLMClientConfigExtender;
import com.icarus.sdk.llm.client.cfg.SunshineGptConfig;
import com.icarus.sdk.llm.client.context.LLMCallContext;
import com.icarus.sdk.llm.client.entity.LLMClientParam;
import com.icarus.sdk.llm.client.entity.SunshineGptClientParam;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="sunshine-gpt")
public class SunshineGptConfigExtender
extends SunshineGptConfig
implements LLMClientConfigExtender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SunshineGptConfigExtender.class);

    @Override
    public boolean supports(String modelName) {
        boolean supported = this.getModels().containsKey(modelName);
        if (supported) {
            log.debug("\u9633\u5149GPT\u6269\u5c55\u5668\u652f\u6301\u6a21\u578b: {}", (Object)modelName);
        }
        return supported;
    }

    @Override
    public LLMClientParam getExtendedClientParam(String modelName, LLMCallContext context) {
        if (!this.supports(modelName)) {
            return null;
        }
        SunshineGptConfig.SunshineGptModelConfig modelConfig = this.getModels().get(modelName);
        SunshineGptClientParam param = modelConfig.toSunshineGptClientParam();
        if (context != null) {
            this.enhanceWithContext(param, context);
        }
        log.debug("\u4f7f\u7528\u9633\u5149GPT\u6269\u5c55\u5668\u83b7\u53d6\u6a21\u578b {} \u7684\u914d\u7f6e", (Object)modelName);
        return param;
    }

    private void enhanceWithContext(SunshineGptClientParam param, LLMCallContext context) {
        if (context.getUserInfo() != null) {
            LLMCallContext.UserInfo userInfo = context.getUserInfo();
            param.setDefaultUserId(userInfo.getUserId());
            param.setDefaultUserName(userInfo.getUserName());
            param.setDefaultUserDeptName(userInfo.getDeptName());
            param.setDefaultUserCompany(userInfo.getCompany());
            log.debug("\u4f7f\u7528\u4e0a\u4e0b\u6587\u7528\u6237\u4fe1\u606f: {}", (Object)userInfo.getUserName());
        }
        if (context.getAppId() != null) {
            param.setAppId(context.getAppId());
            log.debug("\u4f7f\u7528\u4e0a\u4e0b\u6587\u5e94\u7528ID: {}", (Object)context.getAppId());
        }
        if (context.hasParam("baseUrl")) {
            param.setBaseUrl((String)context.getParam("baseUrl"));
        }
        if (context.hasParam("apiKey")) {
            param.setApiKey((String)context.getParam("apiKey"));
        }
        if (context.hasParam("uriPath")) {
            param.setUriPath((String)context.getParam("uriPath"));
        }
        log.debug("\u4f7f\u7528\u4e0a\u4e0b\u6587\u53c2\u6570\u589e\u5f3a\u914d\u7f6e\uff0c\u53c2\u6570\u6570\u91cf: {}", (Object)context.getAllParams().size());
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public String getName() {
        return "\u9633\u5149GPT\u6269\u5c55\u5668";
    }
}

