/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.api.utils;

import com.icarus.sdk.llm.client.api.completion.chat.ChatMessage;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.EncodingType;
import com.knuddels.jtokkit.api.ModelType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class TikTokensUtil {
    private static final Map<String, Encoding> modelMap = new HashMap<String, Encoding>();
    private static final EncodingRegistry registry = Encodings.newDefaultEncodingRegistry();

    public static List<Integer> encode(Encoding enc, String text) {
        return TikTokensUtil.isBlank(text) ? new ArrayList() : enc.encode(text);
    }

    public static int tokens(Encoding enc, String text) {
        return TikTokensUtil.encode(enc, text).size();
    }

    public static String decode(Encoding enc, List<Integer> encoded) {
        return enc.decode(encoded);
    }

    public static Encoding getEncoding(EncodingType encodingType) {
        Encoding enc = registry.getEncoding(encodingType);
        return enc;
    }

    public static List<Integer> encode(EncodingType encodingType, String text) {
        if (TikTokensUtil.isBlank(text)) {
            return new ArrayList<Integer>();
        }
        Encoding enc = TikTokensUtil.getEncoding(encodingType);
        List encoded = enc.encode(text);
        return encoded;
    }

    public static int tokens(EncodingType encodingType, String text) {
        return TikTokensUtil.encode(encodingType, text).size();
    }

    public static String decode(EncodingType encodingType, List<Integer> encoded) {
        Encoding enc = TikTokensUtil.getEncoding(encodingType);
        return enc.decode(encoded);
    }

    public static Encoding getEncoding(String modelName) {
        return modelMap.get(modelName);
    }

    public static List<Integer> encode(String modelName, String text) {
        if (TikTokensUtil.isBlank(text)) {
            return new ArrayList<Integer>();
        }
        Encoding enc = TikTokensUtil.getEncoding(modelName);
        if (Objects.isNull(enc)) {
            return new ArrayList<Integer>();
        }
        List encoded = enc.encode(text);
        return encoded;
    }

    public static int tokens(String modelName, String text) {
        return TikTokensUtil.encode(modelName, text).size();
    }

    public static int tokens(String modelName, List<ChatMessage> messages) {
        Encoding encoding = TikTokensUtil.getEncoding(modelName);
        int tokensPerMessage = 0;
        int tokensPerName = 0;
        if (modelName.equals("gpt-3.5-turbo-0301") || modelName.equals("gpt-3.5-turbo")) {
            tokensPerMessage = 4;
            tokensPerName = -1;
        }
        if (modelName.equals("gpt-4") || modelName.equals("gpt-4-0314")) {
            tokensPerMessage = 3;
            tokensPerName = 1;
        }
        int sum = 0;
        for (ChatMessage msg : messages) {
            sum += tokensPerMessage;
            sum += TikTokensUtil.tokens(encoding, msg.getContent().toString());
            sum += TikTokensUtil.tokens(encoding, msg.getRole());
        }
        return sum += 3;
    }

    public static String decode(String modelName, List<Integer> encoded) {
        Encoding enc = TikTokensUtil.getEncoding(modelName);
        return enc.decode(encoded);
    }

    public static ModelType getModelTypeByName(String name) {
        if (ModelEnum.GPT_3_5_TURBO_0301.getName().equals(name)) {
            return ModelType.GPT_3_5_TURBO;
        }
        if (ModelEnum.GPT_4.getName().equals(name) || ModelEnum.GPT_4_32K.getName().equals(name) || ModelEnum.GPT_4_32K_0314.getName().equals(name) || ModelEnum.GPT_4_0314.getName().equals(name)) {
            return ModelType.GPT_4;
        }
        for (ModelType modelType : ModelType.values()) {
            if (!modelType.getName().equals(name)) continue;
            return modelType;
        }
        return null;
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0 || c == 12644 || c == 10240 || c == 6158;
    }

    public static boolean isBlankChar(char c) {
        return TikTokensUtil.isBlankChar((int)c);
    }

    public static boolean isNotBlank(CharSequence str) {
        return !TikTokensUtil.isBlank(str);
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str != null && (length = str.length()) != 0) {
            for (int i = 0; i < length; ++i) {
                if (TikTokensUtil.isBlankChar(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    static {
        for (ModelType modelType : ModelType.values()) {
            modelMap.put(modelType.getName(), registry.getEncodingForModel(modelType));
        }
        modelMap.put(ModelEnum.GPT_3_5_TURBO_0301.getName(), registry.getEncodingForModel(ModelType.GPT_3_5_TURBO));
        modelMap.put(ModelEnum.GPT_4_32K.getName(), registry.getEncodingForModel(ModelType.GPT_4));
        modelMap.put(ModelEnum.GPT_4_32K_0314.getName(), registry.getEncodingForModel(ModelType.GPT_4));
        modelMap.put(ModelEnum.GPT_4_0314.getName(), registry.getEncodingForModel(ModelType.GPT_4));
        modelMap.put(ModelEnum.GPT_4_1106_preview.getName(), registry.getEncodingForModel(ModelType.GPT_4));
    }

    public static enum ModelEnum {
        GPT_3_5_TURBO("gpt-3.5-turbo"),
        GPT_3_5_TURBO_0301("gpt-3.5-turbo-0301"),
        GPT_4("gpt-4"),
        GPT_4_0314("gpt-4-0314"),
        GPT_4_32K("gpt-4-32k"),
        GPT_4_32K_0314("gpt-4-32k-0314"),
        GPT_4_1106_preview("gpt-4-1106-preview");

        private String name;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        private ModelEnum(String name) {
            this.name = name;
        }
    }
}

