/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client.api.completion.chat;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.icarus.sdk.llm.client.api.completion.chat.ChatFunctionCall;
import lombok.Generated;
import lombok.NonNull;

public class ChatMessage {
    @NonNull
    String role;
    @JsonInclude
    Object content;
    String reasoning_content;
    @JsonProperty(value="function_call")
    ChatFunctionCall functionCall;

    public ChatMessage(String content) {
        this.role = "user";
        this.content = content;
    }

    public ChatMessage(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public void attachImageUrl(String imageUrl) {
        if (this.content instanceof JSONArray) {
            JSONArray ret = new JSONArray(this.content);
            JSONObject url = new JSONObject();
            url.set("url", (Object)imageUrl);
            ret.add((Object)new JSONObject().set("type", (Object)"image_url").set("image_url", (Object)url));
            this.content = ret;
        } else {
            JSONArray ret = new JSONArray();
            JSONObject url = new JSONObject();
            url.set("url", (Object)imageUrl);
            ret.add((Object)new JSONObject().set("type", (Object)"text").set("text", (Object)this.content.toString()));
            ret.add((Object)new JSONObject().set("type", (Object)"image_url").set("image_url", (Object)url));
            this.content = ret;
        }
    }

    public void attachImageBase64(String imageBase64) {
        if (this.content instanceof JSONArray) {
            JSONArray ret = new JSONArray(this.content);
            ret.add((Object)new JSONObject().putOnce("type", (Object)"image_url").putOnce("image_url", (Object)("data:image/jpeg;base64," + imageBase64)));
            this.content = ret;
        } else {
            JSONArray ret = new JSONArray();
            ret.add((Object)new JSONObject().putOnce("type", (Object)"text").putOnce("text", this.content));
            ret.add((Object)new JSONObject().putOnce("type", (Object)"image_url").putOnce("image_url", (Object)("data:image/jpeg;base64," + imageBase64)));
            this.content = ret;
        }
    }

    @NonNull
    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public Object getContent() {
        return this.content;
    }

    @Generated
    public String getReasoning_content() {
        return this.reasoning_content;
    }

    @Generated
    public ChatFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    @Generated
    public void setRole(@NonNull String role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    @Generated
    public void setContent(Object content) {
        this.content = content;
    }

    @Generated
    public void setReasoning_content(String reasoning_content) {
        this.reasoning_content = reasoning_content;
    }

    @JsonProperty(value="function_call")
    @Generated
    public void setFunctionCall(ChatFunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        Object this$content = this.getContent();
        Object other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$reasoning_content = this.getReasoning_content();
        String other$reasoning_content = other.getReasoning_content();
        if (this$reasoning_content == null ? other$reasoning_content != null : !this$reasoning_content.equals(other$reasoning_content)) {
            return false;
        }
        ChatFunctionCall this$functionCall = this.getFunctionCall();
        ChatFunctionCall other$functionCall = other.getFunctionCall();
        return !(this$functionCall == null ? other$functionCall != null : !((Object)this$functionCall).equals(other$functionCall));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        Object $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $reasoning_content = this.getReasoning_content();
        result = result * 59 + ($reasoning_content == null ? 43 : $reasoning_content.hashCode());
        ChatFunctionCall $functionCall = this.getFunctionCall();
        result = result * 59 + ($functionCall == null ? 43 : ((Object)$functionCall).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChatMessage(role=" + this.getRole() + ", content=" + this.getContent() + ", reasoning_content=" + this.getReasoning_content() + ", functionCall=" + this.getFunctionCall() + ")";
    }

    @Generated
    public ChatMessage() {
    }

    @Generated
    public ChatMessage(@NonNull String role, Object content, String reasoning_content, ChatFunctionCall functionCall) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
        this.content = content;
        this.reasoning_content = reasoning_content;
        this.functionCall = functionCall;
    }
}

