/*
 * Decompiled with CFR 0.152.
 */
package com.icarus.sdk.llm.client;

import com.icarus.sdk.llm.client.api.LLMServiceException;
import com.icarus.sdk.llm.client.api.completion.CompletionRequest;
import com.icarus.sdk.llm.client.api.completion.CompletionResult;
import com.icarus.sdk.llm.client.api.completion.chat.ChatCompletionRequest;
import com.icarus.sdk.llm.client.api.completion.chat.ChatCompletionResult;
import com.icarus.sdk.llm.client.api.embedding.Embedding;
import com.icarus.sdk.llm.client.api.embedding.EmbeddingRequest;
import com.icarus.sdk.llm.client.api.embedding.EmbeddingResult;
import com.icarus.sdk.llm.client.remote.servcie.LLMProvider;
import com.icarus.sdk.llm.client.remote.servcie.proxy.LLMClientProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLMClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LLMClient.class);
    private LLMProvider llmProvider;

    public LLMClient(LLMProvider llmProvider) {
        LLMClientProxy handler = new LLMClientProxy(llmProvider);
        this.llmProvider = llmProvider = (LLMProvider)Proxy.newProxyInstance(LLMProvider.class.getClassLoader(), new Class[]{LLMProvider.class}, (InvocationHandler)handler);
    }

    public LLMClient() {
    }

    public List<Embedding> runEmbedding(EmbeddingRequest embeddingRequest) {
        EmbeddingResult embeddings = this.llmProvider.createEmbeddings(embeddingRequest);
        return embeddings.getData();
    }

    public String runCompletion(CompletionRequest completionRequest) {
        CompletionResult completion = this.llmProvider.createCompletion(completionRequest);
        return completion.getChoices().get(0).getText();
    }

    public String runChatCompletion(ChatCompletionRequest chatCompletionRequest) {
        try {
            ChatCompletionResult chatCompletionResult = this.llmProvider.createChatCompletion(chatCompletionRequest);
            return chatCompletionResult.getChoices().get(0).getMessage().getContent().toString();
        }
        catch (LLMServiceException e) {
            log.error("ChatCompletionResult error, content : {}", (Object)e.getRawResponse());
            return e.getRawResponse();
        }
        catch (Exception e) {
            log.error("ChatCompletionResult error, content : {}", (Object)e.getMessage());
            return "\u6a21\u578b\u8c03\u7528\u53d1\u751f\u672a\u77e5\u9519\u8bef" + e.getMessage();
        }
    }
}

