/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.cloud.swagger;

import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringValidator;
import com.lc.ibps.cloud.config.DocumentSwaggerConfig;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Configuration
@Component
@Primary
public class DocumentationConfig
implements SwaggerResourcesProvider {
    private static Logger logger = LoggerFactory.getLogger(DocumentationConfig.class);
    @Autowired
    private DocumentSwaggerConfig swaggerConfig;
    private final RouteLocator routeLocator;

    public DocumentationConfig(RouteLocator routeLocator) {
        this.routeLocator = routeLocator;
    }

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        List routes = this.routeLocator.getRoutes();
        if (BeanUtils.isEmpty((Object)routes)) {
            return resources;
        }
        for (Route route : routes) {
            if (route.getPrefix().endsWith(route.getLocation()) || this.isIgnore(route.getId())) continue;
            logger.debug("route id {}, route full path {}, route full path replace {}, version {}.", new Object[]{route.getId(), route.getFullPath(), route.getFullPath().replace("**", this.swaggerConfig.getDocs()), this.swaggerConfig.getVersion()});
            resources.add(this.swaggerResource(route.getId(), route.getFullPath().replace("**", this.swaggerConfig.getDocs()), this.swaggerConfig.getVersion()));
        }
        return resources;
    }

    private SwaggerResource swaggerResource(String name, String location, String version) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion(version);
        return swaggerResource;
    }

    private boolean isIgnore(String routeId) {
        if (BeanUtils.isEmpty(this.swaggerConfig.getIgnoreRoutes())) {
            return false;
        }
        if (this.swaggerConfig.getIgnoreRoutes().contains(routeId)) {
            return true;
        }
        for (String ignoreRoute : this.swaggerConfig.getIgnoreRoutes()) {
            if (!StringValidator.valid((String)ignoreRoute, (String)routeId)) continue;
            return true;
        }
        return false;
    }
}

