/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.cloud.gateway.filter;

import com.lc.ibps.api.base.constants.StateEnum;
import com.lc.ibps.base.core.util.JacksonUtil;
import com.lc.ibps.cloud.config.IpConfig;
import com.lc.ibps.cloud.entity.APIResult;
import com.lc.ibps.cloud.utils.RequestUtil;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IpFilter
extends ZuulFilter {
    private static final Logger logger = LoggerFactory.getLogger(IpFilter.class);
    @Autowired
    private IpConfig ipConfig;

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        if (logger.isDebugEnabled()) {
            logger.debug("running black filter.");
        }
        String ip = RequestUtil.getIpAddr((HttpServletRequest)ctx.getRequest());
        boolean isWhite = this.ipConfig.isWhite(ip);
        if (logger.isDebugEnabled()) {
            logger.debug("white ip list is {}.", (Object)JacksonUtil.toJsonString(this.ipConfig.getWhite()));
        }
        boolean isBlack = this.ipConfig.isBlack(ip);
        if (logger.isDebugEnabled()) {
            logger.debug("black ip list is {}.", (Object)JacksonUtil.toJsonString(this.ipConfig.getBlack()));
        }
        if (!isWhite && isBlack) {
            ctx.setSendZuulResponse(false);
            ctx.setResponseStatusCode(401);
            APIResult result = new APIResult();
            result.setState(StateEnum.ILLEGAL_IP.getCode());
            result.setCause("IpAddr is forbidden!");
            ctx.getResponse().setContentType("application/json;charset=UTF-8");
            ctx.setResponseBody(result.toString());
            ctx.set("isSuccess", (Object)false);
            logger.warn("IpAddr {} is forbidden!", (Object)ip);
        }
        return null;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.containsKey((Object)"isSuccess") && null != ctx.get((Object)"isSuccess") && (Boolean)ctx.get((Object)"isSuccess") != false;
    }

    public int filterOrder() {
        return -2147483638;
    }

    public String filterType() {
        return "pre";
    }
}

