/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.cloud.gateway.filter;

import com.lc.ibps.base.core.monitor.StopWatchUtil;
import com.lc.ibps.cloud.config.ApplicationConfig;
import com.lc.ibps.cloud.request.RequestLocal;
import com.lc.ibps.cloud.utils.RequestUtil;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.ribbon.RibbonHttpResponse;
import org.springframework.util.StreamUtils;

public class GatewayPostFilter
extends ZuulFilter {
    private static final Logger logger = LoggerFactory.getLogger(GatewayPostFilter.class);
    @Value(value="${logButton.request.button:'false'}")
    private String requestButton;
    @Value(value="${logButton.request.parameterButton.request:'false'}")
    private String parameterButtonReq;
    @Value(value="${logButton.request.parameterButton.response:'false'}")
    private String parameterButtonRes;
    @Autowired
    private ApplicationConfig applicationConfig;

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        String ip = RequestUtil.getIpAddr((HttpServletRequest)ctx.getRequest());
        String uri = ctx.getRequest().getRequestURI();
        StopWatchUtil.stopAndPrint((String)("zuul.filter." + uri));
        if (logger.isDebugEnabled()) {
            logger.debug("running gateway post filter.");
            logger.debug("request ip {}.", (Object)ip);
        }
        if ("true".equalsIgnoreCase(this.requestButton)) {
            long startTime = (Long)ctx.get((Object)"start_time");
            String reqParams = "\u8bf7\u6c42\u53c2\u6570\u5173\u95ed";
            if (!"false".equalsIgnoreCase(this.parameterButtonReq)) {
                if ("GET".equalsIgnoreCase(ctx.getRequest().getMethod())) {
                    Map<String, String> rtnMap = this.converMap(ctx.getRequest().getParameterMap());
                    reqParams = String.valueOf(JSONObject.fromObject(rtnMap));
                }
                if ("POST".equalsIgnoreCase(ctx.getRequest().getMethod())) {
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader((InputStream)ctx.getRequest().getInputStream(), "UTF-8"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    String line = null;
                    StringBuilder sb = new StringBuilder();
                    try {
                        while ((line = br.readLine()) != null) {
                            sb.append(line);
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    reqParams = sb.toString();
                }
            }
            String resParams = "\u8fd4\u56de\u53c2\u6570\u5173\u95ed";
            if (!"false".equalsIgnoreCase(this.parameterButtonRes)) {
                InputStream inputStream = RequestContext.getCurrentContext().getResponseDataStream();
                try {
                    byte[] bytes = StreamUtils.copyToByteArray((InputStream)inputStream);
                    RequestContext.getCurrentContext().setResponseDataStream((InputStream)new ByteArrayInputStream(bytes));
                    Boolean responseFlag = false;
                    Object zuulResponse = ctx.get((Object)"zuulResponse");
                    if (zuulResponse != null) {
                        RibbonHttpResponse resp = (RibbonHttpResponse)zuulResponse;
                        String type = ((RibbonHttpResponse)zuulResponse).getHeaders().getContentType().getType();
                        String subType = ((RibbonHttpResponse)zuulResponse).getHeaders().getContentType().getSubtype();
                        resParams = "application".equals(type) ? ("json".equals(subType) ? new String(bytes, "UTF-8") : "\u975ejson\u6570\u636e\uff0c\u4e0d\u8f93\u51fa") : "\u975ejson\u6570\u636e\uff0c\u4e0d\u8f93\u51fa";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            logger.info("\u3010requestTime\u3011:{} --- \u3010modules\u3011:{} --- \u3010URL\u3011:{} --- \u3010request parameter\u3011:{} --- \u3010response parameter\u3011:{} --- \u3010resTime\u3011:{}ms", new Object[]{new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss").format(startTime), ctx.get((Object)"serviceId"), uri, reqParams, resParams, System.currentTimeMillis() - startTime});
        }
        if (this.applicationConfig.isRibbonProxy()) {
            RequestLocal.remove();
        }
        return null;
    }

    private String read(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8.name());
    }

    public Map<String, String> converMap(Map<String, String[]> paramMap) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        for (String key : paramMap.keySet()) {
            rtnMap.put(key, paramMap.get(key)[0]);
        }
        return rtnMap;
    }

    public boolean shouldFilter() {
        return true;
    }

    public int filterOrder() {
        return Integer.MIN_VALUE;
    }

    public String filterType() {
        return "post";
    }
}

