/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.cloud.gateway.filter;

import cn.hutool.core.lang.UUID;
import com.lc.ibps.base.core.monitor.StopWatchUtil;
import com.lc.ibps.cloud.config.ApplicationConfig;
import com.lc.ibps.cloud.request.RequestLocal;
import com.lc.ibps.cloud.request.RequestLocalModel;
import com.lc.ibps.cloud.utils.RequestUtil;
import com.lc.ibps.cloud.utils.SecrectUtil;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;

public class GatewayFilter
extends ZuulFilter {
    private static final Logger logger = LoggerFactory.getLogger(GatewayFilter.class);
    @Autowired
    private ApplicationConfig applicationConfig;

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        String ip = RequestUtil.getIpAddr((HttpServletRequest)ctx.getRequest());
        String uri = ctx.getRequest().getRequestURI();
        long startTime = System.currentTimeMillis();
        ctx.set("start_time", (Object)startTime);
        if (logger.isDebugEnabled()) {
            logger.debug("running gateway filter.");
            logger.debug("request ip {}.", (Object)ip);
            logger.debug("request uri {}.", (Object)uri);
        }
        StopWatchUtil.initAndStart((String)UUID.fastUUID().toString(true), (Level)Level.DEBUG, (String)("zuul.filter." + uri), (String)uri);
        if (this.applicationConfig.isRibbonProxy()) {
            RequestLocalModel current = new RequestLocalModel();
            current.setIp(ip);
            RequestLocal.setCurrent((RequestLocalModel)current);
        }
        ctx.setSendZuulResponse(true);
        ctx.setResponseStatusCode(200);
        ctx.set("isSuccess", (Object)true);
        ctx.addZuulRequestHeader("X-Authorization-gateway", SecrectUtil.getGatewaySecretValue());
        ctx.addZuulRequestHeader("X-Authorization-client", ip);
        ctx.addZuulRequestHeader("X-Authorization-method", ctx.getRequest().getMethod().toLowerCase());
        String attributeName = "org.springframework.web.servlet.HandlerMapping.bestMatchingPattern";
        String routeValue = Optional.ofNullable(ctx.getRequest().getAttribute(attributeName)).orElse("").toString();
        logger.debug("{}={}", (Object)attributeName, (Object)routeValue);
        routeValue = routeValue.replace("/\\?", "");
        logger.debug("{}={}", (Object)attributeName, (Object)routeValue);
        routeValue = routeValue.replace("/**", "");
        logger.debug("{}={}", (Object)attributeName, (Object)routeValue);
        routeValue = routeValue.replace("/*", "");
        logger.debug("{}={}", (Object)attributeName, (Object)routeValue);
        ctx.addZuulRequestHeader("X-Authorization-api-prefix", routeValue);
        return null;
    }

    public boolean shouldFilter() {
        return true;
    }

    public int filterOrder() {
        return Integer.MIN_VALUE;
    }

    public String filterType() {
        return "pre";
    }
}

