/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.cloud.gateway.filter;

import com.lc.ibps.api.base.constants.StateEnum;
import com.lc.ibps.base.core.util.JacksonUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.cloud.config.AuthorizationConfig;
import com.lc.ibps.cloud.config.SSOConfig;
import com.lc.ibps.cloud.entity.APIResult;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessTokenFilter
extends ZuulFilter {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenFilter.class);
    @Autowired
    private AuthorizationConfig authorizationConfig;
    @Autowired
    private SSOConfig ssoConfig;

    public Object run() {
        String accessToken;
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        if (logger.isDebugEnabled()) {
            logger.debug("Running AccessTokenFilter.");
        }
        String uri = request.getRequestURI();
        logger.debug("AccessTokenFilter uri is {}.", (Object)uri);
        Enumeration headers = request.getHeaderNames();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            headerMap.put(headerName, request.getHeader(headerName));
        }
        logger.debug("AccessTokenFilter headers is {}.", (Object)JacksonUtil.toJsonString(headerMap));
        logger.debug("AccessTokenFilter paramters is {}.", (Object)JacksonUtil.toJsonString((Object)request.getParameterMap()));
        this.ssoConfig.getCasUserInfoAndRedirectFront(request, ctx, uri);
        if (!this.authorizationConfig.isEnable() || !this.authorizationConfig.isAccessTokenFilterEnable() || this.authorizationConfig.isIgnoreUrl(uri)) {
            ctx.setSendZuulResponse(true);
            ctx.setResponseStatusCode(200);
            ctx.set("isSuccess", (Object)true);
            return null;
        }
        String accessTokenHeader = request.getHeader("X-Authorization-access_token");
        String accessTokenParameter = request.getParameter("access_token");
        Object object = StringUtil.isBlank((CharSequence)accessTokenHeader) ? (StringUtil.isBlank((CharSequence)accessTokenParameter) ? null : accessTokenParameter) : (accessToken = accessTokenHeader);
        if (null != accessToken) {
            ctx.setSendZuulResponse(true);
            ctx.setResponseStatusCode(200);
            ctx.set("isSuccess", (Object)true);
        } else {
            ctx.setSendZuulResponse(false);
            ctx.setResponseStatusCode(401);
            APIResult result = new APIResult();
            result.setState(StateEnum.ILLEGAL_TOKEN.getCode());
            result.setCause("access token is not correct!");
            ctx.getResponse().setContentType("application/json;charset=UTF-8");
            ctx.setResponseBody(result.toString());
            ctx.set("isSuccess", (Object)false);
        }
        return null;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.containsKey((Object)"isSuccess") && null != ctx.get((Object)"isSuccess") && (Boolean)ctx.get((Object)"isSuccess") != false;
    }

    public int filterOrder() {
        return -2147483618;
    }

    public String filterType() {
        return "pre";
    }
}

