/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.cloud.gateway.fallback;

import com.lc.ibps.api.base.constants.StateEnum;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.cloud.entity.APIResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.zuul.filters.route.FallbackProvider;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;

public class DefaultFallbackProvider
implements FallbackProvider {
    private static Logger logger = LoggerFactory.getLogger(DefaultFallbackProvider.class);
    private static final String DEFAULT_ROUTE = "*";
    private String route;
    @Value(value="${logButton.exception.button}")
    private String exceptionButton;

    public void setRoute(String route) {
        this.route = route;
    }

    public String getRoute() {
        if (StringUtil.isBlank((CharSequence)this.route)) {
            this.route = DEFAULT_ROUTE;
        }
        logger.debug("route = {}.", (Object)this.route);
        return this.route;
    }

    public ClientHttpResponse fallbackResponse(String route, final Throwable cause) {
        logger.debug("cause is {}null.", (Object)(cause == null ? "" : "not "));
        logger.debug("\u670d\u52a1\u3010{}\u3011\u4e0d\u53ef\u7528", (Object)this.getRoute(), (Object)cause);
        if ("true".equals(this.exceptionButton)) {
            logger.error("\u3010time\u3011\uff1a{} --- \u3010\u4e0d\u53ef\u7528\u670d\u52a1\u3011\uff1a{} ---  \u3010exceptionType\u3011\uff1a{} --- \u3010exception\u3011\uff1a{}", new Object[]{new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss").format(new Date()), this.getRoute(), cause.getClass().getName(), cause.getMessage()});
        }
        return new ClientHttpResponse(){

            public HttpStatus getStatusCode() throws IOException {
                return HttpStatus.OK;
            }

            public int getRawStatusCode() throws IOException {
                return this.getStatusCode().value();
            }

            public String getStatusText() throws IOException {
                return this.getStatusCode().getReasonPhrase();
            }

            public void close() {
            }

            public InputStream getBody() throws IOException {
                APIResult result = new APIResult();
                result.setState(StateEnum.UNAVAILABLE_SERVICE.getCode());
                result.setCause("\u670d\u52a1\u3010" + DefaultFallbackProvider.this.getRoute() + "\u3011\u4e0d\u53ef\u7528\uff0c" + (cause == null ? "null" : cause.getMessage()));
                return new ByteArrayInputStream(result.toString().getBytes("UTF-8"));
            }

            public HttpHeaders getHeaders() {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                return headers;
            }
        };
    }
}

