/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.cloud.extend;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.Check;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.SimpleRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.StringUtils;

public class CustomRouteLocator
extends SimpleRouteLocator
implements RefreshableRouteLocator {
    public static final Logger logger = LoggerFactory.getLogger(CustomRouteLocator.class);
    private ZuulProperties zuulProperties;
    private ConsulClient consulClient;

    public CustomRouteLocator(String servletPath, ZuulProperties zuulProperties, ConsulClient consulClient) {
        super(servletPath, zuulProperties);
        this.zuulProperties = zuulProperties;
        this.consulClient = consulClient;
        logger.info("servletPath:{}", (Object)servletPath);
    }

    public void refresh() {
        this.doRefresh();
    }

    protected Map<String, ZuulProperties.ZuulRoute> locateRoutes() {
        LinkedHashMap routesMap = new LinkedHashMap();
        Response agentChecks = this.consulClient.getAgentChecks();
        Map serviceMap = (Map)agentChecks.getValue();
        HashSet serviceNameSet = new HashSet();
        serviceMap.forEach((key, value) -> {
            Check.CheckStatus status = value.getStatus();
            if (status.equals((Object)Check.CheckStatus.PASSING)) {
                String serviceName = value.getServiceName();
                serviceNameSet.add(serviceName);
            }
        });
        serviceNameSet.forEach(serviceName -> {
            String[] split = serviceName.split("-");
            String moduleName = split[2];
            String key = "/" + moduleName + "/v3/**";
            String id = serviceName;
            String path = key;
            String serviceId = id;
            String url = null;
            boolean stripPrefix = true;
            Boolean retryable = null;
            HashSet sensitiveHeaders = new HashSet();
            if (!"zuul".equals(moduleName)) {
                routesMap.put(key, new ZuulProperties.ZuulRoute(id, path, serviceId, url, stripPrefix, retryable, sensitiveHeaders));
            }
        });
        LinkedHashMap<String, ZuulProperties.ZuulRoute> zuulRoteMap = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        for (Map.Entry entry : routesMap.entrySet()) {
            String path = (String)entry.getKey();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (StringUtils.hasText((String)this.zuulProperties.getPrefix()) && !(path = this.zuulProperties.getPrefix() + path).startsWith("/")) {
                path = "/" + path;
            }
            zuulRoteMap.put(path, (ZuulProperties.ZuulRoute)entry.getValue());
        }
        return zuulRoteMap;
    }
}

