/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.cloud.config;

import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.EnvUtil;
import com.lc.ibps.cloud.util.IpV4Util;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class IpConfig {
    @Autowired
    private Environment env;
    private static final String ALL_IP = "0.0.0.0,0.0.0.0";
    private static final Logger logger = LoggerFactory.getLogger(IpConfig.class);
    public static final String blackKey = "ip.black";
    private final Set<String> black = new HashSet<String>(16);
    public static final String whiteKey = "ip.white";
    private final Set<String> white = new HashSet<String>(16);

    public Set<String> getBlack() {
        List black = EnvUtil.getProperties((Environment)this.env, (String)blackKey, String.class);
        if (BeanUtils.isNotEmpty((Object)black)) {
            this.black.addAll(black);
        }
        return this.black;
    }

    public Set<String> getWhite() {
        List white = EnvUtil.getProperties((Environment)this.env, (String)whiteKey, String.class);
        if (BeanUtils.isNotEmpty((Object)white)) {
            this.white.addAll(white);
        }
        return this.white;
    }

    public boolean isWhite(String ip) {
        if (BeanUtils.isEmpty((Object)ip)) {
            return true;
        }
        if (this.getWhite().contains(ALL_IP)) {
            return true;
        }
        String[] sourceArray = null;
        for (String source : this.getWhite()) {
            sourceArray = source.split(",");
            if (sourceArray.length != 2) {
                logger.warn("Illegal ip data [{}], right format is [{}].", (Object)source, (Object)ALL_IP);
                continue;
            }
            if (!IpV4Util.checkSameSegment((String)sourceArray[0], (int)IpV4Util.getIpV4Value((String)sourceArray[1]), (String)ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlack(String ip) {
        if (BeanUtils.isEmpty((Object)ip)) {
            return true;
        }
        if (this.getBlack().contains(ALL_IP)) {
            return true;
        }
        String[] sourceArray = null;
        for (String source : this.getBlack()) {
            sourceArray = source.split(",");
            if (sourceArray.length != 2) {
                logger.warn("Illegal ip data [{}], right format is [{}].", (Object)source, (Object)ALL_IP);
                continue;
            }
            if (!IpV4Util.checkSameSegment((String)sourceArray[0], (int)IpV4Util.getIpV4Value((String)sourceArray[1]), (String)ip)) continue;
            return true;
        }
        return false;
    }
}

