/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.cloud.config;

import com.lc.ibps.cloud.gateway.fallback.DefaultFallbackProvider;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.DefaultRateLimiterErrorHandler;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RateLimiterErrorHandler;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.DefaultRateLimitKeyGenerator;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.route.FallbackProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InitialConfigure {
    private static Logger logger = LoggerFactory.getLogger(InitialConfigure.class);

    @Bean
    public RateLimitKeyGenerator rateLimitKeyGenerator(RateLimitProperties properties, RateLimitUtils rateLimitUtils) {
        return new DefaultRateLimitKeyGenerator(properties, rateLimitUtils){

            public String key(HttpServletRequest request, Route route, RateLimitProperties.Policy policy) {
                return super.key(request, route, policy) + ":" + request.getMethod();
            }
        };
    }

    @Bean
    public RateLimiterErrorHandler rateLimitErrorHandler() {
        return new DefaultRateLimiterErrorHandler(){

            public void handleSaveError(String key, Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }

            public void handleFetchError(String key, Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }

            public void handleError(String msg, Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        };
    }

    @Bean
    public FallbackProvider routeZuulFallbackProvider() {
        DefaultFallbackProvider routeZuulFallback = new DefaultFallbackProvider();
        return routeZuulFallback;
    }

    @Bean
    public FallbackProvider routeOauthZuulFallbackProvider() {
        DefaultFallbackProvider routeZuulFallback = new DefaultFallbackProvider();
        routeZuulFallback.setRoute("cpis-basis-oauth2");
        return routeZuulFallback;
    }

    @Bean
    public FallbackProvider routePlatformFallbackProvider() {
        DefaultFallbackProvider routeZuulFallback = new DefaultFallbackProvider();
        routeZuulFallback.setRoute("cpis-basis-platform");
        return routeZuulFallback;
    }

    @Bean
    public FallbackProvider routeBusinessZuulFallbackProvider() {
        DefaultFallbackProvider routeZuulFallback = new DefaultFallbackProvider();
        routeZuulFallback.setRoute("cpis-basis-business");
        return routeZuulFallback;
    }

    @Bean
    public FallbackProvider routeMsgZuulFallbackProvider() {
        DefaultFallbackProvider routeZuulFallback = new DefaultFallbackProvider();
        routeZuulFallback.setRoute("ibps-messageserver-provider");
        return routeZuulFallback;
    }

    @Bean
    public FallbackProvider routeSocketZuulFallbackProvider() {
        DefaultFallbackProvider routeZuulFallback = new DefaultFallbackProvider();
        routeZuulFallback.setRoute("ibps-socket-provider");
        return routeZuulFallback;
    }

    @Bean
    public FallbackProvider routeFormZuulFallbackProvider() {
        DefaultFallbackProvider routeZuulFallback = new DefaultFallbackProvider();
        routeZuulFallback.setRoute("cpis-basis-form");
        return routeZuulFallback;
    }

    @Bean
    public FallbackProvider routeBpmnZuulFallbackProvider() {
        DefaultFallbackProvider routeZuulFallback = new DefaultFallbackProvider();
        routeZuulFallback.setRoute("cpis-basis-bpmn");
        return routeZuulFallback;
    }
}

