/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps;

import com.lc.ibps.cloud.bootstrap.AbstractCommandLineRunner;
import com.lc.ibps.cloud.bootstrap.IbpsApplication;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.cloud.netflix.zuul.EnableZuulProxy;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;

@EnableDiscoveryClient
@EnableFeignClients
@EnableHystrix
@EnableZuulProxy
@SpringBootApplication
@EnableAutoConfiguration(exclude={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class})
public class ZuulApplication
extends AbstractCommandLineRunner {
    @Autowired
    private ZuulProperties zuulProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(ZuulApplication.class);

    public static void main(String[] args) throws IOException {
        try {
            IbpsApplication.run(ZuulApplication.class, (String[])args);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void run(String ... args) throws Exception {
        super.run(args);
        LOGGER.info("ignore services ==> {}.", (Object)this.zuulProperties.getIgnoredServices());
    }

    protected void init() {
    }

    protected void ext() {
    }
}

