package com.lcy.thinkgear;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.lcy.thinkgear.ThinkGearBLEService;
import com.unity3d.player.UnityPlayer;
import com.unity3d.player.UnityPlayerActivity;
import java.util.ArrayList;

public class UnityMainActivity extends UnityPlayerActivity implements ThinkGearBLEService.IThinkGearConnectionListener {

   private String bluetoothStatus;
   public int testValue = 12345678;
   ThinkGearBLEService thinkGearService;
   ThinkGearBLEService.MyBinder binder;
   private static final int REQUEST_ENABLE_BT = 1;
   private ArrayList deviceNameList;
   private ServiceConnection serviceConnection = new ServiceConnection() {
      public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
         UnityMainActivity.this.binder = (ThinkGearBLEService.MyBinder)iBinder;
         UnityMainActivity.this.thinkGearService = UnityMainActivity.this.binder.getThinkGearService();
         UnityMainActivity.this.thinkGearService.setThinkGearConnectionListener(UnityMainActivity.this);
         Log.d("Chris", "onServiceConnected!!");
         Log.d("Chris", UnityMainActivity.this.thinkGearService.toString());
      }
      public void onServiceDisconnected(ComponentName componentName) {
      }
   };
   private BroadcastReceiver mReceiver = new BroadcastReceiver() {
      public void onReceive(Context context, Intent intent) {
         String var3 = intent.getAction();
         byte var4 = -1;
         switch(var3.hashCode()) {
         case -1530327060:
            if(var3.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
               var4 = 0;
            }
         default:
            switch(var4) {
            case 0:
               int blueState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
               switch(blueState) {
               case 10:
                  UnityMainActivity.this.bluetoothStatus = "off";
                  Log.e("Chris", "STATE_OFF");
                  UnityPlayer.UnitySendMessage("ThinkGearManager", "onBlueToothClose", "true");
                  break;
               case 11:
                  Log.e("Chris", "TURNING_ON");
                  break;
               case 12:
                  UnityMainActivity.this.bluetoothStatus = "on";
                  Log.e("Chris", "STATE_ON");
                  UnityPlayer.UnitySendMessage("ThinkGearManager", "onBlueToothOpen", "true");
                  break;
               case 13:
                  Log.e("Chris", "STATE_TURNING_OFF");
               }
            default:
            }
         }
      }
   };


   public void myPluginMethod(UnityMainActivity.PluginCallback callback) {
      callback.onSuccess("onSuccess");
      callback.onError("onError");
   }

   protected void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      this.deviceNameList = new ArrayList();
      Intent intent = new Intent(this, ThinkGearBLEService.class);
      this.bindService(intent, this.serviceConnection, 1);
      this.registerReceiver(this.mReceiver, this.makeFilter());
   }

   public void StopBLEService() {
      Intent intent = new Intent(this, ThinkGearBLEService.class);
      this.stopService(intent);
   }

   public void StartScan() {
      if(this.thinkGearService != null) {
         this.thinkGearService.startScan();
      }

   }

   public void StopScan() {
      if(this.thinkGearService != null) {
         this.thinkGearService.stopScan();
      }

   }

   public void OnClickScanDevice(String i) {
      this.thinkGearService.connectWith(Integer.valueOf(i).intValue());
   }

   public void DisconnectBLE() {
      this.thinkGearService.disconnect();
      this.unbindService(this.serviceConnection);
   }

   public void onDeviceScanning(ThinkGearBLEService thinkGearBLEService, ArrayList deviceNameList) {
      this.deviceNameList.clear();
      this.deviceNameList.addAll(deviceNameList);
      Log.d("Chris", "On Device Scanning");
   }

   public void onDeviceConnected(ThinkGearBLEService thinkGearBLEService) {
      Log.d("Chris", "On Device Connected");
   }

   public void onDeviceDisconnected(ThinkGearBLEService thinkGearBLEService) {
   }

   protected void onDestroy() {
      super.onDestroy();
      this.unregisterReceiver(this.mReceiver);
   }

   private IntentFilter makeFilter() {
      IntentFilter filter = new IntentFilter();
      filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
      return filter;
   }

   public interface PluginCallback {

      void onSuccess(String var1);

      void onError(String var1);
   }
}
