package com.lcy.thinkgear;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothAdapter.LeScanCallback;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.util.Log;
import com.lcy.thinkgear.EEGPower;
import com.lcy.thinkgear.ESense;
import com.unity3d.player.UnityPlayer;
import java.util.ArrayList;
import java.util.List;

public class ThinkGearBLEService extends Service implements LeScanCallback {

   private BluetoothAdapter mBluetoothAdapter;
   private BluetoothGatt gatt;
   private ArrayList deviceList;
   private String uServiceUUID = "0000ffe0-0000-1000-8000-00805f9b34fb";
   private String uNotifyCharacteristicUUID = "0000ffe1-0000-1000-8000-00805f9b34fb";
   private static final int PARSER_SYNC_BYTE = 170;
   private static final int PARSER_STATE_SYNC = 1;
   private static final int PARSER_STATE_SYNC_CHECK = 2;
   private static final int PARSER_STATE_PAYLOAD_LENGTH = 3;
   private static final int PARSER_STATE_PAYLOAD = 4;
   private static final int PARSER_STATE_CHKSUM = 5;
   private byte[] payload = new byte[64];
   private int parserStatus;
   private int payloadLength;
   private int payloadBytesReceived;
   private int payloadSum;
   private int checksum;
   private int raw;
   private int poorSignal;
   private ArrayList deviceNameList;
   private ArrayList deviceMACList;
   private ThinkGearBLEService.IThinkGearConnectionListener thinkGearConnectionListener;
   private ThinkGearBLEService.MyBinder binder = new ThinkGearBLEService.MyBinder();
   private ScanCallback scanCallback = new ScanCallback() {
      public void onBatchScanResults(List results) {
         super.onBatchScanResults(results);
      }
      public void onScanFailed(int errorCode) {
         Log.d("Chris", "onScanFailed:" + errorCode);
         super.onScanFailed(errorCode);
      }
      @SuppressLint({"MissingPermission"})
      public void onScanResult(int callbackType, ScanResult result) {
         Log.d("Chris", "Device Name:" + result.getDevice().getName());
         super.onScanResult(callbackType, result);
         if(result.getDevice().getName() != null && result.getDevice().getName().equalsIgnoreCase("SICHIRAY")) {
            if(ThinkGearBLEService.this.deviceMACList.contains(result.getDevice().getAddress())) {
               int deviceListStr = ThinkGearBLEService.this.deviceMACList.indexOf(result.getDevice().getAddress());
               ThinkGearBLEService.this.deviceList.remove(deviceListStr);
               ThinkGearBLEService.this.deviceList.add(deviceListStr, result.getDevice());
               ThinkGearBLEService.this.deviceNameList.remove(deviceListStr);
               ThinkGearBLEService.this.deviceNameList.add(deviceListStr, result.getDevice().getName() + "RSSI:" + result.getRssi());
            } else {
               ThinkGearBLEService.this.deviceMACList.add(result.getDevice().getAddress());
               ThinkGearBLEService.this.deviceList.add(result.getDevice());
               ThinkGearBLEService.this.deviceNameList.add(result.getDevice().getName() + "RSSI:" + result.getRssi());
            }

            if(ThinkGearBLEService.this.thinkGearConnectionListener != null) {
               ThinkGearBLEService.this.thinkGearConnectionListener.onDeviceScanning(ThinkGearBLEService.this, ThinkGearBLEService.this.deviceNameList);
            }

            String var5 = "";

            for(int i = 0; i < ThinkGearBLEService.this.deviceList.size(); ++i) {
               var5 = var5 + (String)ThinkGearBLEService.this.deviceNameList.get(i) + ";;";
            }

            Log.d("Chris", "onScanResult: deviceName");
            UnityPlayer.UnitySendMessage("ThinkGearManager", "onScanResult", var5);
         }

      }
   };
   private BluetoothGattCallback gattCallback = new BluetoothGattCallback() {
      public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
         Log.d("Chris", "onConnectionStateChange");
         switch(newState) {
         case 0:
            Log.d("Chris", "STATE_DISCONNECTED");
            UnityPlayer.UnitySendMessage("ThinkGearManager", "onDisconnected", "true");
            break;
         case 1:
            Log.d("Chris", "STATE_CONNECTING");
            break;
         case 2:
            Log.d("Chris", "STATE_CONNECTED");
            if(ThinkGearBLEService.this.thinkGearConnectionListener != null) {
               Log.d("Chris", "thinkGearConnectionListener != null");
               ThinkGearBLEService.this.thinkGearConnectionListener.onDeviceConnected(ThinkGearBLEService.this);
            }

            gatt.discoverServices();
            break;
         case 3:
            Log.d("Chris", "STATE_DISCONNECTING");
         }

         super.onConnectionStateChange(gatt, status, newState);
      }
      public void onServicesDiscovered(BluetoothGatt gatt, int status) {
         Log.d("Chris", "onServicesDiscovered");
         UnityPlayer.UnitySendMessage("ThinkGearManager", "onServicesDiscovered", "true");
         if(status == 0) {
            for(int i = 0; i < gatt.getServices().size(); ++i) {
               BluetoothGattService theService = (BluetoothGattService)gatt.getServices().get(i);
               Log.d("Chris", "ServiceName:" + theService.getUuid());
               if(theService.getUuid().toString().equalsIgnoreCase(ThinkGearBLEService.this.uServiceUUID)) {
                  Log.d("Chris", "找到服务");

                  for(int j = 0; j < theService.getCharacteristics().size(); ++j) {
                     BluetoothGattCharacteristic theCharacter = (BluetoothGattCharacteristic)theService.getCharacteristics().get(j);
                     Log.d("Chris", "---CharacterName:" + theCharacter.getUuid());
                     if(theCharacter.getUuid().toString().equalsIgnoreCase(ThinkGearBLEService.this.uNotifyCharacteristicUUID)) {
                        Log.d("Chris", "找到特征");
                        gatt.setCharacteristicNotification(theCharacter, true);
                     }
                  }
               }
            }
         }

         super.onServicesDiscovered(gatt, status);
      }
      private void onReceivedDataPacket(byte[] data) {
         for(int i = 0; i < data.length; ++i) {
            byte tempBuffer = data[i];
            switch(ThinkGearBLEService.this.parserStatus) {
            case 1:
               if((tempBuffer & 255) == 170) {
                  ThinkGearBLEService.this.parserStatus = 2;
               }
               break;
            case 2:
               Log.d("Chris", "PARSER_STATE_SYNC_CHECK: ");
               if((tempBuffer & 255) == 170) {
                  ThinkGearBLEService.this.parserStatus = 3;
               } else {
                  ThinkGearBLEService.this.parserStatus = 1;
               }
               break;
            case 3:
               Log.d("Chris", "PARSER_STATE_PAYLOAD_LENGTH: ");
               ThinkGearBLEService.this.payloadLength = tempBuffer & 255;
               ThinkGearBLEService.this.payloadBytesReceived = 0;
               ThinkGearBLEService.this.payloadSum = 0;
               ThinkGearBLEService.this.parserStatus = 4;
               break;
            case 4:
               Log.d("Chris", "PARSER_STATE_PAYLOAD: ");
               ThinkGearBLEService.this.payload[ThinkGearBLEService.access$808(ThinkGearBLEService.this)] = tempBuffer;
               ThinkGearBLEService.this.payloadSum = ThinkGearBLEService.this.payloadSum + (tempBuffer & 255);
               if(ThinkGearBLEService.this.payloadBytesReceived >= ThinkGearBLEService.this.payloadLength) {
                  ThinkGearBLEService.this.parserStatus = 5;
               }
               break;
            case 5:
               Log.d("Chris", "PARSER_STATE_CHKSUM: ");
               ThinkGearBLEService.this.checksum = tempBuffer & 255;
               ThinkGearBLEService.this.parserStatus = 1;
               if(ThinkGearBLEService.this.checksum != (~ThinkGearBLEService.this.payloadSum & 255)) {
                  Log.d("Chris", "CheckSum Error!!!");
               } else {
                  this.parsePacketPayload();
               }
               break;
            default:
               Log.d("Chris", "default: ");
            }
         }

      }
      private void parsePacketPayload() {
         switch(ThinkGearBLEService.this.payload[0]) {
         case -128:
            ThinkGearBLEService.this.raw = this.getRawValue(ThinkGearBLEService.this.payload[2], ThinkGearBLEService.this.payload[3]);
            if(ThinkGearBLEService.this.raw > '耀') {
               ThinkGearBLEService.this.raw = ThinkGearBLEService.this.raw - 65536;
            }

            Log.d("Chris", "Rawdata:" + ThinkGearBLEService.this.raw);
            UnityPlayer.UnitySendMessage("ThinkGearManager", "DataParse", "Rawdata:" + ThinkGearBLEService.this.raw);
            break;
         case 2:
            ThinkGearBLEService.this.poorSignal = ThinkGearBLEService.this.payload[1] & 255;
            EEGPower eegPower = new EEGPower();
            eegPower.delta = ThinkGearBLEService.this.payload[4] << 16 | ThinkGearBLEService.this.payload[5] << 8 | ThinkGearBLEService.this.payload[6];
            eegPower.theta = ThinkGearBLEService.this.payload[7] << 16 | ThinkGearBLEService.this.payload[8] << 8 | ThinkGearBLEService.this.payload[9];
            eegPower.lowAlpha = ThinkGearBLEService.this.payload[10] << 16 | ThinkGearBLEService.this.payload[11] << 8 | ThinkGearBLEService.this.payload[12];
            eegPower.highAlpha = ThinkGearBLEService.this.payload[13] << 16 | ThinkGearBLEService.this.payload[14] << 8 | ThinkGearBLEService.this.payload[15];
            eegPower.lowBeta = ThinkGearBLEService.this.payload[16] << 16 | ThinkGearBLEService.this.payload[17] << 8 | ThinkGearBLEService.this.payload[18];
            eegPower.highBeta = ThinkGearBLEService.this.payload[19] << 16 | ThinkGearBLEService.this.payload[20] << 8 | ThinkGearBLEService.this.payload[21];
            eegPower.lowGamma = ThinkGearBLEService.this.payload[22] << 16 | ThinkGearBLEService.this.payload[23] << 8 | ThinkGearBLEService.this.payload[24];
            eegPower.middleGamma = ThinkGearBLEService.this.payload[25] << 16 | ThinkGearBLEService.this.payload[26] << 8 | ThinkGearBLEService.this.payload[27];
            ESense eSense = new ESense();
            eSense.attention = ThinkGearBLEService.this.payload[29];
            eSense.meditation = ThinkGearBLEService.this.payload[31];
            Log.d("Chris", "PoorSignal:" + ThinkGearBLEService.this.poorSignal);
            Log.d("Chris", eegPower.toString());
            Log.d("Chris", eSense.toString());
            UnityPlayer.UnitySendMessage("ThinkGearManager", "DataParse", "PoorSignal:" + ThinkGearBLEService.this.poorSignal);
            UnityPlayer.UnitySendMessage("ThinkGearManager", "DataParse", "EegPower:" + eegPower.toString());
            UnityPlayer.UnitySendMessage("ThinkGearManager", "DataParse", "ESense:" + eSense.toString());
         }

      }
      private int getRawValue(byte highByte, byte lowByte) {
         int lo = lowByte & 255;
         int return_value = highByte << 8 | lo;
         return return_value;
      }
      public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
         Log.d("Chris", "onCharacteristicRead");
         super.onCharacteristicRead(gatt, characteristic, status);
      }
      public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
         Log.d("Chris", "onCharacteristicWrite");
         super.onCharacteristicWrite(gatt, characteristic, status);
      }
      public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
         Log.d("Chris", "onCharacteristicChanged");
         if(characteristic.getUuid().toString().equalsIgnoreCase(ThinkGearBLEService.this.uNotifyCharacteristicUUID)) {
            Log.d("Chris", "Value Length:" + characteristic.getValue().length);
            Log.d("Chris", "Value: " + ThinkGearBLEService.bytesToHex(characteristic.getValue()));
            this.onReceivedDataPacket(characteristic.getValue());
         }

         super.onCharacteristicChanged(gatt, characteristic);
      }
      public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
         Log.d("Chris", "onDescriptorRead");
         super.onDescriptorRead(gatt, descriptor, status);
      }
      public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
         Log.d("Chris", "onDescriptorWrite");
         super.onDescriptorWrite(gatt, descriptor, status);
      }
      public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
         Log.d("Chris", "onReliableWriteCompleted");
         super.onReliableWriteCompleted(gatt, status);
      }
      public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
         Log.d("Chris", "onReadRemoteRssi");
         super.onReadRemoteRssi(gatt, rssi, status);
      }
   };


   public void setThinkGearConnectionListener(ThinkGearBLEService.IThinkGearConnectionListener thinkGearConnectionListener) {
      this.thinkGearConnectionListener = thinkGearConnectionListener;
   }

   @Nullable
   public IBinder onBind(Intent intent) {
      return this.binder;
   }

   public void onRebind(Intent intent) {
      super.onRebind(intent);
   }

   @SuppressLint({"MissingPermission"})
   public void onCreate() {
      super.onCreate();
      this.deviceList = new ArrayList();
      this.deviceNameList = new ArrayList();
      this.deviceMACList = new ArrayList();
      BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
      this.mBluetoothAdapter = bluetoothManager.getAdapter();
      if(this.mBluetoothAdapter == null || !this.mBluetoothAdapter.isEnabled()) {
         Log.d("Chris", "onCreate: 蓝牙没有开启或者没有蓝牙模块");
         UnityPlayer.UnitySendMessage("ThinkGearManager", "onBlueToothClose", "true");
      }

      Log.d("Chris", "ThinkGearService OnCreate!!!");
   }

   public int onStartCommand(Intent intent, int flags, int startId) {
      return super.onStartCommand(intent, flags, startId);
   }

   public void onDestroy() {
      super.onDestroy();
      this.disconnect();
   }

   @SuppressLint({"MissingPermission"})
   public void onLeScan(BluetoothDevice var1, int var2, byte[] var3) {
      if(var1.getName().equalsIgnoreCase("SICHIRAY")) {
         if(this.deviceMACList.contains(var1.getAddress())) {
            int index = this.deviceMACList.indexOf(var1.getAddress());
            this.deviceList.remove(index);
            this.deviceList.add(index, var1);
            this.deviceNameList.remove(index);
            this.deviceNameList.add(index, var1.getName() + "RSSI:" + var2);
         } else {
            this.deviceMACList.add(var1.getAddress());
            this.deviceList.add(var1);
            this.deviceNameList.add(var1.getName() + "RSSI:" + var2);
         }

         if(this.thinkGearConnectionListener != null) {
            this.thinkGearConnectionListener.onDeviceScanning(this, this.deviceNameList);
         }
      }

   }

   @SuppressLint({"MissingPermission"})
   @TargetApi(21)
   public void startScan() {
      BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
      this.mBluetoothAdapter = bluetoothManager.getAdapter();
      this.deviceList.clear();
      this.deviceNameList.clear();
      this.deviceMACList.clear();
      if(this.mBluetoothAdapter != null) {
         Log.d("Chris", this.mBluetoothAdapter.toString());
         BluetoothLeScanner scanner = this.mBluetoothAdapter.getBluetoothLeScanner();

         try {
            scanner.startScan(this.scanCallback);
            Log.d("Chris", "Start BLE Scanner Scan!!!");
         } catch (Exception var4) {
            this.mBluetoothAdapter.startLeScan(this);
            Log.d("Chris", "Start LE Scan!!!");
            Log.d("Chris", var4.getMessage());
         }

         Log.d("Chris", "Start Scan!!!");
      }

   }

   @SuppressLint({"MissingPermission"})
   @TargetApi(21)
   public void stopScan() {
      if(this.mBluetoothAdapter != null) {
         Log.d("Chris", "Stop Scan!!!");

         try {
            this.mBluetoothAdapter.getBluetoothLeScanner().stopScan(this.scanCallback);
            Log.d("Chris", "Stop BLE Scanner Scan!!!");
         } catch (Exception var2) {
            this.mBluetoothAdapter.stopLeScan(this);
            Log.d("Chris", "Stop BLE Scan!!!");
         }
      }

   }

   public void connectWith(int index) {
      this.stopScan();
      this.gatt = ((BluetoothDevice)this.deviceList.get(index)).connectGatt(this, true, this.gattCallback);
      this.parserStatus = 1;
      Log.d("Chris", "Connected With Index: " + index);
   }

   public void disconnect() {
      this.gatt.disconnect();
   }

   public static String bytesToHex(byte[] bytes) {
      StringBuffer sb = new StringBuffer();

      for(int i = 0; i < bytes.length; ++i) {
         String hex = Integer.toHexString(bytes[i] & 255);
         if(hex.length() < 2) {
            sb.append(0);
         }

         sb.append(hex);
      }

      return sb.toString();
   }

   // $FF: synthetic method
   static int access$808(ThinkGearBLEService x0) {
      ++x0.payloadBytesReceived;
      return x0.payloadBytesReceived;
   }

   public class MyBinder extends Binder {

      public ThinkGearBLEService getThinkGearService() {
         return ThinkGearBLEService.this;
      }
   }

   public interface IThinkGearConnectionListener {

      void onDeviceScanning(ThinkGearBLEService var1, ArrayList var2);

      void onDeviceConnected(ThinkGearBLEService var1);

      void onDeviceDisconnected(ThinkGearBLEService var1);
   }
}
