package com.lcy.thinkgear;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.widget.TextView;
import com.lcy.thinkgear.ThinkGearBLEService;

public class DeviceDetailActivity extends Activity {

   private final int MSG_TYPE_POORSIGNAL = 1;
   private final int MSG_TYPE_RAWDATA = 2;
   private final int MSG_TYPE_EEGPOWER = 3;
   private final int MSG_TYPE_ESENSE = 4;
   ThinkGearBLEService.MyBinder binder;
   private TextView poorSignalTextView;
   private TextView rawdataTextView;
   private TextView eSenseTextView;
   private TextView eegPowerTextView;
   private ServiceConnection serviceConnection = new ServiceConnection() {
      public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
         DeviceDetailActivity.this.binder = (ThinkGearBLEService.MyBinder)iBinder;
      }
      public void onServiceDisconnected(ComponentName componentName) {
      }
   };


   protected void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      Intent intent = new Intent(this, ThinkGearBLEService.class);
      this.bindService(intent, this.serviceConnection, 1);
   }

   protected void onDestroy() {
      super.onDestroy();
      this.unbindService(this.serviceConnection);
   }

   protected void onStart() {
      super.onStart();
   }
}
