/*
 * Decompiled with CFR 0.152.
 */
package com.lcy.thinkgear;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.lcy.thinkgear.ThinkGearBLEService;
import com.unity3d.player.UnityPlayer;
import com.unity3d.player.UnityPlayerActivity;
import java.util.ArrayList;

public class UnityMainActivity
extends UnityPlayerActivity
implements ThinkGearBLEService.IThinkGearConnectionListener {
    private String bluetoothStatus;
    public int testValue = 12345678;
    ThinkGearBLEService thinkGearService;
    ThinkGearBLEService.MyBinder binder;
    private static final int REQUEST_ENABLE_BT = 1;
    private ArrayList<String> deviceNameList;
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            UnityMainActivity.this.binder = (ThinkGearBLEService.MyBinder)iBinder;
            UnityMainActivity.this.thinkGearService = UnityMainActivity.this.binder.getThinkGearService();
            UnityMainActivity.this.thinkGearService.setThinkGearConnectionListener(UnityMainActivity.this);
            Log.d((String)"Chris", (String)"onServiceConnected!!");
            Log.d((String)"Chris", (String)((Object)((Object)UnityMainActivity.this.thinkGearService)).toString());
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }
    };
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            block3 : switch (intent.getAction()) {
                case "android.bluetooth.adapter.action.STATE_CHANGED": {
                    int blueState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                    switch (blueState) {
                        case 11: {
                            Log.e((String)"Chris", (String)"TURNING_ON");
                            break block3;
                        }
                        case 12: {
                            UnityMainActivity.this.bluetoothStatus = "on";
                            Log.e((String)"Chris", (String)"STATE_ON");
                            UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"onBlueToothOpen", (String)"true");
                            break block3;
                        }
                        case 13: {
                            Log.e((String)"Chris", (String)"STATE_TURNING_OFF");
                            break block3;
                        }
                        case 10: {
                            UnityMainActivity.this.bluetoothStatus = "off";
                            Log.e((String)"Chris", (String)"STATE_OFF");
                            UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"onBlueToothClose", (String)"true");
                        }
                    }
                }
            }
        }
    };

    public void myPluginMethod(PluginCallback callback) {
        callback.onSuccess("onSuccess");
        callback.onError("onError");
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.deviceNameList = new ArrayList();
        Intent intent = new Intent((Context)this, ThinkGearBLEService.class);
        this.bindService(intent, this.serviceConnection, 1);
        this.registerReceiver(this.mReceiver, this.makeFilter());
    }

    public void StopBLEService() {
        Intent intent = new Intent((Context)this, ThinkGearBLEService.class);
        this.stopService(intent);
    }

    public void StartScan() {
        if (this.thinkGearService != null) {
            this.thinkGearService.startScan();
        }
    }

    public void StopScan() {
        if (this.thinkGearService != null) {
            this.thinkGearService.stopScan();
        }
    }

    public void OnClickScanDevice(String i) {
        this.thinkGearService.connectWith(Integer.valueOf(i));
    }

    public void DisconnectBLE() {
        this.thinkGearService.disconnect();
        this.unbindService(this.serviceConnection);
    }

    @Override
    public void onDeviceScanning(ThinkGearBLEService thinkGearBLEService, ArrayList<String> deviceNameList) {
        this.deviceNameList.clear();
        this.deviceNameList.addAll(deviceNameList);
        Log.d((String)"Chris", (String)"On Device Scanning");
    }

    @Override
    public void onDeviceConnected(ThinkGearBLEService thinkGearBLEService) {
        Log.d((String)"Chris", (String)"On Device Connected");
    }

    @Override
    public void onDeviceDisconnected(ThinkGearBLEService thinkGearBLEService) {
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mReceiver);
    }

    private IntentFilter makeFilter() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        return filter;
    }

    public static interface PluginCallback {
        public void onSuccess(String var1);

        public void onError(String var1);
    }
}

