/*
 * Decompiled with CFR 0.152.
 */
package com.lcy.thinkgear;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.util.Log;
import com.lcy.thinkgear.EEGPower;
import com.lcy.thinkgear.ESense;
import com.unity3d.player.UnityPlayer;
import java.util.ArrayList;
import java.util.List;

public class ThinkGearBLEService
extends Service
implements BluetoothAdapter.LeScanCallback {
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothGatt gatt;
    private ArrayList<BluetoothDevice> deviceList;
    private String uServiceUUID = "0000ffe0-0000-1000-8000-00805f9b34fb";
    private String uNotifyCharacteristicUUID = "0000ffe1-0000-1000-8000-00805f9b34fb";
    private static final int PARSER_SYNC_BYTE = 170;
    private static final int PARSER_STATE_SYNC = 1;
    private static final int PARSER_STATE_SYNC_CHECK = 2;
    private static final int PARSER_STATE_PAYLOAD_LENGTH = 3;
    private static final int PARSER_STATE_PAYLOAD = 4;
    private static final int PARSER_STATE_CHKSUM = 5;
    private byte[] payload = new byte[64];
    private int parserStatus;
    private int payloadLength;
    private int payloadBytesReceived;
    private int payloadSum;
    private int checksum;
    private int raw;
    private int poorSignal;
    private ArrayList<String> deviceNameList;
    private ArrayList<String> deviceMACList;
    private IThinkGearConnectionListener thinkGearConnectionListener;
    private MyBinder binder = new MyBinder();
    private ScanCallback scanCallback = new ScanCallback(){

        public void onBatchScanResults(List<ScanResult> results) {
            super.onBatchScanResults(results);
        }

        public void onScanFailed(int errorCode) {
            Log.d((String)"Chris", (String)("onScanFailed:" + errorCode));
            super.onScanFailed(errorCode);
        }

        @SuppressLint(value={"MissingPermission"})
        public void onScanResult(int callbackType, ScanResult result) {
            Log.d((String)"Chris", (String)("Device Name:" + result.getDevice().getName()));
            super.onScanResult(callbackType, result);
            if (result.getDevice().getName() != null && result.getDevice().getName().equalsIgnoreCase("SICHIRAY")) {
                if (ThinkGearBLEService.this.deviceMACList.contains(result.getDevice().getAddress())) {
                    int index = ThinkGearBLEService.this.deviceMACList.indexOf(result.getDevice().getAddress());
                    ThinkGearBLEService.this.deviceList.remove(index);
                    ThinkGearBLEService.this.deviceList.add(index, result.getDevice());
                    ThinkGearBLEService.this.deviceNameList.remove(index);
                    ThinkGearBLEService.this.deviceNameList.add(index, result.getDevice().getName() + "RSSI:" + result.getRssi());
                } else {
                    ThinkGearBLEService.this.deviceMACList.add(result.getDevice().getAddress());
                    ThinkGearBLEService.this.deviceList.add(result.getDevice());
                    ThinkGearBLEService.this.deviceNameList.add(result.getDevice().getName() + "RSSI:" + result.getRssi());
                }
                if (ThinkGearBLEService.this.thinkGearConnectionListener != null) {
                    ThinkGearBLEService.this.thinkGearConnectionListener.onDeviceScanning(ThinkGearBLEService.this, ThinkGearBLEService.this.deviceNameList);
                }
                String deviceListStr = "";
                for (int i = 0; i < ThinkGearBLEService.this.deviceList.size(); ++i) {
                    deviceListStr = deviceListStr + (String)ThinkGearBLEService.this.deviceNameList.get(i) + ";;";
                }
                Log.d((String)"Chris", (String)"onScanResult: deviceName");
                UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"onScanResult", (String)deviceListStr);
            }
        }
    };
    private BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            Log.d((String)"Chris", (String)"onConnectionStateChange");
            switch (newState) {
                case 2: {
                    Log.d((String)"Chris", (String)"STATE_CONNECTED");
                    if (ThinkGearBLEService.this.thinkGearConnectionListener != null) {
                        Log.d((String)"Chris", (String)"thinkGearConnectionListener != null");
                        ThinkGearBLEService.this.thinkGearConnectionListener.onDeviceConnected(ThinkGearBLEService.this);
                    }
                    gatt.discoverServices();
                    break;
                }
                case 0: {
                    Log.d((String)"Chris", (String)"STATE_DISCONNECTED");
                    UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"onDisconnected", (String)"true");
                    break;
                }
                case 1: {
                    Log.d((String)"Chris", (String)"STATE_CONNECTING");
                    break;
                }
                case 3: {
                    Log.d((String)"Chris", (String)"STATE_DISCONNECTING");
                }
            }
            super.onConnectionStateChange(gatt, status, newState);
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            Log.d((String)"Chris", (String)"onServicesDiscovered");
            UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"onServicesDiscovered", (String)"true");
            if (status == 0) {
                for (int i = 0; i < gatt.getServices().size(); ++i) {
                    BluetoothGattService theService = (BluetoothGattService)gatt.getServices().get(i);
                    Log.d((String)"Chris", (String)("ServiceName:" + theService.getUuid()));
                    if (!theService.getUuid().toString().equalsIgnoreCase(ThinkGearBLEService.this.uServiceUUID)) continue;
                    Log.d((String)"Chris", (String)"\u627e\u5230\u670d\u52a1");
                    for (int j = 0; j < theService.getCharacteristics().size(); ++j) {
                        BluetoothGattCharacteristic theCharacter = (BluetoothGattCharacteristic)theService.getCharacteristics().get(j);
                        Log.d((String)"Chris", (String)("---CharacterName:" + theCharacter.getUuid()));
                        if (!theCharacter.getUuid().toString().equalsIgnoreCase(ThinkGearBLEService.this.uNotifyCharacteristicUUID)) continue;
                        Log.d((String)"Chris", (String)"\u627e\u5230\u7279\u5f81");
                        gatt.setCharacteristicNotification(theCharacter, true);
                    }
                }
            }
            super.onServicesDiscovered(gatt, status);
        }

        private void onReceivedDataPacket(byte[] data) {
            block7: for (int i = 0; i < data.length; ++i) {
                byte tempBuffer = data[i];
                switch (ThinkGearBLEService.this.parserStatus) {
                    case 1: {
                        if ((tempBuffer & 0xFF) != 170) continue block7;
                        ThinkGearBLEService.this.parserStatus = 2;
                        continue block7;
                    }
                    case 2: {
                        Log.d((String)"Chris", (String)"PARSER_STATE_SYNC_CHECK: ");
                        if ((tempBuffer & 0xFF) == 170) {
                            ThinkGearBLEService.this.parserStatus = 3;
                            continue block7;
                        }
                        ThinkGearBLEService.this.parserStatus = 1;
                        continue block7;
                    }
                    case 3: {
                        Log.d((String)"Chris", (String)"PARSER_STATE_PAYLOAD_LENGTH: ");
                        ThinkGearBLEService.this.payloadLength = tempBuffer & 0xFF;
                        ThinkGearBLEService.this.payloadBytesReceived = 0;
                        ThinkGearBLEService.this.payloadSum = 0;
                        ThinkGearBLEService.this.parserStatus = 4;
                        continue block7;
                    }
                    case 4: {
                        Log.d((String)"Chris", (String)"PARSER_STATE_PAYLOAD: ");
                        ((ThinkGearBLEService)ThinkGearBLEService.this).payload[((ThinkGearBLEService)ThinkGearBLEService.this).payloadBytesReceived++] = tempBuffer;
                        ThinkGearBLEService.this.payloadSum = ThinkGearBLEService.this.payloadSum + (tempBuffer & 0xFF);
                        if (ThinkGearBLEService.this.payloadBytesReceived < ThinkGearBLEService.this.payloadLength) continue block7;
                        ThinkGearBLEService.this.parserStatus = 5;
                        continue block7;
                    }
                    case 5: {
                        Log.d((String)"Chris", (String)"PARSER_STATE_CHKSUM: ");
                        ThinkGearBLEService.this.checksum = tempBuffer & 0xFF;
                        ThinkGearBLEService.this.parserStatus = 1;
                        if (ThinkGearBLEService.this.checksum != (~ThinkGearBLEService.this.payloadSum & 0xFF)) {
                            Log.d((String)"Chris", (String)"CheckSum Error!!!");
                            continue block7;
                        }
                        this.parsePacketPayload();
                        continue block7;
                    }
                    default: {
                        Log.d((String)"Chris", (String)"default: ");
                    }
                }
            }
        }

        private void parsePacketPayload() {
            switch (ThinkGearBLEService.this.payload[0]) {
                case -128: {
                    ThinkGearBLEService.this.raw = this.getRawValue(ThinkGearBLEService.this.payload[2], ThinkGearBLEService.this.payload[3]);
                    if (ThinkGearBLEService.this.raw > 32768) {
                        ThinkGearBLEService.this.raw = ThinkGearBLEService.this.raw - 65536;
                    }
                    Log.d((String)"Chris", (String)("Rawdata:" + ThinkGearBLEService.this.raw));
                    UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"DataParse", (String)("Rawdata:" + ThinkGearBLEService.this.raw));
                    break;
                }
                case 2: {
                    ThinkGearBLEService.this.poorSignal = ThinkGearBLEService.this.payload[1] & 0xFF;
                    EEGPower eegPower = new EEGPower();
                    eegPower.delta = ThinkGearBLEService.this.payload[4] << 16 | ThinkGearBLEService.this.payload[5] << 8 | ThinkGearBLEService.this.payload[6];
                    eegPower.theta = ThinkGearBLEService.this.payload[7] << 16 | ThinkGearBLEService.this.payload[8] << 8 | ThinkGearBLEService.this.payload[9];
                    eegPower.lowAlpha = ThinkGearBLEService.this.payload[10] << 16 | ThinkGearBLEService.this.payload[11] << 8 | ThinkGearBLEService.this.payload[12];
                    eegPower.highAlpha = ThinkGearBLEService.this.payload[13] << 16 | ThinkGearBLEService.this.payload[14] << 8 | ThinkGearBLEService.this.payload[15];
                    eegPower.lowBeta = ThinkGearBLEService.this.payload[16] << 16 | ThinkGearBLEService.this.payload[17] << 8 | ThinkGearBLEService.this.payload[18];
                    eegPower.highBeta = ThinkGearBLEService.this.payload[19] << 16 | ThinkGearBLEService.this.payload[20] << 8 | ThinkGearBLEService.this.payload[21];
                    eegPower.lowGamma = ThinkGearBLEService.this.payload[22] << 16 | ThinkGearBLEService.this.payload[23] << 8 | ThinkGearBLEService.this.payload[24];
                    eegPower.middleGamma = ThinkGearBLEService.this.payload[25] << 16 | ThinkGearBLEService.this.payload[26] << 8 | ThinkGearBLEService.this.payload[27];
                    ESense eSense = new ESense();
                    eSense.attention = ThinkGearBLEService.this.payload[29];
                    eSense.meditation = ThinkGearBLEService.this.payload[31];
                    Log.d((String)"Chris", (String)("PoorSignal:" + ThinkGearBLEService.this.poorSignal));
                    Log.d((String)"Chris", (String)eegPower.toString());
                    Log.d((String)"Chris", (String)eSense.toString());
                    UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"DataParse", (String)("PoorSignal:" + ThinkGearBLEService.this.poorSignal));
                    UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"DataParse", (String)("EegPower:" + eegPower.toString()));
                    UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"DataParse", (String)("ESense:" + eSense.toString()));
                    break;
                }
            }
        }

        private int getRawValue(byte highByte, byte lowByte) {
            byte hi = highByte;
            int lo = lowByte & 0xFF;
            int return_value = hi << 8 | lo;
            return return_value;
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.d((String)"Chris", (String)"onCharacteristicRead");
            super.onCharacteristicRead(gatt, characteristic, status);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.d((String)"Chris", (String)"onCharacteristicWrite");
            super.onCharacteristicWrite(gatt, characteristic, status);
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            Log.d((String)"Chris", (String)"onCharacteristicChanged");
            if (characteristic.getUuid().toString().equalsIgnoreCase(ThinkGearBLEService.this.uNotifyCharacteristicUUID)) {
                Log.d((String)"Chris", (String)("Value Length:" + characteristic.getValue().length));
                Log.d((String)"Chris", (String)("Value: " + ThinkGearBLEService.bytesToHex(characteristic.getValue())));
                this.onReceivedDataPacket(characteristic.getValue());
            }
            super.onCharacteristicChanged(gatt, characteristic);
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.d((String)"Chris", (String)"onDescriptorRead");
            super.onDescriptorRead(gatt, descriptor, status);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.d((String)"Chris", (String)"onDescriptorWrite");
            super.onDescriptorWrite(gatt, descriptor, status);
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            Log.d((String)"Chris", (String)"onReliableWriteCompleted");
            super.onReliableWriteCompleted(gatt, status);
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            Log.d((String)"Chris", (String)"onReadRemoteRssi");
            super.onReadRemoteRssi(gatt, rssi, status);
        }
    };

    public void setThinkGearConnectionListener(IThinkGearConnectionListener thinkGearConnectionListener) {
        this.thinkGearConnectionListener = thinkGearConnectionListener;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
    }

    @SuppressLint(value={"MissingPermission"})
    public void onCreate() {
        super.onCreate();
        this.deviceList = new ArrayList();
        this.deviceNameList = new ArrayList();
        this.deviceMACList = new ArrayList();
        BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null || !this.mBluetoothAdapter.isEnabled()) {
            Log.d((String)"Chris", (String)"onCreate: \u84dd\u7259\u6ca1\u6709\u5f00\u542f\u6216\u8005\u6ca1\u6709\u84dd\u7259\u6a21\u5757");
            UnityPlayer.UnitySendMessage((String)"ThinkGearManager", (String)"onBlueToothClose", (String)"true");
        }
        Log.d((String)"Chris", (String)"ThinkGearService OnCreate!!!");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        super.onDestroy();
        this.disconnect();
    }

    @SuppressLint(value={"MissingPermission"})
    public void onLeScan(BluetoothDevice var1, int var2, byte[] var3) {
        if (var1.getName().equalsIgnoreCase("SICHIRAY")) {
            if (this.deviceMACList.contains(var1.getAddress())) {
                int index = this.deviceMACList.indexOf(var1.getAddress());
                this.deviceList.remove(index);
                this.deviceList.add(index, var1);
                this.deviceNameList.remove(index);
                this.deviceNameList.add(index, var1.getName() + "RSSI:" + var2);
            } else {
                this.deviceMACList.add(var1.getAddress());
                this.deviceList.add(var1);
                this.deviceNameList.add(var1.getName() + "RSSI:" + var2);
            }
            if (this.thinkGearConnectionListener != null) {
                this.thinkGearConnectionListener.onDeviceScanning(this, this.deviceNameList);
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=21)
    public void startScan() {
        BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        this.deviceList.clear();
        this.deviceNameList.clear();
        this.deviceMACList.clear();
        if (this.mBluetoothAdapter != null) {
            Log.d((String)"Chris", (String)this.mBluetoothAdapter.toString());
            BluetoothLeScanner scanner = this.mBluetoothAdapter.getBluetoothLeScanner();
            try {
                scanner.startScan(this.scanCallback);
                Log.d((String)"Chris", (String)"Start BLE Scanner Scan!!!");
            }
            catch (Exception e) {
                this.mBluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this);
                Log.d((String)"Chris", (String)"Start LE Scan!!!");
                Log.d((String)"Chris", (String)e.getMessage());
            }
            Log.d((String)"Chris", (String)"Start Scan!!!");
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=21)
    public void stopScan() {
        if (this.mBluetoothAdapter != null) {
            Log.d((String)"Chris", (String)"Stop Scan!!!");
            try {
                this.mBluetoothAdapter.getBluetoothLeScanner().stopScan(this.scanCallback);
                Log.d((String)"Chris", (String)"Stop BLE Scanner Scan!!!");
            }
            catch (Exception e) {
                this.mBluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)this);
                Log.d((String)"Chris", (String)"Stop BLE Scan!!!");
            }
        }
    }

    public void connectWith(int index) {
        this.stopScan();
        this.gatt = this.deviceList.get(index).connectGatt((Context)this, true, this.gattCallback);
        this.parserStatus = 1;
        Log.d((String)"Chris", (String)("Connected With Index: " + index));
    }

    public void disconnect() {
        this.gatt.disconnect();
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public class MyBinder
    extends Binder {
        public ThinkGearBLEService getThinkGearService() {
            return ThinkGearBLEService.this;
        }
    }

    public static interface IThinkGearConnectionListener {
        public void onDeviceScanning(ThinkGearBLEService var1, ArrayList<String> var2);

        public void onDeviceConnected(ThinkGearBLEService var1);

        public void onDeviceDisconnected(ThinkGearBLEService var1);
    }
}

