/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.tickTask.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.shelmarow.nightfall_invade.ai.NFIHumanoidPatch;
import net.shelmarow.nightfall_invade.iml.CustomExecuteEntity;
import net.shelmarow.nightfall_invade.tickTask.TickTaskManager;
import net.shelmarow.nightfall_invade.tickTask.tasks.Execution;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.CustomMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.StunType;

@Mod.EventBusSubscriber(modid="nightfall_invade", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExecutionHandler {
    private static final Map<LivingEntity, LivingEntity> executingTargets = new HashMap<LivingEntity, LivingEntity>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity;
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (event.getSource().m_276093_(DamageTypes.f_286979_)) {
            return;
        }
        if (executingTargets.containsKey(target)) {
            LivingEntity allowedAttacker = executingTargets.get(target);
            if (source == null || !source.m_20148_().equals(allowedAttacker.m_20148_())) {
                event.setCanceled(true);
            }
        } else if (executingTargets.containsValue(target)) {
            event.setCanceled(true);
        }
        if (source instanceof LivingEntity && executingTargets.containsValue(livingEntity = (LivingEntity)source) && !executingTargets.containsKey(target)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        LivingEntity target = event.getEntity();
        if (executingTargets.containsKey(target)) {
            event.setStrength(0.0f);
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.getSide().isServer()) {
            return;
        }
        Entity entity = event.getTarget();
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ServerPlayerPatch playerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
        LivingEntityPatch entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
        if (entityPatch != null && playerPatch != null && playerPatch.getEntityState().canUseSkill()) {
            LivingEntity livingEntity;
            AssetAccessor stunAnimation = Objects.requireNonNull(entityPatch.getAnimator().getPlayerFor(null)).getAnimation();
            if (entity instanceof LivingEntity && ExecutionHandler.canExecuteFont((Player)player, livingEntity = (LivingEntity)entity, entityPatch) && stunAnimation != null && stunAnimation == entityPatch.getHitAnimation(StunType.NEUTRALIZE) && ExecutionHandler.placePlayerInFront((Player)player, livingEntity, 1.35f)) {
                TickTaskManager.addTask(entity.m_20148_(), new Execution((LivingEntity)player, livingEntity, 100, true));
            }
        }
    }

    public static boolean canExecuteFont(Player player, LivingEntity entity, LivingEntityPatch<?> entityPatch) {
        return player.m_6084_() && entity.m_6084_() && ExecutionHandler.isExecutingTarget((LivingEntity)player, entity) && ExecutionHandler.canBeExecuted(entityPatch) && ExecutionHandler.isHoldingWeapon(player) && ExecutionHandler.isInFrontOfTarget(player, entity, 0.0, 3.0, 120.0);
    }

    public static boolean isHoldingWeapon(Player player) {
        CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND));
        return capabilityItem.getWeaponCategory() != CapabilityItem.WeaponCategories.NOT_WEAPON && capabilityItem.getWeaponCategory() != CapabilityItem.WeaponCategories.FIST;
    }

    public static boolean canBeExecuted(LivingEntityPatch<?> entityPatch) {
        if (entityPatch instanceof CustomExecuteEntity) {
            CustomExecuteEntity customExecuteEntity = (CustomExecuteEntity)entityPatch;
            return customExecuteEntity.canBeExecuted(entityPatch);
        }
        return entityPatch instanceof HumanoidMobPatch || entityPatch instanceof NFIHumanoidPatch || entityPatch instanceof CustomMobPatch || entityPatch instanceof PlayerPatch;
    }

    public static void addExecutingTarget(LivingEntity target, LivingEntity executor) {
        executingTargets.put(target, executor);
    }

    public static void removeExecutingTarget(LivingEntity target) {
        executingTargets.remove(target);
    }

    public static boolean isExecutingTarget(LivingEntity executor, LivingEntity target) {
        return !executingTargets.containsKey(target) && !executingTargets.containsKey(executor);
    }

    public static boolean placePlayerInFront(Player player, LivingEntity target, double distance) {
        Vec3 frontPos;
        Level level = player.m_9236_();
        if (ExecutionHandler.canStandHere(level, frontPos = ExecutionHandler.calculateFrontPosition(target, distance))) {
            player.m_6021_(frontPos.f_82479_, frontPos.f_82480_, frontPos.f_82481_);
            return true;
        }
        return false;
    }

    private static Vec3 calculateFrontPosition(LivingEntity target, double distance) {
        float yaw = target.m_146908_();
        double rad = Math.toRadians(yaw);
        double offsetX = -Math.sin(rad) * distance;
        double offsetZ = Math.cos(rad) * distance;
        return target.m_20182_().m_82520_(offsetX, 0.0, offsetZ);
    }

    public static boolean isInFrontOfTarget(Player player, LivingEntity target, double minDist, double maxDist, double maxAngleDegrees) {
        Vec3 toPlayer;
        Vec3 targetPos = target.m_20182_();
        Vec3 playerPos = player.m_20182_();
        double distance = playerPos.m_82554_(targetPos);
        if (distance < minDist || distance > maxDist) {
            return false;
        }
        float yaw = target.m_146908_();
        double yawRad = Math.toRadians(yaw);
        Vec3 forward = new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad)).m_82541_();
        double dot = forward.m_82526_(toPlayer = playerPos.m_82546_(targetPos).m_82541_());
        double angle = Math.toDegrees(Math.acos(dot));
        return angle <= maxAngleDegrees;
    }

    public static boolean canStandHere(Level level, Vec3 pos) {
        BlockPos blockPosBelow = new BlockPos((int)pos.f_82479_, (int)(pos.f_82480_ - 1.0), (int)pos.f_82481_);
        BlockState stateBelow = level.m_8055_(blockPosBelow);
        boolean solidBelow = stateBelow.m_280296_();
        boolean spaceFree = level.m_45772_(new AABB(pos.f_82479_ - 0.3, pos.f_82480_, pos.f_82481_ - 0.3, pos.f_82479_ + 0.3, pos.f_82480_ + 1.8, pos.f_82481_ + 0.3));
        return solidBelow && spaceFree;
    }
}

