/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.tickTask;

import java.util.UUID;

public abstract class TickTask {
    protected UUID taskID;
    protected int maxTime;
    protected int tickTimer;

    public TickTask(int durationTicks) {
        this.maxTime = durationTicks;
        this.tickTimer = 0;
    }

    public abstract void onStart();

    public abstract void onTick();

    public abstract void onFinish();

    public UUID getTaskID() {
        return this.taskID;
    }

    public boolean isFinished() {
        return this.tickTimer >= this.maxTime;
    }

    public void tick() {
        ++this.tickTimer;
        if (!this.isFinished()) {
            this.onTick();
        } else {
            this.onFinish();
        }
    }
}

