/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.entity.spear_knight;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.shelmarow.nightfall_invade.config.boss.BossConfig;
import net.shelmarow.nightfall_invade.effect.NFIMobEffects;
import net.shelmarow.nightfall_invade.entity.spear_knight.Arterius;

@Mod.EventBusSubscriber(modid="nightfall_invade", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArteriusBossEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        if (event.getEntity() instanceof ServerPlayer && !event.isCanceled() && (entity = event.getSource().m_7639_()) instanceof Arterius) {
            Arterius arterius = (Arterius)entity;
            arterius.resetBossStatus(false);
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        LivingEntity target = event.getEntity();
        Entity trueAttacker = source.m_7639_();
        if (trueAttacker instanceof Arterius && target instanceof LivingEntity) {
            LivingEntity livingTarget = target;
            int level = (Integer)BossConfig.ARTERIUS_DEBUFF_LEVEL.get();
            int duration = (Integer)BossConfig.ARTERIUS_DEBUFF_DURATION.get();
            float exDamage = ((Double)BossConfig.ARTERIUS_DEBUFF_EX_DAMAGE.get()).floatValue();
            float exHPDamage = ((Double)BossConfig.ARTERIUS_DEBUFF_EX_HP_DAMAGE.get()).floatValue();
            if (livingTarget.m_21023_((MobEffect)NFIMobEffects.SOUL_OF_FLAME.get())) {
                damage *= 1.0f + exDamage;
                damage += livingTarget.m_21233_() * exHPDamage;
            }
            livingTarget.m_147215_(new MobEffectInstance((MobEffect)NFIMobEffects.SOUL_OF_FLAME.get(), duration, level), (Entity)livingTarget);
        }
        event.setAmount(damage);
    }

    @SubscribeEvent
    public static void onLivingHealEvent(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)NFIMobEffects.SOUL_OF_FLAME.get())) {
            event.setAmount(0.0f);
        }
    }
}

