/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.client.execution;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.shelmarow.nightfall_invade.tickTask.handler.ExecutionHandler;
import org.joml.Matrix4f;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.StunType;

@Mod.EventBusSubscriber(modid="nightfall_invade", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ExecutionHUD {
    private static final ResourceLocation OVERLAY_1 = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"textures/gui/execution/overlay_1.png");
    private static final ResourceLocation OVERLAY_2 = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"textures/gui/execution/overlay_2.png");
    private static final ResourceLocation OVERLAY_3 = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"textures/gui/execution/overlay_3.png");
    private static final ResourceLocation BG_OUTLINE = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"textures/gui/execution/bg_outline.png");
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"textures/gui/execution/bg.png");
    private static final Minecraft mc = Minecraft.m_91087_();
    private static boolean showExecutionIcon = false;
    private static float timePercent = 1.0f;

    @SubscribeEvent
    public static void onPlayerClientTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_().f_46443_ && event.phase == TickEvent.Phase.END) {
            LivingEntity target;
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            if (localPlayerPatch != null && (target = localPlayerPatch.getTarget()) != null) {
                AssetAccessor stunAnimation;
                AnimationPlayer animationPlayer;
                LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)target, LivingEntityPatch.class);
                if (event.player.m_6084_() && target.m_6084_() && ExecutionHandler.isExecutingTarget((LivingEntity)event.player, target) && ExecutionHandler.canBeExecuted(targetPatch) && ExecutionHandler.isHoldingWeapon(event.player) && (animationPlayer = targetPatch.getAnimator().getPlayerFor(null)) != null && (stunAnimation = animationPlayer.getAnimation()) != null && stunAnimation == targetPatch.getHitAnimation(StunType.NEUTRALIZE)) {
                    float totalTime = ((DynamicAnimation)stunAnimation.get()).getTotalTime();
                    float currentTime = animationPlayer.getElapsedTime();
                    timePercent = currentTime / totalTime;
                    showExecutionIcon = true;
                    return;
                }
            }
            showExecutionIcon = false;
        }
    }

    @SubscribeEvent
    public static void OnRenderGUI(RenderGuiEvent.Post event) {
        if (ExecutionHUD.mc.f_91073_ == null || ExecutionHUD.mc.f_91074_ == null) {
            return;
        }
        if (showExecutionIcon) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            PoseStack poseStack = guiGraphics.m_280168_();
            int renderX = event.getWindow().m_85445_() / 2 + 40;
            int renderY = event.getWindow().m_85446_() / 2 + 40;
            MutableComponent text = Component.m_237115_((String)"hud.nightfall_invade.execution_tooltip");
            List lines = ExecutionHUD.mc.f_91062_.m_92923_((FormattedText)text, Integer.MAX_VALUE);
            int textWidth = 0;
            Objects.requireNonNull(ExecutionHUD.mc.f_91062_);
            int textHeight = 9 * lines.size();
            for (FormattedCharSequence line : lines) {
                int width = ExecutionHUD.mc.f_91062_.m_92724_(line);
                if (width <= textWidth) continue;
                textWidth = width;
            }
            poseStack.m_85836_();
            poseStack.m_252880_((float)renderX, (float)renderY, 0.0f);
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            guiGraphics.m_280509_(-2 - textWidth / 2, -2, textWidth + 2 - textWidth / 2, textHeight + 2, -16777216);
            guiGraphics.m_280637_(-2 - textWidth / 2, -2, textWidth + 4, textHeight + 4, -1);
            int offsetY = 0;
            for (FormattedCharSequence line : lines) {
                guiGraphics.m_280648_(ExecutionHUD.mc.f_91062_, line, -textWidth / 2, offsetY, -1);
                Objects.requireNonNull(ExecutionHUD.mc.f_91062_);
                offsetY += 9;
            }
            poseStack.m_85849_();
            ExecutionHUD.drawExecutionIcon(event.getGuiGraphics(), renderX - 16, renderY - 32, 32.0f);
        }
    }

    public static void drawExecutionIcon(GuiGraphics guiGraphics, float x, float y, float iconSize) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG);
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buf.m_252986_(matrix, x, y, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(1, 1, 1, 1).m_5752_();
        buf.m_252986_(matrix, x + iconSize, y, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(1, 1, 1, 1).m_5752_();
        buf.m_252986_(matrix, x + iconSize, y + iconSize, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(1, 1, 1, 1).m_5752_();
        buf.m_252986_(matrix, x, y + iconSize, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(1, 1, 1, 1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_OUTLINE);
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        float cx = x + iconSize / 2.0f;
        float cy = y + iconSize / 2.0f;
        buf.m_252986_(matrix, cx, cy, 0.0f).m_7421_(0.5f, 0.5f).m_5752_();
        int segments = 100;
        float filled = 1.0f - timePercent;
        float filledAngle = 360.0f * filled;
        double startRad = Math.toRadians(90.0);
        double step = Math.toRadians(filledAngle / (float)segments);
        for (int i = 0; i <= segments; ++i) {
            double angle = startRad - step * (double)i;
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float px = cx + cos * iconSize / 2.0f;
            float py = cy - sin * iconSize / 2.0f;
            float u = 0.5f + cos * 0.5f;
            float v = 0.5f - sin * 0.5f;
            buf.m_252986_(matrix, px, py, 0.0f).m_7421_(u, v).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        if (filled > 0.75f) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)OVERLAY_1);
        } else if (filled > 0.25f) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)OVERLAY_2);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)OVERLAY_3);
        }
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buf.m_252986_(matrix, x, y, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(1, 1, 1, 1).m_5752_();
        buf.m_252986_(matrix, x + iconSize, y, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(1, 1, 1, 1).m_5752_();
        buf.m_252986_(matrix, x + iconSize, y + iconSize, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(1, 1, 1, 1).m_5752_();
        buf.m_252986_(matrix, x, y + iconSize, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(1, 1, 1, 1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

