/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.client.bossbar.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.shelmarow.nightfall_invade.client.bossbar.ClientBossData;

public class ClientboundBossDataPacket {
    private final UUID bossId;
    private final float value;

    public ClientboundBossDataPacket(UUID bossId, float value) {
        this.bossId = bossId;
        this.value = value;
    }

    public static void encode(ClientboundBossDataPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.bossId);
        buf.writeFloat(msg.value);
    }

    public static ClientboundBossDataPacket decode(FriendlyByteBuf buf) {
        return new ClientboundBossDataPacket(buf.m_130259_(), buf.readFloat());
    }

    public static void handle(ClientboundBossDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientBossData.updateData(msg.bossId, msg.value));
        ctx.get().setPacketHandled(true);
    }
}

