/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.client.bossbar;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ClientBossData {
    private static final Map<UUID, BossData> BOSS_DATA_MAP = new ConcurrentHashMap<UUID, BossData>();

    public static void updateData(UUID bossId, float value) {
        BossData data = BOSS_DATA_MAP.computeIfAbsent(bossId, k -> new BossData());
        data.stamina = value;
    }

    public static float getStamina(UUID bossId) {
        BossData data = BOSS_DATA_MAP.get(bossId);
        return data != null ? data.stamina : 0.0f;
    }

    public static void removeBoss(UUID bossId) {
        BOSS_DATA_MAP.remove(bossId);
    }

    private static class BossData {
        float stamina = 0.0f;

        private BossData() {
        }
    }
}

