/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.ai;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.shelmarow.nightfall_invade.ai.TimeEvent;
import net.shelmarow.nightfall_invade.efcondition.CurrentAngle;
import net.shelmarow.nightfall_invade.efcondition.EntityTag;
import net.shelmarow.nightfall_invade.efcondition.HealthCheck;
import net.shelmarow.nightfall_invade.iml.ILivingEntityData;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.data.conditions.entity.CustomCondition;
import yesman.epicfight.data.conditions.entity.RandomChance;
import yesman.epicfight.data.conditions.entity.TargetInDistance;
import yesman.epicfight.data.conditions.entity.TargetInEyeHeight;
import yesman.epicfight.data.conditions.entity.TargetInPov;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class NFICombatBehaviors<T extends MobPatch<?>> {
    private final List<BehaviorRoot<T>> behaviorRoots;
    private final Map<BehaviorRoot<T>, Behavior<T>> cachedBehaviors = new HashMap<BehaviorRoot<T>, Behavior<T>>();
    private Behavior<T> currentBehavior;

    protected NFICombatBehaviors(Builder<T> builder) {
        this.behaviorRoots = builder.behaviorRoots.stream().map(BehaviorRoot.Builder::build).toList();
    }

    public Behavior<T> selectBehaviorRootByPriority(T mobpatch) {
        this.cachedBehaviors.clear();
        ArrayList usableBehaviors = new ArrayList();
        this.behaviorRoots.stream().filter(root -> root.cooldown <= 0 && root.priority > 0.0).forEach(root -> {
            Behavior<MobPatch> behavior = this.selectBehavior(mobpatch, root.getBehaviors(), false);
            if (behavior != null) {
                usableBehaviors.add(root);
                this.cachedBehaviors.put((BehaviorRoot<T>)root, behavior);
            }
        });
        ArrayList<BehaviorRoot> list = new ArrayList<BehaviorRoot>();
        double max = -1.7976931348623157E308;
        for (BehaviorRoot root2 : usableBehaviors) {
            if (root2.priority > max) {
                list.clear();
                list.add(root2);
                max = root2.priority;
                continue;
            }
            if (root2.priority != max) continue;
            list.add(root2);
        }
        if (list.size() == 1) {
            return this.cachedBehaviors.get(list.get(0));
        }
        if (list.size() > 1) {
            List<BehaviorRoot> weightList = list.stream().filter(b -> b.weight > 0.0).toList();
            double totalWeight = 0.0;
            double counter = 0.0;
            for (BehaviorRoot root3 : weightList) {
                totalWeight += root3.weight;
            }
            double random = Math.random() * totalWeight;
            for (BehaviorRoot root4 : weightList) {
                if (!((counter += root4.weight) >= random)) continue;
                return this.cachedBehaviors.get(root4);
            }
        }
        return null;
    }

    public Behavior<T> selectBehavior(T mobpatch, List<Behavior<T>> behaviors, boolean canBeInterrupted) {
        List<Behavior<T>> usableBehaviors = this.selectHighestPriorityBehavior(behaviors.stream().filter(b -> b.priority > 0.0 && b.checkPredicates(mobpatch) && (!canBeInterrupted || b.canInterruptParent)).toList());
        if (usableBehaviors.size() == 1) {
            return usableBehaviors.get(0);
        }
        if (usableBehaviors.size() > 1) {
            return this.selectBehaviorByWeight(usableBehaviors.stream().filter(b -> b.weight > 0.0).toList());
        }
        return null;
    }

    public List<Behavior<T>> selectHighestPriorityBehavior(List<Behavior<T>> list) {
        ArrayList<Behavior<T>> usableBehaviors = new ArrayList<Behavior<T>>();
        double max = -1.7976931348623157E308;
        for (Behavior<T> behavior : list) {
            if (behavior.priority > max) {
                usableBehaviors.clear();
                usableBehaviors.add(behavior);
                max = behavior.priority;
                continue;
            }
            if (behavior.priority != max) continue;
            usableBehaviors.add(behavior);
        }
        return usableBehaviors;
    }

    public Behavior<T> selectBehaviorByWeight(List<Behavior<T>> list) {
        if (list.isEmpty()) {
            return null;
        }
        double totalWeight = 0.0;
        double counter = 0.0;
        for (Behavior<T> behavior : list) {
            totalWeight += behavior.weight;
        }
        double random = Math.random() * totalWeight;
        for (Behavior<T> behavior : list) {
            if (!((counter += behavior.weight) >= random)) continue;
            return behavior;
        }
        return null;
    }

    public void tick(T mobpatch) {
        AssetAccessor assetAccessor;
        Behavior<T> behavior;
        if (this.currentBehavior == null && !mobpatch.getEntityState().inaction() && (behavior = this.selectBehaviorRootByPriority(mobpatch)) != null) {
            this.currentBehavior = behavior;
            this.currentBehavior.execute(mobpatch);
        }
        if (this.currentBehavior != null) {
            if (!this.currentBehavior.isFinished()) {
                this.currentBehavior.tick(mobpatch);
            }
            if (this.currentBehavior.canBeInterrupted(mobpatch) && (behavior = this.selectBehavior(mobpatch, this.currentBehavior.getNextBehaviors(), true)) != null) {
                this.currentBehavior.stopRunning(mobpatch);
                this.currentBehavior.behaviorFinished();
                this.currentBehavior = behavior;
                this.currentBehavior.execute(mobpatch);
            }
            if (!this.currentBehavior.isRunning()) {
                if (this.currentBehavior.getNextBehaviors().isEmpty() && !mobpatch.getEntityState().inaction()) {
                    this.currentBehavior.resetCooldown();
                    this.clearCurrentBehavior();
                } else if (!this.currentBehavior.getNextBehaviors().isEmpty()) {
                    behavior = this.selectBehavior(mobpatch, this.currentBehavior.getNextBehaviors(), false);
                    if (behavior != null) {
                        this.currentBehavior = behavior;
                        this.currentBehavior.execute(mobpatch);
                    } else {
                        this.currentBehavior.resetCooldown();
                        this.clearCurrentBehavior();
                    }
                }
            }
        }
        for (BehaviorRoot behaviorRoot : this.behaviorRoots) {
            behaviorRoot.tick();
        }
        ILivingEntityData entityData = (ILivingEntityData)mobpatch;
        if (!entityData.nightFall_Invade$isGuard((LivingEntity)mobpatch.getOriginal()) && (assetAccessor = Objects.requireNonNull(mobpatch.getAnimator().getPlayerFor(null)).getAnimation()) != null && assetAccessor == mobpatch.getAnimator().getLivingAnimation((LivingMotion)LivingMotions.BLOCK, (AssetAccessor)Animations.EMPTY_ANIMATION) && assetAccessor != Animations.EMPTY_ANIMATION) {
            mobpatch.stopPlaying(mobpatch.getAnimator().getLivingAnimation((LivingMotion)LivingMotions.BLOCK, (AssetAccessor)Animations.EMPTY_ANIMATION));
        }
    }

    public Behavior<T> getCurrentBehavior() {
        return this.currentBehavior;
    }

    public void clearCurrentBehavior() {
        this.currentBehavior = null;
    }

    public static <T extends MobPatch<?>> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends MobPatch<?>> {
        private final List<BehaviorRoot.Builder<T>> behaviorRoots = new ArrayList<BehaviorRoot.Builder<T>>();

        public Builder<T> newBehaviorRoot(BehaviorRoot.Builder<T> behaviors) {
            this.behaviorRoots.add(behaviors);
            return this;
        }

        public NFICombatBehaviors<T> build() {
            return new NFICombatBehaviors(this);
        }
    }

    public static class BehaviorRoot<T extends MobPatch<?>> {
        private final String rootName;
        private final List<Behavior<T>> behaviors;
        private final double priority;
        private final double weight;
        private final int maxCooldown;
        private int cooldown;

        public BehaviorRoot(Builder<T> builder) {
            this.rootName = builder.rootName;
            this.behaviors = builder.behavior.stream().map(b -> b.build(this)).toList();
            this.priority = builder.priority;
            this.weight = builder.weight;
            this.maxCooldown = builder.maxCooldown;
            this.cooldown = builder.cooldown;
        }

        public String getRootName() {
            return this.rootName;
        }

        public List<Behavior<T>> getBehaviors() {
            return this.behaviors;
        }

        public void tick() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }

        public void resetCooldown(int exCoolDown) {
            this.cooldown = this.maxCooldown + exCoolDown;
        }

        public static <T extends MobPatch<?>> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T extends MobPatch<?>> {
            private String rootName;
            private final List<Behavior.Builder<T>> behavior = new ArrayList<Behavior.Builder<T>>();
            private double priority = 0.0;
            private double weight = 0.0;
            private int maxCooldown = 0;
            private int cooldown = 0;

            public Builder<T> rootName(String rootName) {
                this.rootName = rootName;
                return this;
            }

            public Builder<T> addFirstBehavior(Behavior.Builder<T> behavior) {
                this.behavior.add(behavior);
                return this;
            }

            public Builder<T> priority(double priority) {
                this.priority = priority;
                return this;
            }

            public Builder<T> weight(double weight) {
                this.weight = weight;
                return this;
            }

            public Builder<T> maxCooldown(int maxCooldown) {
                this.maxCooldown = maxCooldown;
                return this;
            }

            public Builder<T> cooldown(int cooldown) {
                this.cooldown = cooldown;
                return this;
            }

            public BehaviorRoot<T> build() {
                return new BehaviorRoot(this);
            }
        }
    }

    public static class Behavior<T extends MobPatch<?>> {
        private final String behaviorName;
        private final Consumer<T> behavior;
        private final Consumer<T> counter;
        private final List<Consumer<T>> exBehaviors;
        private final List<Consumer<T>> onCounterStart;
        private final BehaviorType type;
        private final int exCoolDown;
        private final int behaviorTime;
        private int timeCount;
        private final CounterType counterType;
        private boolean canCounter = false;
        private final double counterChance;
        private final int maxGuardHit;
        private int guardHit;
        private final int totalWaitTime;
        private int waitTime;
        private final double priority;
        private final double weight;
        private final int interruptByStun;
        private final boolean canInterruptParent;
        private final boolean canBeInterrupted;
        private final InterruptType interruptType;
        private final List<Float> interruptedWindow;
        private final BehaviorRoot<T> behaviorRoot;
        private final List<Condition<T>> conditions;
        private final List<Behavior<T>> nextBehaviors;
        private BehaviorState state = BehaviorState.RUNNING;
        private final AssetAccessor<? extends StaticAnimation> counterAnimation;
        private final List<TimeEvent> timeEventList;
        private boolean shouldExecuteTimeEvent = false;

        private Behavior(Builder<T> builder, BehaviorRoot<T> behaviorRoot) {
            this.behaviorName = builder.behaviorName;
            this.interruptByStun = builder.interruptByStun;
            this.behaviorRoot = behaviorRoot;
            this.behavior = builder.behavior;
            this.counter = builder.counter;
            this.exBehaviors = builder.exBehaviors;
            this.onCounterStart = builder.onCounterStart;
            this.type = builder.type;
            this.exCoolDown = builder.exCoolDown;
            this.timeCount = this.behaviorTime = builder.behaviorTime;
            this.counterType = builder.counterType;
            this.counterChance = builder.counterChance;
            this.guardHit = this.maxGuardHit = builder.maxGuardHit;
            this.waitTime = this.totalWaitTime = builder.totalWaitTime;
            this.canInterruptParent = builder.canInterruptParent;
            this.canBeInterrupted = builder.canBeInterrupted;
            this.interruptType = builder.interruptType;
            this.interruptedWindow = builder.interruptedWindow;
            this.priority = builder.priority;
            this.weight = builder.weight;
            this.conditions = builder.conditions;
            this.counterAnimation = builder.counterAnimation;
            this.nextBehaviors = builder.nextBehaviors.stream().map(b -> b.build(behaviorRoot)).toList();
            this.timeEventList = builder.timeEventList;
        }

        public BehaviorRoot<T> getBehaviorRoot() {
            return this.behaviorRoot;
        }

        public void setShouldExecuteTimeEvent(boolean shouldExecuteTimeEvent) {
            this.shouldExecuteTimeEvent = shouldExecuteTimeEvent;
        }

        public void executeTimeEvent(float pre, float current, MobPatch<?> mobPatch) {
            if (this.shouldExecuteTimeEvent && !this.timeEventList.isEmpty()) {
                for (TimeEvent event : this.timeEventList) {
                    event.executeIfAvailable(pre, current, mobPatch);
                }
            }
        }

        public void resetTimeEventAvailable() {
            for (TimeEvent event : this.timeEventList) {
                event.resetAvailable();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canBeInterrupted(T mobpatch) {
            if (!this.canBeInterrupted) return false;
            if (this.interruptedWindow.isEmpty()) return false;
            if (this.interruptType == InterruptType.TIME) {
                if (this.behaviorTime == 0) {
                    AnimationPlayer animator = mobpatch.getAnimator().getPlayerFor(null);
                    if (animator == null) return false;
                    float time = animator.getElapsedTime();
                    if (!(time >= this.interruptedWindow.get(0).floatValue())) return false;
                    if (!(time < this.interruptedWindow.get(1).floatValue())) return false;
                    return true;
                }
                if (!((float)this.timeCount * 0.05f >= this.interruptedWindow.get(0).floatValue())) return false;
                if (!((float)this.timeCount * 0.05f < this.interruptedWindow.get(1).floatValue())) return false;
                return true;
            }
            if (this.interruptType != InterruptType.LEVEL) return false;
            return this.interruptedWindow.contains(Float.valueOf(mobpatch.getEntityState().getLevel()));
        }

        public boolean checkPredicates(T mobpatch) {
            for (Condition<T> condition : this.conditions) {
                if (condition.predicate(mobpatch)) continue;
                return false;
            }
            return true;
        }

        public void execute(T mobpatch) {
            this.behavior.accept(mobpatch);
            for (Consumer<T> consumer : this.exBehaviors) {
                consumer.accept(mobpatch);
            }
            mobpatch.updateEntityState();
            this.shouldExecuteTimeEvent = true;
            this.state = BehaviorState.RUNNING;
        }

        public List<Behavior<T>> getNextBehaviors() {
            return this.nextBehaviors;
        }

        public void resetCooldown() {
            this.behaviorRoot.resetCooldown(this.exCoolDown);
        }

        public boolean isFinished() {
            return this.state == BehaviorState.FINISHED;
        }

        public BehaviorType getType() {
            return this.type;
        }

        public void tick(T mobpatch) {
            if (this.state == BehaviorState.RUNNING) {
                this.running(mobpatch);
            } else if (this.state == BehaviorState.WAITING) {
                this.waiting(mobpatch);
            }
        }

        public void running(T mobpatch) {
            if (this.type == BehaviorType.WANDER || this.type == BehaviorType.GUARD || this.type == BehaviorType.GUARD_WANDER) {
                if (this.timeCount > 0) {
                    ILivingEntityData entityData = (ILivingEntityData)mobpatch;
                    if (mobpatch.getTarget() != null) {
                        mobpatch.rotateTo((Entity)mobpatch.getTarget(), 360.0f, true);
                    }
                    if (this.type == BehaviorType.WANDER || this.type == BehaviorType.GUARD_WANDER) {
                        this.behavior.accept(mobpatch);
                        if (this.timeCount >= this.behaviorTime - 1) {
                            entityData.nightFall_Invade$setWander((LivingEntity)mobpatch.getOriginal(), true);
                        }
                        if (!entityData.nightFall_Invade$isWander((LivingEntity)mobpatch.getOriginal())) {
                            this.behaviorWaiting();
                        }
                    }
                    if (this.type == BehaviorType.GUARD || this.type == BehaviorType.GUARD_WANDER) {
                        this.behavior.accept(mobpatch);
                        if (this.timeCount >= this.behaviorTime - 1) {
                            entityData.nightFall_Invade$setGuard((LivingEntity)mobpatch.getOriginal(), true);
                        }
                        if (!entityData.nightFall_Invade$isGuard((LivingEntity)mobpatch.getOriginal()) && !this.canCounter) {
                            this.behaviorWaiting();
                        }
                    }
                    if ((this.type == BehaviorType.GUARD || this.type == BehaviorType.GUARD_WANDER) && this.canCounter) {
                        entityData.nightFall_Invade$setInCounter((LivingEntity)mobpatch.getOriginal(), true);
                        if (mobpatch.getEntityState().canBasicAttack()) {
                            this.canCounter = false;
                            this.stopGuardAndWander(mobpatch);
                            this.counter.accept(mobpatch);
                            for (Consumer<T> consumer : this.onCounterStart) {
                                consumer.accept(mobpatch);
                            }
                        } else {
                            ++this.timeCount;
                        }
                    }
                    --this.timeCount;
                } else if (this.timeCount == 0 && mobpatch.getEntityState().canBasicAttack()) {
                    this.stopRunning(mobpatch);
                    this.behaviorWaiting();
                }
            } else if (this.type == BehaviorType.ANIMATION || this.type == BehaviorType.CUSTOM) {
                if (mobpatch.getEntityState().canBasicAttack() && !this.nextBehaviors.isEmpty()) {
                    this.behaviorWaiting();
                } else if (!mobpatch.getEntityState().inaction() && this.nextBehaviors.isEmpty()) {
                    this.behaviorWaiting();
                }
            }
        }

        public void stopRunning(T mobpatch) {
            this.timeCount = this.behaviorTime;
            this.stopGuardAndWander(mobpatch);
        }

        public void stopGuardAndWander(T mobpatch) {
            ILivingEntityData entityData = (ILivingEntityData)mobpatch;
            if (this.type == BehaviorType.WANDER || this.type == BehaviorType.GUARD_WANDER) {
                entityData.nightFall_Invade$setWander((LivingEntity)mobpatch.getOriginal(), false);
            }
            if (this.type == BehaviorType.GUARD || this.type == BehaviorType.GUARD_WANDER) {
                entityData.nightFall_Invade$setGuard((LivingEntity)mobpatch.getOriginal(), false);
                entityData.nightFall_Invade$setInCounter((LivingEntity)mobpatch.getOriginal(), false);
                AssetAccessor guardAnimation = mobpatch.getAnimator().getLivingAnimation((LivingMotion)LivingMotions.BLOCK, (AssetAccessor)Animations.SWORD_GUARD);
                if (mobpatch.isLogicalClient()) {
                    mobpatch.getAnimator().stopPlaying(guardAnimation);
                } else {
                    mobpatch.stopPlaying(guardAnimation);
                }
            }
        }

        public void waiting(T mobpatch) {
            if (this.waitTime > 0) {
                --this.waitTime;
            } else {
                this.behaviorFinished();
            }
        }

        public void whenGuardHit() {
            switch (this.counterType) {
                case END: {
                    --this.guardHit;
                    if (this.guardHit > 0) break;
                    this.canCounter = true;
                    this.timeCount = 1;
                    break;
                }
                case RANDOM: {
                    if (!(this.counterChance >= Math.random())) break;
                    this.canCounter = true;
                    this.timeCount = 1;
                }
            }
        }

        public void behaviorWaiting() {
            if (this.totalWaitTime > 0) {
                this.state = BehaviorState.WAITING;
            } else {
                this.behaviorFinished();
            }
        }

        public void behaviorFinished() {
            this.state = BehaviorState.FINISHED;
            this.timeCount = this.behaviorTime;
            this.guardHit = this.maxGuardHit;
            this.waitTime = this.totalWaitTime;
            this.shouldExecuteTimeEvent = false;
        }

        public boolean isWaiting() {
            return this.state == BehaviorState.WAITING;
        }

        public boolean isRunning() {
            return this.state == BehaviorState.RUNNING;
        }

        public String getBehaviorName() {
            return this.behaviorName;
        }

        public boolean interruptByStun(StunType stunType) {
            if (this.interruptByStun == 1) {
                return true;
            }
            if (this.interruptByStun == 2) {
                return stunType != StunType.SHORT;
            }
            if (this.interruptByStun == 3) {
                return stunType != StunType.SHORT && stunType != StunType.LONG;
            }
            if (this.interruptByStun == 4) {
                return stunType != StunType.SHORT && stunType != StunType.LONG && stunType != StunType.HOLD;
            }
            if (this.interruptByStun == 5) {
                return stunType != StunType.SHORT && stunType != StunType.LONG && stunType != StunType.HOLD && stunType != StunType.FALL;
            }
            if (this.interruptByStun == 6) {
                return stunType != StunType.SHORT && stunType != StunType.LONG && stunType != StunType.HOLD && stunType != StunType.KNOCKDOWN;
            }
            if (this.interruptByStun == 7) {
                return stunType != StunType.SHORT && stunType != StunType.LONG && stunType != StunType.HOLD && stunType != StunType.FALL && stunType != StunType.KNOCKDOWN;
            }
            return stunType != StunType.SHORT && stunType != StunType.LONG && stunType != StunType.HOLD && stunType != StunType.FALL && stunType != StunType.KNOCKDOWN && stunType != StunType.NEUTRALIZE;
        }

        public AssetAccessor<? extends StaticAnimation> getCounterAnimation() {
            return this.counterAnimation;
        }

        public static <T extends MobPatch<?>> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T extends MobPatch<?>> {
            private Consumer<T> counter;
            private String behaviorName;
            private Consumer<T> behavior;
            private final List<Consumer<T>> exBehaviors = new ArrayList<Consumer<T>>();
            private final List<Consumer<T>> onCounterStart = new ArrayList<Consumer<T>>();
            private BehaviorType type = BehaviorType.NONE;
            private double priority = 1.0;
            private double weight = 1.0;
            private int exCoolDown = 0;
            private int behaviorTime = 0;
            private CounterType counterType = CounterType.NEVER;
            private double counterChance = 0.25;
            private int maxGuardHit = Integer.MAX_VALUE;
            private int totalWaitTime = 0;
            private int interruptByStun = 1;
            private boolean canInterruptParent = false;
            private boolean canBeInterrupted = false;
            private InterruptType interruptType = InterruptType.TIME;
            private List<Float> interruptedWindow = new ArrayList<Float>();
            private final List<Condition<T>> conditions = new ArrayList<Condition<T>>();
            private final List<Builder<T>> nextBehaviors = new ArrayList<Builder<T>>();
            private AssetAccessor<? extends StaticAnimation> counterAnimation;
            private final LivingEntityPatch.ServerAnimationPacketProvider packetProvider = SPAnimatorControl::new;
            private final List<TimeEvent> timeEventList = new ArrayList<TimeEvent>();

            public Builder<T> addTimeEvent(TimeEvent timeEvent) {
                this.timeEventList.add(timeEvent);
                return this;
            }

            public Builder<T> addTimeEvent(TimeEvent ... timeEvents) {
                this.timeEventList.addAll(List.of(timeEvents));
                return this;
            }

            public Builder<T> onCounterStart(Consumer<T> behavior) {
                this.onCounterStart.add(behavior);
                return this;
            }

            @SafeVarargs
            public final Builder<T> onCounterStart(Consumer<T> ... behavior) {
                this.exBehaviors.addAll(List.of(behavior));
                return this;
            }

            public Builder<T> counterAnimation(AssetAccessor<? extends StaticAnimation> counterAnimation, float transitionTime) {
                this.counterAnimation = counterAnimation;
                this.counter = mobpatch -> {
                    if (counterAnimation != null && counterAnimation != Animations.EMPTY_ANIMATION) {
                        if (mobpatch instanceof ILivingEntityData) {
                            ILivingEntityData livingEntityData = (ILivingEntityData)mobpatch;
                            livingEntityData.nightFall_Invade$setAttackSpeed((LivingEntity)mobpatch.getOriginal(), 1.0f);
                            livingEntityData.nightFall_Invade$setDamageMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                            livingEntityData.nightFall_Invade$setImpactMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                            livingEntityData.nightFall_Invade$setStunType((LivingEntity)mobpatch.getOriginal(), -1);
                        }
                        mobpatch.playAnimationSynchronized(counterAnimation, transitionTime, this.packetProvider);
                    }
                };
                return this;
            }

            public Builder<T> counterAnimation(AssetAccessor<? extends StaticAnimation> counterAnimation, float transitionTime, float attackSpeed, float damageMultiplier, float impactMultiplier) {
                this.counterAnimation = counterAnimation;
                this.counter = mobpatch -> {
                    if (counterAnimation != null && counterAnimation != Animations.EMPTY_ANIMATION) {
                        if (mobpatch instanceof ILivingEntityData) {
                            ILivingEntityData livingEntityData = (ILivingEntityData)mobpatch;
                            livingEntityData.nightFall_Invade$setAttackSpeed((LivingEntity)mobpatch.getOriginal(), attackSpeed);
                            livingEntityData.nightFall_Invade$setDamageMultiplier((LivingEntity)mobpatch.getOriginal(), damageMultiplier);
                            livingEntityData.nightFall_Invade$setImpactMultiplier((LivingEntity)mobpatch.getOriginal(), impactMultiplier);
                            livingEntityData.nightFall_Invade$setStunType((LivingEntity)mobpatch.getOriginal(), -1);
                        }
                        mobpatch.playAnimationSynchronized(counterAnimation, transitionTime, this.packetProvider);
                    }
                };
                return this;
            }

            public Builder<T> counterAnimation(AssetAccessor<? extends StaticAnimation> counterAnimation, float transitionTime, StunType stunType) {
                this.counterAnimation = counterAnimation;
                this.counter = mobpatch -> {
                    if (counterAnimation != null && counterAnimation != Animations.EMPTY_ANIMATION) {
                        if (mobpatch instanceof ILivingEntityData) {
                            ILivingEntityData livingEntityData = (ILivingEntityData)mobpatch;
                            livingEntityData.nightFall_Invade$setAttackSpeed((LivingEntity)mobpatch.getOriginal(), 1.0f);
                            livingEntityData.nightFall_Invade$setDamageMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                            livingEntityData.nightFall_Invade$setImpactMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                            livingEntityData.nightFall_Invade$setStunType((LivingEntity)mobpatch.getOriginal(), stunType);
                        }
                        mobpatch.playAnimationSynchronized(counterAnimation, transitionTime, this.packetProvider);
                    }
                };
                return this;
            }

            public Builder<T> counterAnimation(AssetAccessor<? extends StaticAnimation> counterAnimation, float transitionTime, float attackSpeed, float damageMultiplier, float impactMultiplier, StunType stunType) {
                this.counterAnimation = counterAnimation;
                this.counter = mobpatch -> {
                    if (counterAnimation != null && counterAnimation != Animations.EMPTY_ANIMATION) {
                        if (mobpatch instanceof ILivingEntityData) {
                            ILivingEntityData livingEntityData = (ILivingEntityData)mobpatch;
                            livingEntityData.nightFall_Invade$setAttackSpeed((LivingEntity)mobpatch.getOriginal(), attackSpeed);
                            livingEntityData.nightFall_Invade$setDamageMultiplier((LivingEntity)mobpatch.getOriginal(), damageMultiplier);
                            livingEntityData.nightFall_Invade$setImpactMultiplier((LivingEntity)mobpatch.getOriginal(), impactMultiplier);
                            livingEntityData.nightFall_Invade$setStunType((LivingEntity)mobpatch.getOriginal(), stunType);
                        }
                        mobpatch.playAnimationSynchronized(counterAnimation, transitionTime, this.packetProvider);
                    }
                };
                return this;
            }

            public Builder<T> counterType(CounterType counterType) {
                this.counterType = counterType;
                return this;
            }

            public Builder<T> counterChance(double counterChance) {
                this.counterChance = counterChance;
                return this;
            }

            public Builder<T> maxGuardHit(int maxGuardHit) {
                this.maxGuardHit = maxGuardHit;
                return this;
            }

            public Builder<T> canInterruptParent(boolean canInterruptParent) {
                this.canInterruptParent = canInterruptParent;
                return this;
            }

            public Builder<T> interruptedByTime(float start, float end) {
                this.canBeInterrupted = true;
                this.interruptType = InterruptType.TIME;
                this.interruptedWindow = new ArrayList<Float>(List.of(Float.valueOf(start), Float.valueOf(end)));
                return this;
            }

            public Builder<T> interruptedByLevel(Integer ... levels) {
                this.canBeInterrupted = true;
                this.interruptType = InterruptType.LEVEL;
                Integer[] integerArray = levels;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int level = integerArray[i];
                    this.interruptedWindow.add(Float.valueOf(level));
                }
                return this;
            }

            public Builder<T> setCooldown(int exCoolDown) {
                this.exCoolDown = exCoolDown;
                return this;
            }

            public Builder<T> addCooldown(int exCoolDown) {
                this.exCoolDown += exCoolDown;
                return this;
            }

            public Builder<T> waitTime(int waitTime) {
                this.totalWaitTime = waitTime;
                return this;
            }

            public Builder<T> interruptByStun(int interruptByStun) {
                this.interruptByStun = interruptByStun;
                return this;
            }

            public Builder<T> customBehavior(Consumer<T> behavior) {
                this.behavior = behavior;
                this.type = BehaviorType.CUSTOM;
                return this;
            }

            public Builder<T> name(String name) {
                this.behaviorName = name;
                return this;
            }

            public Builder<T> addExBehavior(Consumer<T> behavior) {
                this.exBehaviors.add(behavior);
                return this;
            }

            @SafeVarargs
            public final Builder<T> addExBehavior(Consumer<T> ... behaviors) {
                this.exBehaviors.addAll(List.of(behaviors));
                return this;
            }

            public Builder<T> setPhase(int phase) {
                this.exBehaviors.add(mobpatch -> {
                    ILivingEntityData entityData = (ILivingEntityData)mobpatch;
                    entityData.nightFall_Invade$setPhase((LivingEntity)mobpatch.getOriginal(), phase);
                });
                return this;
            }

            public Builder<T> wander(int totalTime, float pForward, float pStrafe) {
                this.behaviorTime = totalTime;
                this.type = BehaviorType.WANDER;
                this.behavior = mobpatch -> ((Mob)mobpatch.getOriginal()).m_21566_().m_24988_(pForward, pStrafe);
                return this;
            }

            public Builder<T> wanderWithAnimation(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, int totalTime, float pForward, float pStrafe) {
                this.behaviorTime = totalTime;
                this.type = BehaviorType.WANDER;
                this.behavior = mobpatch -> {
                    mobpatch.playAnimationSynchronized((AssetAccessor)animation, 0.0f);
                    ((Mob)mobpatch.getOriginal()).m_21566_().m_24988_(pForward, pStrafe);
                };
                return this;
            }

            public Builder<T> guard(int totalTime) {
                this.behaviorTime = totalTime;
                this.type = BehaviorType.GUARD;
                this.behavior = mobpatch -> {
                    if (!mobpatch.getEntityState().inaction()) {
                        mobpatch.playAnimationSynchronized(mobpatch.getAnimator().getLivingAnimation((LivingMotion)LivingMotions.BLOCK, (AssetAccessor)Animations.SWORD_GUARD), 0.0f, this.packetProvider);
                    }
                };
                return this;
            }

            public Builder<T> guardWithWander(int totalTime, float pForward, float pStrafe) {
                this.behaviorTime = totalTime;
                this.type = BehaviorType.GUARD_WANDER;
                this.behavior = mobpatch -> ((Mob)mobpatch.getOriginal()).m_21566_().m_24988_(pForward, pStrafe);
                return this;
            }

            public Builder<T> animationBehavior(AnimationManager.AnimationAccessor<? extends StaticAnimation> motion, float transitionTime) {
                this.type = BehaviorType.ANIMATION;
                this.behavior = mobpatch -> {
                    if (mobpatch instanceof ILivingEntityData) {
                        ILivingEntityData livingEntityData = (ILivingEntityData)mobpatch;
                        livingEntityData.nightFall_Invade$setAttackSpeed((LivingEntity)mobpatch.getOriginal(), 1.0f);
                        livingEntityData.nightFall_Invade$setDamageMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                        livingEntityData.nightFall_Invade$setImpactMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                        livingEntityData.nightFall_Invade$setStunType((LivingEntity)mobpatch.getOriginal(), -1);
                    }
                    mobpatch.playAnimationSynchronized((AssetAccessor)motion, transitionTime, this.packetProvider);
                };
                return this;
            }

            public Builder<T> animationBehavior(AnimationManager.AnimationAccessor<? extends StaticAnimation> motion, float transitionTime, float attackSpeed) {
                this.type = BehaviorType.ANIMATION;
                this.behavior = mobpatch -> {
                    if (mobpatch instanceof ILivingEntityData) {
                        ILivingEntityData livingEntityData = (ILivingEntityData)mobpatch;
                        livingEntityData.nightFall_Invade$setAttackSpeed((LivingEntity)mobpatch.getOriginal(), attackSpeed);
                        livingEntityData.nightFall_Invade$setDamageMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                        livingEntityData.nightFall_Invade$setImpactMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                        livingEntityData.nightFall_Invade$setStunType((LivingEntity)mobpatch.getOriginal(), -1);
                    }
                    mobpatch.playAnimationSynchronized((AssetAccessor)motion, transitionTime, this.packetProvider);
                };
                return this;
            }

            public Builder<T> animationBehavior(AnimationManager.AnimationAccessor<? extends StaticAnimation> motion, float transitionTime, StunType stunType) {
                this.type = BehaviorType.ANIMATION;
                this.behavior = mobpatch -> {
                    if (mobpatch instanceof ILivingEntityData) {
                        ILivingEntityData livingEntityData = (ILivingEntityData)mobpatch;
                        livingEntityData.nightFall_Invade$setAttackSpeed((LivingEntity)mobpatch.getOriginal(), 1.0f);
                        livingEntityData.nightFall_Invade$setDamageMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                        livingEntityData.nightFall_Invade$setImpactMultiplier((LivingEntity)mobpatch.getOriginal(), 1.0f);
                        livingEntityData.nightFall_Invade$setStunType((LivingEntity)mobpatch.getOriginal(), stunType);
                    }
                    mobpatch.playAnimationSynchronized((AssetAccessor)motion, transitionTime, this.packetProvider);
                };
                return this;
            }

            public Builder<T> animationBehavior(AnimationManager.AnimationAccessor<? extends StaticAnimation> motion, float transitionTime, float attackSpeed, float damageMultiplier, float impactMultiplier) {
                this.type = BehaviorType.ANIMATION;
                this.behavior = mobpatch -> {
                    if (mobpatch instanceof ILivingEntityData) {
                        ILivingEntityData livingEntityData = (ILivingEntityData)mobpatch;
                        livingEntityData.nightFall_Invade$setAttackSpeed((LivingEntity)mobpatch.getOriginal(), attackSpeed);
                        livingEntityData.nightFall_Invade$setDamageMultiplier((LivingEntity)mobpatch.getOriginal(), damageMultiplier);
                        livingEntityData.nightFall_Invade$setImpactMultiplier((LivingEntity)mobpatch.getOriginal(), impactMultiplier);
                        livingEntityData.nightFall_Invade$setStunType((LivingEntity)mobpatch.getOriginal(), -1);
                    }
                    mobpatch.playAnimationSynchronized((AssetAccessor)motion, transitionTime, this.packetProvider);
                };
                return this;
            }

            public Builder<T> animationBehavior(AnimationManager.AnimationAccessor<? extends StaticAnimation> motion, float transitionTime, float attackSpeed, float damageMultiplier, float impactMultiplier, StunType stunType) {
                this.type = BehaviorType.ANIMATION;
                this.behavior = mobpatch -> {
                    if (mobpatch instanceof ILivingEntityData) {
                        ILivingEntityData livingEntityData = (ILivingEntityData)mobpatch;
                        livingEntityData.nightFall_Invade$setAttackSpeed((LivingEntity)mobpatch.getOriginal(), attackSpeed);
                        livingEntityData.nightFall_Invade$setDamageMultiplier((LivingEntity)mobpatch.getOriginal(), damageMultiplier);
                        livingEntityData.nightFall_Invade$setImpactMultiplier((LivingEntity)mobpatch.getOriginal(), impactMultiplier);
                        livingEntityData.nightFall_Invade$setStunType((LivingEntity)mobpatch.getOriginal(), stunType);
                    }
                    mobpatch.playAnimationSynchronized((AssetAccessor)motion, transitionTime, this.packetProvider);
                };
                return this;
            }

            public Builder<T> priority(double priority) {
                this.priority = priority;
                return this;
            }

            public Builder<T> weight(double weight) {
                this.weight = weight;
                return this;
            }

            public Builder<T> addNextBehavior(Builder<T> builder) {
                this.nextBehaviors.add(builder);
                return this;
            }

            public Builder<T> withinEyeHeight() {
                this.condition((Condition<?>)new TargetInEyeHeight());
                return this;
            }

            public Builder<T> randomChance(float chance) {
                this.condition((Condition<?>)new RandomChance(chance));
                return this;
            }

            public Builder<T> withinDistance(double minDistance, double maxDistance) {
                this.condition((Condition<?>)new TargetInDistance(minDistance, maxDistance));
                return this;
            }

            public Builder<T> entityTag(String tag) {
                this.condition(new EntityTag(tag));
                return this;
            }

            public Builder<T> withinCurrentAngle(String side, double degreeFirst, double degreeSecond) {
                this.condition(new CurrentAngle(side, degreeFirst, degreeSecond));
                return this;
            }

            public Builder<T> withinAngle(double minDegree, double maxDegree) {
                this.condition((Condition<?>)new TargetInPov(minDegree, maxDegree));
                return this;
            }

            public Builder<T> attackLevel(int min, int max) {
                return this.custom(patch -> {
                    LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)patch.getTarget(), LivingEntityPatch.class);
                    if (targetPatch == null) {
                        return false;
                    }
                    int level = targetPatch.getEntityState().getLevel();
                    return min <= level && level <= max;
                });
            }

            public Builder<T> attackLevelContain(Integer ... levels) {
                return this.custom(patch -> {
                    LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)patch.getTarget(), LivingEntityPatch.class);
                    if (targetPatch == null) {
                        return false;
                    }
                    int level = targetPatch.getEntityState().getLevel();
                    return Arrays.stream(levels).toList().contains(level);
                });
            }

            public Builder<T> phaseBetween(int min, int max) {
                return this.custom(mobpatch -> {
                    ILivingEntityData entityData = (ILivingEntityData)mobpatch;
                    int phase = entityData.nightFall_Invade$getPhase((LivingEntity)mobpatch.getOriginal());
                    return min <= phase && phase <= max;
                });
            }

            public Builder<T> phaseContain(Integer ... phases) {
                return this.custom(mobpatch -> {
                    ArrayList<Integer> list = new ArrayList<Integer>(List.of(phases));
                    ILivingEntityData entityData = (ILivingEntityData)mobpatch;
                    int phase = entityData.nightFall_Invade$getPhase((LivingEntity)mobpatch.getOriginal());
                    return list.contains(phase);
                });
            }

            public Builder<T> targetAnimation(AssetAccessor<? extends StaticAnimation> animation) {
                return this.custom(mobpatch -> {
                    LivingEntityPatch entityPatch;
                    LivingEntity target = mobpatch.getTarget();
                    if (target != null && (entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)target, LivingEntityPatch.class)) != null) {
                        AssetAccessor tAnimation = Objects.requireNonNull(entityPatch.getAnimator().getPlayerFor(null)).getRealAnimation();
                        return animation == tAnimation;
                    }
                    return false;
                });
            }

            public Builder<T> withinAngleHorizontal(double minDegree, double maxDegree) {
                this.condition((Condition<?>)new TargetInPov.TargetInPovHorizontal(minDegree, maxDegree));
                return this;
            }

            public Builder<T> health(float health, HealthCheck.Comparator comparator) {
                this.condition((Condition<?>)new HealthCheck(health, comparator));
                return this;
            }

            public Builder<T> custom(Function<T, Boolean> customPredicate) {
                this.condition((Condition<?>)new CustomCondition(customPredicate));
                return this;
            }

            public void condition(Condition<?> predicate) {
                this.conditions.add(predicate);
            }

            public Behavior<T> build(BehaviorRoot<T> behaviorRoot) {
                return new Behavior<T>(this, behaviorRoot);
            }
        }
    }

    public static enum BehaviorType {
        ANIMATION,
        GUARD,
        WANDER,
        GUARD_WANDER,
        CUSTOM,
        NONE;

    }

    public static enum BehaviorState {
        RUNNING,
        WAITING,
        FINISHED;

    }

    public static enum CounterType {
        NEVER,
        RANDOM,
        END;

    }

    public static enum InterruptType {
        TIME,
        LEVEL;

    }
}

