/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.ai;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.shelmarow.nightfall_invade.ai.NFICombatBehaviors;
import net.shelmarow.nightfall_invade.iml.ILivingEntityData;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class NFIAnimationAttackGoal<T extends MobPatch<?>>
extends Goal {
    protected final T mobpatch;
    protected final NFICombatBehaviors<T> combatBehaviors;
    protected boolean actionStoped = false;

    public NFIAnimationAttackGoal(T mobpatch, NFICombatBehaviors<T> combatBehaviors) {
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
    }

    public boolean m_8036_() {
        this.actionStoped = this.combatBehaviors.getCurrentBehavior() != null && !this.mobpatch.getEntityState().inaction();
        return this.checkTargetValid() || this.actionStoped;
    }

    public NFICombatBehaviors<T> getCombatBehaviors() {
        return this.combatBehaviors;
    }

    public void interruptByStun(StunType stunType) {
        NFICombatBehaviors.Behavior<T> currentBehavior = this.combatBehaviors.getCurrentBehavior();
        if (currentBehavior != null && currentBehavior.interruptByStun(stunType)) {
            this.clearCurrentBehavior(currentBehavior);
        }
    }

    public void clearCurrentBehavior(NFICombatBehaviors.Behavior<?> currentBehavior) {
        currentBehavior.resetCooldown();
        this.combatBehaviors.clearCurrentBehavior();
        ILivingEntityData entityData = (ILivingEntityData)this.mobpatch;
        entityData.nightFall_Invade$setWander((LivingEntity)this.mobpatch.getOriginal(), false);
        entityData.nightFall_Invade$setGuard((LivingEntity)this.mobpatch.getOriginal(), false);
    }

    public void m_8037_() {
        NFICombatBehaviors.Behavior<T> currentBehavior = this.combatBehaviors.getCurrentBehavior();
        if (this.mobpatch.getTarget() == null) {
            if (currentBehavior != null) {
                currentBehavior.resetCooldown();
                this.combatBehaviors.clearCurrentBehavior();
                ILivingEntityData entityData = (ILivingEntityData)this.mobpatch;
                entityData.nightFall_Invade$setWander((LivingEntity)this.mobpatch.getOriginal(), false);
                entityData.nightFall_Invade$setGuard((LivingEntity)this.mobpatch.getOriginal(), false);
            }
        } else {
            this.combatBehaviors.tick(this.mobpatch);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    protected boolean checkTargetValid() {
        LivingEntity livingentity = this.mobpatch.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (livingentity instanceof Player) {
            Player player = (Player)livingentity;
            return !livingentity.m_5833_() && !player.m_7500_();
        }
        return true;
    }
}

