package net.shelmarow.nightfall_invade.tickTask.tasks;

import com.hm.efn.registries.EFNMobEffectRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.shelmarow.nightfall_invade.ai.NFIHumanoidPatch;
import net.shelmarow.nightfall_invade.gameassets.ExecutionSkillAnimations;
import net.shelmarow.nightfall_invade.iml.CustomExecuteEntity;
import net.shelmarow.nightfall_invade.tickTask.TickTask;
import net.shelmarow.nightfall_invade.tickTask.handler.ExecutionHandler;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class Execution extends TickTask {
   private final LivingEntity executor;
   private final LivingEntity target;
   private final boolean isFont;
   private final Map<WeaponCategory, AnimationManager.AnimationAccessor<? extends StaticAnimation>> executionSwordList = new HashMap(Map.of());

   public Execution(LivingEntity executor, LivingEntity target, int durationTicks, boolean isFont) {
      super(durationTicks);
      this.isFont = isFont;
      this.executor = executor;
      this.target = target;
   }

   public void onStart() {
      ExecutionHandler.addExecutingTarget(this.target, this.executor);
      LivingEntityPatch<?> entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(this.executor, LivingEntityPatch.class);
      LivingEntityPatch<?> targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(this.target, LivingEntityPatch.class);
      this.executor.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 100, 1, true, false));
      this.target.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 100, 1, true, false));
      if (entityPatch instanceof PlayerPatch<?> playerPatch) {
         playerPatch.setStamina(playerPatch.getMaxStamina());
         this.executor.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 4));
      }

      if (entityPatch instanceof HumanoidMobPatch || entityPatch instanceof NFIHumanoidPatch || entityPatch instanceof PlayerPatch) {
         AnimationManager.AnimationAccessor<? extends StaticAnimation> animation = ExecutionSkillAnimations.EXECUTION;
         CapabilityItem capabilityItem = entityPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND);
         if (capabilityItem != null) {
            WeaponCategory weaponCategory = capabilityItem.getWeaponCategory();
            animation = (AnimationManager.AnimationAccessor)this.executionSwordList.getOrDefault(weaponCategory, animation);
         }

         entityPatch.playAnimationSynchronized(animation, 0.0F);
         Vec3 from = this.executor.m_146892_();
         Vec3 to = this.target.m_146892_();
         double dx = to.f_82479_ - from.f_82479_;
         double dz = to.f_82481_ - from.f_82481_;
         float yaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0) - 10.0F;
         if (entityPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
            serverPlayerPatch.setModelYRot(yaw, true);
         } else {
            entityPatch.setYRot(yaw);
         }
      }

      if (targetPatch instanceof CustomExecuteEntity customExecuteEntity) {
         targetPatch.playAnimationSynchronized(customExecuteEntity.getExecutedAnimation(this.isFont), 0.0F);
      } else if (targetPatch instanceof HumanoidMobPatch || targetPatch instanceof NFIHumanoidPatch || targetPatch instanceof PlayerPatch) {
         targetPatch.playAnimationSynchronized(ExecutionSkillAnimations.EXECUTED_FULL, 0.0F);
      }

   }

   public void onTick() {
   }

   public void onFinish() {
      ExecutionHandler.removeExecutingTarget(this.target);
   }
}
