package net.shelmarow.nightfall_invade.tickTask.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;
import net.shelmarow.nightfall_invade.ai.NFIHumanoidPatch;
import net.shelmarow.nightfall_invade.iml.CustomExecuteEntity;
import net.shelmarow.nightfall_invade.tickTask.TickTaskManager;
import net.shelmarow.nightfall_invade.tickTask.tasks.Execution;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.CustomMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.CapabilityItem.WeaponCategories;
import yesman.epicfight.world.damagesource.StunType;

@EventBusSubscriber(
   modid = "nightfall_invade",
   bus = Bus.FORGE
)
public class ExecutionHandler {
   private static final Map<LivingEntity, LivingEntity> executingTargets = new HashMap();

   @SubscribeEvent(
      priority = EventPriority.HIGHEST
   )
   public static void onLivingAttack(LivingAttackEvent event) {
      LivingEntity target = event.getEntity();
      Entity source = event.getSource().m_7639_();
      if (!event.getSource().m_276093_(DamageTypes.f_286979_)) {
         LivingEntity livingEntity;
         if (executingTargets.containsKey(target)) {
            livingEntity = (LivingEntity)executingTargets.get(target);
            if (source == null || !source.m_20148_().equals(livingEntity.m_20148_())) {
               event.setCanceled(true);
            }
         } else if (executingTargets.containsValue(target)) {
            event.setCanceled(true);
         }

         if (source instanceof LivingEntity) {
            livingEntity = (LivingEntity)source;
            if (executingTargets.containsValue(livingEntity) && !executingTargets.containsKey(target)) {
               event.setCanceled(true);
            }
         }

      }
   }

   @SubscribeEvent
   public static void onKnockback(LivingKnockBackEvent event) {
      Entity target = event.getEntity();
      if (executingTargets.containsKey(target)) {
         event.setStrength(0.0F);
      }

   }

   @SubscribeEvent
   public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
      if (event.getSide().isServer()) {
         Entity entity = event.getTarget();
         ServerPlayer player = (ServerPlayer)event.getEntity();
         ServerPlayerPatch playerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch(player, ServerPlayerPatch.class);
         LivingEntityPatch<?> entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
         if (entityPatch != null && playerPatch != null && playerPatch.getEntityState().canUseSkill()) {
            AssetAccessor<? extends DynamicAnimation> stunAnimation = ((AnimationPlayer)Objects.requireNonNull(entityPatch.getAnimator().getPlayerFor((AssetAccessor)null))).getAnimation();
            if (entity instanceof LivingEntity) {
               LivingEntity livingEntity = (LivingEntity)entity;
               if (canExecuteFont(player, livingEntity, entityPatch) && stunAnimation != null && stunAnimation == entityPatch.getHitAnimation(StunType.NEUTRALIZE) && placePlayerInFront(player, livingEntity, 1.350000023841858)) {
                  TickTaskManager.addTask(entity.m_20148_(), new Execution(player, livingEntity, 100, true));
               }
            }
         }

      }
   }

   public static boolean canExecuteFont(Player player, LivingEntity entity, LivingEntityPatch<?> entityPatch) {
      return player.m_6084_() && entity.m_6084_() && isExecutingTarget(player, entity) && canBeExecuted(entityPatch) && isHoldingWeapon(player) && isInFrontOfTarget(player, entity, 0.0, 3.0, 120.0);
   }

   public static boolean isHoldingWeapon(Player player) {
      CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability(player.m_21120_(InteractionHand.MAIN_HAND));
      return capabilityItem.getWeaponCategory() != WeaponCategories.NOT_WEAPON && capabilityItem.getWeaponCategory() != WeaponCategories.FIST;
   }

   public static boolean canBeExecuted(LivingEntityPatch<?> entityPatch) {
      if (entityPatch instanceof CustomExecuteEntity customExecuteEntity) {
         return customExecuteEntity.canBeExecuted(entityPatch);
      } else {
         return entityPatch instanceof HumanoidMobPatch || entityPatch instanceof NFIHumanoidPatch || entityPatch instanceof CustomMobPatch || entityPatch instanceof PlayerPatch;
      }
   }

   public static void addExecutingTarget(LivingEntity target, LivingEntity executor) {
      executingTargets.put(target, executor);
   }

   public static void removeExecutingTarget(LivingEntity target) {
      executingTargets.remove(target);
   }

   public static boolean isExecutingTarget(LivingEntity executor, LivingEntity target) {
      return !executingTargets.containsKey(target) && !executingTargets.containsKey(executor);
   }

   public static boolean placePlayerInFront(Player player, LivingEntity target, double distance) {
      Level level = player.m_9236_();
      Vec3 frontPos = calculateFrontPosition(target, distance);
      if (canStandHere(level, frontPos)) {
         player.m_6021_(frontPos.f_82479_, frontPos.f_82480_, frontPos.f_82481_);
         return true;
      } else {
         return false;
      }
   }

   private static Vec3 calculateFrontPosition(LivingEntity target, double distance) {
      float yaw = target.m_146908_();
      double rad = Math.toRadians((double)yaw);
      double offsetX = -Math.sin(rad) * distance;
      double offsetZ = Math.cos(rad) * distance;
      return target.m_20182_().m_82520_(offsetX, 0.0, offsetZ);
   }

   public static boolean isInFrontOfTarget(Player player, LivingEntity target, double minDist, double maxDist, double maxAngleDegrees) {
      Vec3 targetPos = target.m_20182_();
      Vec3 playerPos = player.m_20182_();
      double distance = playerPos.m_82554_(targetPos);
      if (!(distance < minDist) && !(distance > maxDist)) {
         float yaw = target.m_146908_();
         double yawRad = Math.toRadians((double)yaw);
         Vec3 forward = (new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad))).m_82541_();
         Vec3 toPlayer = playerPos.m_82546_(targetPos).m_82541_();
         double dot = forward.m_82526_(toPlayer);
         double angle = Math.toDegrees(Math.acos(dot));
         return angle <= maxAngleDegrees;
      } else {
         return false;
      }
   }

   public static boolean canStandHere(Level level, Vec3 pos) {
      BlockPos blockPosBelow = new BlockPos((int)pos.f_82479_, (int)(pos.f_82480_ - 1.0), (int)pos.f_82481_);
      BlockState stateBelow = level.m_8055_(blockPosBelow);
      boolean solidBelow = stateBelow.m_280296_();
      boolean spaceFree = level.m_45772_(new AABB(pos.f_82479_ - 0.3, pos.f_82480_, pos.f_82481_ - 0.3, pos.f_82479_ + 0.3, pos.f_82480_ + 1.8, pos.f_82481_ + 0.3));
      return solidBelow && spaceFree;
   }
}
