package net.shelmarow.nightfall_invade.mixins;

import net.shelmarow.nightfall_invade.ai.NFIHumanoidPatch;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

@Mixin(
   value = {GuardSkill.class},
   remap = false
)
public class GuardSkillMixin {
   @Inject(
      method = {"dealEvent"},
      at = {@At("HEAD")}
   )
   private void ontDealEvent(PlayerPatch<?> playerpatch, TakeDamageEvent.Attack event, boolean advanced, CallbackInfo ci) {
      if (event.isParried()) {
         LivingEntityPatch<?> livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(event.getDamageSource().m_7640_(), LivingEntityPatch.class);
         if (livingEntityPatch instanceof NFIHumanoidPatch) {
            NFIHumanoidPatch nfiHumanoidPatch = (NFIHumanoidPatch)livingEntityPatch;
            nfiHumanoidPatch.onAttackParried(event.getDamageSource(), playerpatch);
         }
      }

   }
}
