package net.shelmarow.nightfall_invade.mixins;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.LivingEntity;
import net.shelmarow.nightfall_invade.iml.ILivingEntityData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.StunType;

@Mixin({LivingEntityPatch.class})
public abstract class EFLivingEntityPatch implements ILivingEntityData {
   @Unique
   private static EntityDataAccessor<Integer> nightFall_Invade$PHASE;
   @Unique
   private static EntityDataAccessor<Float> nightFall_Invade$ATTACK_SPEED;
   @Unique
   private static EntityDataAccessor<Float> nightFall_Invade$DAMAGE_MULTIPLIER;
   @Unique
   private static EntityDataAccessor<Float> nightFall_Invade$IMPACT_MULTIPLIER;
   @Unique
   private static EntityDataAccessor<Integer> nightFall_Invade$STUN_TYPE;
   @Unique
   private static EntityDataAccessor<Float> nightFall_Invade$STAMINA;
   @Unique
   private static EntityDataAccessor<Boolean> nightFall_Invade$GUARD;
   @Unique
   private static EntityDataAccessor<Boolean> nightFall_Invade$IN_COUNTER;
   @Unique
   private static EntityDataAccessor<Boolean> nightFall_Invade$WANDER;

   @Unique
   public int nightFall_Invade$getPhase(LivingEntity entity) {
      return (Integer)entity.m_20088_().m_135370_(nightFall_Invade$PHASE);
   }

   @Unique
   public void nightFall_Invade$setPhase(LivingEntity entity, int phase) {
      entity.m_20088_().m_135381_(nightFall_Invade$PHASE, phase);
   }

   @Unique
   public float nightFall_Invade$getAttackSpeed(LivingEntity entity) {
      return (Float)entity.m_20088_().m_135370_(nightFall_Invade$ATTACK_SPEED);
   }

   @Unique
   public void nightFall_Invade$setAttackSpeed(LivingEntity entity, float speed) {
      entity.m_20088_().m_135381_(nightFall_Invade$ATTACK_SPEED, Math.max(0.0F, speed));
   }

   public float nightFall_Invade$getDamageMultiplier(LivingEntity entity) {
      return (Float)entity.m_20088_().m_135370_(nightFall_Invade$DAMAGE_MULTIPLIER);
   }

   public void nightFall_Invade$setDamageMultiplier(LivingEntity entity, float multiplier) {
      entity.m_20088_().m_135381_(nightFall_Invade$DAMAGE_MULTIPLIER, Math.max(0.0F, multiplier));
   }

   public float nightFall_Invade$getImpactMultiplier(LivingEntity entity) {
      return (Float)entity.m_20088_().m_135370_(nightFall_Invade$IMPACT_MULTIPLIER);
   }

   public void nightFall_Invade$setImpactMultiplier(LivingEntity entity, float multiplier) {
      entity.m_20088_().m_135381_(nightFall_Invade$IMPACT_MULTIPLIER, Math.max(0.0F, multiplier));
   }

   public int nightFall_Invade$getStunType(LivingEntity entity) {
      return (Integer)entity.m_20088_().m_135370_(nightFall_Invade$STUN_TYPE);
   }

   public void nightFall_Invade$setStunType(LivingEntity entity, StunType stunType) {
      entity.m_20088_().m_135381_(nightFall_Invade$STUN_TYPE, stunType.ordinal());
   }

   public void nightFall_Invade$setStunType(LivingEntity entity, int stunType) {
      entity.m_20088_().m_135381_(nightFall_Invade$STUN_TYPE, stunType);
   }

   @Unique
   public float nightFall_Invade$getStamina(LivingEntity entity) {
      return (Float)entity.m_20088_().m_135370_(nightFall_Invade$STAMINA);
   }

   @Unique
   public void nightFall_Invade$setStamina(LivingEntity entity, float stamina) {
      entity.m_20088_().m_135381_(nightFall_Invade$STAMINA, stamina);
   }

   @Unique
   public boolean nightFall_Invade$isGuard(LivingEntity entity) {
      return (Boolean)entity.m_20088_().m_135370_(nightFall_Invade$GUARD);
   }

   @Unique
   public void nightFall_Invade$setGuard(LivingEntity entity, boolean guard) {
      entity.m_20088_().m_135381_(nightFall_Invade$GUARD, guard);
   }

   @Unique
   public boolean nightFall_Invade$isInCounter(LivingEntity entity) {
      return (Boolean)entity.m_20088_().m_135370_(nightFall_Invade$IN_COUNTER);
   }

   @Unique
   public void nightFall_Invade$setInCounter(LivingEntity entity, boolean counter) {
      entity.m_20088_().m_135381_(nightFall_Invade$IN_COUNTER, counter);
   }

   @Unique
   public boolean nightFall_Invade$isWander(LivingEntity entity) {
      return (Boolean)entity.m_20088_().m_135370_(nightFall_Invade$WANDER);
   }

   @Unique
   public void nightFall_Invade$setWander(LivingEntity entity, boolean wander) {
      entity.m_20088_().m_135381_(nightFall_Invade$WANDER, wander);
   }

   @Inject(
      method = {"initLivingEntityDataAccessor"},
      at = {@At("HEAD")},
      remap = false
   )
   private static void onInitLivingEntityDataAccessor(CallbackInfo ci) {
      nightFall_Invade$PHASE = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135028_);
      nightFall_Invade$ATTACK_SPEED = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135029_);
      nightFall_Invade$DAMAGE_MULTIPLIER = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135029_);
      nightFall_Invade$IMPACT_MULTIPLIER = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135029_);
      nightFall_Invade$STUN_TYPE = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135028_);
      nightFall_Invade$STAMINA = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135029_);
      nightFall_Invade$GUARD = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135035_);
      nightFall_Invade$IN_COUNTER = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135035_);
      nightFall_Invade$WANDER = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135035_);
   }

   @Inject(
      method = {"createSyncedEntityData"},
      at = {@At("HEAD")},
      remap = false
   )
   private static void onCreateSyncedEntityData(LivingEntity livingentity, CallbackInfo ci) {
      livingentity.m_20088_().m_135372_(nightFall_Invade$PHASE, 0);
      livingentity.m_20088_().m_135372_(nightFall_Invade$ATTACK_SPEED, 1.0F);
      livingentity.m_20088_().m_135372_(nightFall_Invade$DAMAGE_MULTIPLIER, 1.0F);
      livingentity.m_20088_().m_135372_(nightFall_Invade$IMPACT_MULTIPLIER, 1.0F);
      livingentity.m_20088_().m_135372_(nightFall_Invade$STUN_TYPE, -1);
      livingentity.m_20088_().m_135372_(nightFall_Invade$STAMINA, 0.0F);
      livingentity.m_20088_().m_135372_(nightFall_Invade$GUARD, false);
      livingentity.m_20088_().m_135372_(nightFall_Invade$IN_COUNTER, false);
      livingentity.m_20088_().m_135372_(nightFall_Invade$WANDER, false);
   }
}
