package net.shelmarow.nightfall_invade.mixins;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.shelmarow.nightfall_invade.ai.NFIHumanoidPatch;
import net.shelmarow.nightfall_invade.iml.ILivingEntityData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

@Mixin(
   value = {AttackAnimation.class},
   remap = false
)
public class EFAttackAnimation {
   @Inject(
      method = {"getPlaySpeed"},
      at = {@At("HEAD")},
      cancellable = true
   )
   private void onGetPlaySpeed(LivingEntityPatch<?> entityPatch, DynamicAnimation animation, CallbackInfoReturnable<Float> cir) {
      if (entityPatch instanceof NFIHumanoidPatch) {
         ILivingEntityData livingEntityData = (ILivingEntityData)entityPatch;
         cir.setReturnValue(livingEntityData.nightFall_Invade$getAttackSpeed((LivingEntity)entityPatch.getOriginal()));
      }

   }

   @Inject(
      method = {"getEpicFightDamageSource(Lnet/minecraft/world/damagesource/DamageSource;Lyesman/epicfight/world/capabilities/entitypatch/LivingEntityPatch;Lnet/minecraft/world/entity/Entity;Lyesman/epicfight/api/animation/types/AttackAnimation$Phase;)Lyesman/epicfight/world/damagesource/EpicFightDamageSource;"},
      at = {@At("RETURN")},
      cancellable = true
   )
   private void onGetDamageSource(DamageSource originalSource, LivingEntityPatch<?> entitypatch, Entity target, AttackAnimation.Phase phase, CallbackInfoReturnable<EpicFightDamageSource> cir) {
      if (entitypatch instanceof NFIHumanoidPatch) {
         ILivingEntityData entityData = (ILivingEntityData)entitypatch;
         EpicFightDamageSource returnValue = (EpicFightDamageSource)cir.getReturnValue();
         float damage = entityData.nightFall_Invade$getDamageMultiplier((LivingEntity)entitypatch.getOriginal());
         float impact = entityData.nightFall_Invade$getImpactMultiplier((LivingEntity)entitypatch.getOriginal());
         int stunIndex = entityData.nightFall_Invade$getStunType((LivingEntity)entitypatch.getOriginal());
         if (stunIndex != -1) {
            StunType stunType = StunType.values()[stunIndex];
            returnValue.setStunType(stunType);
         }

         returnValue.attachDamageModifier(ValueModifier.multiplier(damage));
         returnValue.attachImpactModifier(ValueModifier.multiplier(impact));
         cir.setReturnValue(returnValue);
      }

   }
}
