package net.shelmarow.nightfall_invade.gameassets;

import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.AnimationProperty.AttackPhaseProperty;
import yesman.epicfight.api.animation.property.AnimationProperty.StaticAnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LongHitAnimation;
import yesman.epicfight.api.collider.MultiCollider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;

@EventBusSubscriber(
   modid = "nightfall_invade",
   bus = Bus.MOD
)
public class ExecutionSkillAnimations {
   public static AnimationManager.AnimationAccessor<AttackAnimation> EXECUTION;
   public static AnimationManager.AnimationAccessor<LongHitAnimation> EXECUTED_FULL;
   private static final ExtraDamageInstance.ExtraDamage TARGET_MAX_HEALTH = new ExtraDamageInstance.ExtraDamage((attacker, itemstack, target, baseDamage, params) -> {
      return target.m_21233_() * params[0];
   }, (itemstack, tooltips, baseDamage, params) -> {
   });

   @SubscribeEvent(
      priority = EventPriority.LOWEST
   )
   public static void registerAnimations(AnimationManager.AnimationRegistryEvent event) {
      event.newBuilder("nightfall_invade", ExecutionSkillAnimations::build);
   }

   public static void build(AnimationManager.AnimationBuilder builder) {
      MultiCollider<OBBCollider> executionCollider = new MultiOBBCollider(3, 1.25, 1.5, 1.5, 0.0, 1.5, -1.5);
      AnimationProperty.PlaybackSpeedModifier CONSTANT_EXECUTION = (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> {
         return 1.0F;
      };
      AnimationProperty.PlaybackSpeedModifier CONSTANT_EXECUTED = (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> {
         return 0.8333333F;
      };
      EXECUTION = builder.nextAccessor("biped/skill/execution/execution_sword", (accessor) -> {
         return (AttackAnimation)(new AttackAnimation(0.01F, accessor, Armatures.BIPED, new AttackAnimation.Phase[]{(new AttackAnimation.Phase(0.0F, 0.0F, 0.76F, 0.93F, 0.93F, 0.93F, ((HumanoidArmature)Armatures.BIPED.get()).rootJoint, executionCollider)).addProperty(AttackPhaseProperty.MAX_STRIKES_MODIFIER, ValueModifier.adder(100.0F)).addProperty(AttackPhaseProperty.IMPACT_MODIFIER, ValueModifier.setter(0.0F)).addProperty(AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.setter(0.001F)).addProperty(AttackPhaseProperty.HIT_SOUND, (SoundEvent)EpicFightSounds.BLADE_RUSH_FINISHER.get()).addProperty(AttackPhaseProperty.SOURCE_TAG, Set.of(DamageTypeTags.f_268467_, DamageTypeTags.f_268490_, DamageTypeTags.f_268413_, DamageTypeTags.f_268437_)), (new AttackAnimation.Phase(0.93F, 0.0F, 3.16F, 3.36F, 5.0F, 5.0F, ((HumanoidArmature)Armatures.BIPED.get()).rootJoint, executionCollider)).addProperty(AttackPhaseProperty.MAX_STRIKES_MODIFIER, ValueModifier.adder(100.0F)).addProperty(AttackPhaseProperty.IMPACT_MODIFIER, ValueModifier.setter(0.0F)).addProperty(AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier(2.5F)).addProperty(AttackPhaseProperty.EXTRA_DAMAGE, Set.of(TARGET_MAX_HEALTH.create(new float[]{0.08F}))).addProperty(AttackPhaseProperty.HIT_SOUND, (SoundEvent)EpicFightSounds.EVISCERATE.get()).addProperty(AttackPhaseProperty.SOURCE_TAG, Set.of(DamageTypeTags.f_268467_, DamageTypeTags.f_268490_, DamageTypeTags.f_268413_, DamageTypeTags.f_268437_))})).addProperty(StaticAnimationProperty.PLAY_SPEED_MODIFIER, CONSTANT_EXECUTION).newTimePair(0.0F, 5.0F).addStateRemoveOld(EntityState.CAN_BASIC_ATTACK, false).newTimePair(0.0F, 5.0F).addStateRemoveOld(EntityState.CAN_SKILL_EXECUTION, false);
      });
      EXECUTED_FULL = builder.nextAccessor("biped/skill/execution/executed_full", (accessor) -> {
         return (LongHitAnimation)(new LongHitAnimation(0.01F, accessor, Armatures.BIPED)).addProperty(StaticAnimationProperty.PLAY_SPEED_MODIFIER, CONSTANT_EXECUTED);
      });
   }
}
