package net.shelmarow.nightfall_invade.event;

import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;
import net.shelmarow.nightfall_invade.entity.NFIEntities;
import net.shelmarow.nightfall_invade.entity.spear_knight.ArteriusRenderer;
import yesman.epicfight.api.client.forgeevent.PatchedRenderersEvent;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.client.renderer.patched.entity.PHumanoidRenderer;

@EventBusSubscriber(
   modid = "nightfall_invade",
   bus = Bus.MOD,
   value = {Dist.CLIENT}
)
public class ModEventClient {
   @SubscribeEvent
   public static void rendererRegister(EntityRenderersEvent.RegisterRenderers event) {
      event.registerEntityRenderer((EntityType)NFIEntities.ARTERIUS.get(), ArteriusRenderer::new);
   }

   @SubscribeEvent
   public static void onPatchedRenderer(PatchedRenderersEvent.Add event) {
      event.addPatchedEntityRenderer((EntityType)NFIEntities.ARTERIUS.get(), (entityType) -> {
         return (new PHumanoidRenderer(Meshes.BIPED_OLD_TEX, event.getContext(), entityType)).initLayerLast(event.getContext(), entityType);
      });
   }
}
