package net.shelmarow.nightfall_invade.entity.spear_knight.ai;

import com.github.L_Ender.cataclysm.entity.effect.Flame_Strike_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Flame_Jet_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Flare_Bomb_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Abyss_Fireball_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Fireball_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.hm.efn.gameasset.animations.EFNDodgeAnimations;
import com.hm.efn.gameasset.animations.EFNGreatSwordAnimations;
import com.hm.efn.gameasset.animations.EFNLanceAnimations;
import com.hm.efn.registries.EFNMobEffectRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction.Axis;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.shelmarow.nightfall_invade.ai.NFICombatBehaviors;
import net.shelmarow.nightfall_invade.ai.TimeEvent;
import net.shelmarow.nightfall_invade.ai.NFICombatBehaviors.Behavior;
import net.shelmarow.nightfall_invade.ai.NFICombatBehaviors.BehaviorRoot;
import net.shelmarow.nightfall_invade.ai.NFICombatBehaviors.CounterType;
import net.shelmarow.nightfall_invade.efcondition.HealthCheck.Comparator;
import net.shelmarow.nightfall_invade.entity.spear_knight.Arterius;
import net.shelmarow.nightfall_invade.entity.spear_knight.ArteriusPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class ArteriusAI {
   public static final NFICombatBehaviors.Builder<MobPatch<?>> NORMAL;

   public static void teleportInFrontAlongLine(Entity from, Entity to, double distance, double yOffset) {
      if (from != null && to != null) {
         Vec3 fromPos = from.m_20182_();
         Vec3 toPos = to.m_20182_();
         Vec3 dir = toPos.m_82546_(fromPos);
         if (dir.m_82556_() < 1.0E-6) {
            dir = to.m_20182_();
         } else {
            dir = dir.m_82541_();
         }

         Vec3 dest = toPos.m_82546_(dir.m_82490_(distance));
         dest = new Vec3(dest.f_82479_, dest.f_82480_ + yOffset, dest.f_82481_);
         from.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
      }
   }

   public static void spawnEightDirectionJets(Level level, double x, double y, double z, float baseRot, int rune, double time, float damage, @Nullable LivingEntity owner) {
      for(int i = 0; i < 8; ++i) {
         float throwAngle = baseRot + 22.5F + (float)i * 45.0F;
         spawnJetsLine(level, x, y, z, throwAngle, rune, time, damage, owner);
      }

   }

   public static void spawnJetsLine(Level level, double x, double y, double z, float baseRot, int rune, double time, float damage, @Nullable LivingEntity owner) {
      baseRot = (float)Math.toRadians((double)baseRot);

      for(int k = 0; k < rune; ++k) {
         double d2 = 0.8 * (double)(k + 1);
         int d3 = (int)(time * (double)(k + 1));
         spawnJet(level, x + (double)(Mth.m_14089_(baseRot) * 1.25F) * d2, z + (double)(Mth.m_14031_(baseRot) * 1.25F) * d2, y - 2.0, y + 2.0, baseRot, d3, damage, owner);
      }

   }

   public static void spawnJetsLine(Level level, double x, double y, double z, float baseRot, int rune, int baseDelay, double time, float damage, @Nullable LivingEntity owner) {
      baseRot = (float)Math.toRadians((double)baseRot);

      for(int k = 0; k < rune; ++k) {
         double d2 = 0.8 * (double)(k + 1);
         int d3 = (int)(time * (double)(k + 1));
         spawnJet(level, x + (double)(Mth.m_14089_(baseRot) * 1.25F) * d2, z + (double)(Mth.m_14031_(baseRot) * 1.25F) * d2, y - 2.0, y + 2.0, baseRot, baseDelay, d3, damage, owner);
      }

   }

   private static void spawnJet(Level level, double x, double z, double minY, double maxY, float rotation, int baseDelay, int delay, float damage, @Nullable LivingEntity owner) {
      BlockPos pos = BlockPos.m_274561_(x, maxY, z);
      boolean found = false;
      double offsetY = 0.0;

      do {
         BlockPos below = pos.m_7495_();
         BlockState state = level.m_8055_(below);
         if (state.m_60783_(level, below, Direction.UP)) {
            if (!level.m_46859_(pos)) {
               BlockState topState = level.m_8055_(pos);
               VoxelShape shape = topState.m_60812_(level, pos);
               if (!shape.m_83281_()) {
                  offsetY = shape.m_83297_(Axis.Y);
               }
            }

            found = true;
            break;
         }

         pos = pos.m_7495_();
      } while(pos.m_123342_() >= Mth.m_14107_(minY) - 1);

      if (found) {
         Flame_Jet_Entity jet = new Flame_Jet_Entity(level, x, (double)pos.m_123342_() + offsetY, z, rotation, baseDelay + delay, damage, owner);
         level.m_7967_(jet);
      }

   }

   private static void spawnJet(Level level, double x, double z, double minY, double maxY, float rotation, int delay, float damage, @Nullable LivingEntity owner) {
      BlockPos pos = BlockPos.m_274561_(x, maxY, z);
      boolean found = false;
      double offsetY = 0.0;

      do {
         BlockPos below = pos.m_7495_();
         BlockState state = level.m_8055_(below);
         if (state.m_60783_(level, below, Direction.UP)) {
            if (!level.m_46859_(pos)) {
               BlockState topState = level.m_8055_(pos);
               VoxelShape shape = topState.m_60812_(level, pos);
               if (!shape.m_83281_()) {
                  offsetY = shape.m_83297_(Axis.Y);
               }
            }

            found = true;
            break;
         }

         pos = pos.m_7495_();
      } while(pos.m_123342_() >= Mth.m_14107_(minY) - 1);

      if (found) {
         Flame_Jet_Entity jet = new Flame_Jet_Entity(level, x, (double)pos.m_123342_() + offsetY, z, rotation, delay, damage, owner);
         level.m_7967_(jet);
      }

   }

   public static Flare_Bomb_Entity spawnFlareBomb(Level world, double x, double y, double z, float rotation, @Nullable LivingEntity thrower) {
      if (world == null) {
         return null;
      } else {
         Flare_Bomb_Entity bomb = null;
         if (thrower != null) {
            bomb = new Flare_Bomb_Entity((EntityType)ModEntities.FLARE_BOMB.get(), world, thrower);
            bomb.m_146922_(rotation);
         }

         if (bomb != null) {
            bomb.m_6034_(x, y, z);
            world.m_7967_(bomb);
         }

         return bomb;
      }
   }

   public static void spawnFlameStrikeRing(Level level, double x, double y, double z, float radius, int count, int delay, float size, float damage, @Nullable LivingEntity entity) {
      for(int i = 0; i < count; ++i) {
         double angle = 6.283185307179586 * (double)i / (double)count;
         double offsetX = Math.cos(angle) * (double)radius;
         double offsetZ = Math.sin(angle) * (double)radius;
         double dx = x + offsetX;
         double dz = z + offsetZ;
         double minY = y - 2.0;
         double maxY = y + 2.0;
         spawnFlameStrike(level, dx, dz, minY, maxY, 0.0F, 40, delay, delay, size, damage, false, entity);
      }

   }

   public static void spawnFlameStrikeRing(Level level, double x, double y, double z, float radius, int count, int duration, int delay, float size, float damage, @Nullable LivingEntity entity) {
      for(int i = 0; i < count; ++i) {
         double angle = 6.283185307179586 * (double)i / (double)count;
         double offsetX = Math.cos(angle) * (double)radius;
         double offsetZ = Math.sin(angle) * (double)radius;
         double dx = x + offsetX;
         double dz = z + offsetZ;
         double minY = y - 2.0;
         double maxY = y + 2.0;
         spawnFlameStrike(level, dx, dz, minY, maxY, 0.0F, duration, delay, delay, size, damage, false, entity);
      }

   }

   public static void spawnSixDirectionFlameStrike(Level level, double x, double y, double z, float baseRot, int rune, float size, float damage, @Nullable LivingEntity entity) {
      for(int i = 0; i < 6; ++i) {
         float yawRadians = (float)Math.toRadians((double)(baseRot + (float)i * 60.0F));

         for(int k = 0; k < rune; ++k) {
            double d2 = 2.25 * (double)(k + 1);
            int delay = (int)(1.5 * (double)k);
            double minY = y - 2.0;
            double maxY = y + 2.0;
            spawnFlameStrike(level, x + (double)Mth.m_14089_(yawRadians) * d2, z + (double)Mth.m_14031_(yawRadians) * d2, minY, maxY, yawRadians, 40, delay, delay, size, damage, false, entity);
         }
      }

   }

   public static void spawnEightDirectionFlameStrike(Level level, double x, double y, double z, float baseRot, int rune, float size, float damage, @Nullable LivingEntity entity) {
      for(int i = 0; i < 8; ++i) {
         float yawRadians = (float)Math.toRadians((double)(baseRot + (float)i * 45.0F));

         for(int k = 0; k < rune; ++k) {
            double d2 = 2.25 * (double)(k + 1);
            int delay = (int)(1.5 * (double)k);
            double minY = y - 2.0;
            double maxY = y + 2.0;
            spawnFlameStrike(level, x + (double)Mth.m_14089_(yawRadians) * d2, z + (double)Mth.m_14031_(yawRadians) * d2, minY, maxY, yawRadians, 40, delay, delay, size, damage, false, entity);
         }
      }

   }

   private static void spawnFlameStrike(Level world, double x, double z, double minY, double maxY, float rotation, int duration, int wait, int delay, float radius, float damage, boolean soul, @Nullable LivingEntity player) {
      BlockPos blockpos = BlockPos.m_274561_(x, maxY, z);
      boolean flag = false;
      double d0 = 0.0;

      do {
         BlockPos blockpos1 = blockpos.m_7495_();
         BlockState blockstate = world.m_8055_(blockpos1);
         if (blockstate.m_60783_(world, blockpos1, Direction.UP)) {
            if (!world.m_46859_(blockpos)) {
               BlockState blockstate1 = world.m_8055_(blockpos);
               VoxelShape voxelshape = blockstate1.m_60812_(world, blockpos);
               if (!voxelshape.m_83281_()) {
                  d0 = voxelshape.m_83297_(Axis.Y);
               }
            }

            flag = true;
            break;
         }

         blockpos = blockpos.m_7495_();
      } while((double)blockpos.m_123342_() >= minY);

      if (flag) {
         world.m_7967_(new Flame_Strike_Entity(world, x, (double)blockpos.m_123342_() + d0, z, rotation, duration, wait, delay, radius, damage, 2.0F, soul, player));
      }

   }

   private static void shootFireball(LivingEntity entity, Vec3 shotAt, int timer) {
      shotAt = shotAt.m_82524_(-entity.m_146908_() * 0.017453292F);
      Ignis_Fireball_Entity shot = new Ignis_Fireball_Entity(entity.m_9236_(), entity);
      shot.m_6034_(entity.m_20185_() - (double)(entity.m_20205_() + 1.0F) * 0.15 * (double)Mth.m_14031_(entity.f_20883_ * 0.017453292F), entity.m_20186_() + 1.0, entity.m_20189_() + (double)(entity.m_20205_() + 1.0F) * 0.15 * (double)Mth.m_14089_(entity.f_20883_ * 0.017453292F));
      double d0 = shotAt.f_82479_;
      double d1 = shotAt.f_82480_;
      double d2 = shotAt.f_82481_;
      float f = Mth.m_14116_((float)(d0 * d0 + d2 * d2)) * 0.35F;
      shot.m_6686_(d0, d1 + (double)f, d2, 0.25F, 3.0F);
      shot.setUp(timer + 1);
      entity.m_9236_().m_7967_(shot);
   }

   private static void shootAbyssFireball(LivingEntity entity, Vec3 shotAt, int timer) {
      shotAt = shotAt.m_82524_(-entity.m_146908_() * 0.017453292F);
      Ignis_Abyss_Fireball_Entity shot = new Ignis_Abyss_Fireball_Entity(entity.m_9236_(), entity);
      shot.m_6034_(entity.m_20185_() - (double)(entity.m_20205_() + 1.0F) * 0.15 * (double)Mth.m_14031_(entity.f_20883_ * 0.017453292F), entity.m_20186_() + 1.0, entity.m_20189_() + (double)(entity.m_20205_() + 1.0F) * 0.15 * (double)Mth.m_14089_(entity.f_20883_ * 0.017453292F));
      double d0 = shotAt.f_82479_;
      double d1 = shotAt.f_82480_;
      double d2 = shotAt.f_82481_;
      float f = Mth.m_14116_((float)(d0 * d0 + d2 * d2)) * 0.35F;
      shot.m_6686_(d0, d1 + (double)f, d2, 0.25F, 3.0F);
      shot.setUp(timer + 1);
      entity.m_9236_().m_7967_(shot);
   }

   public static void summonFireBall(LivingEntityPatch<?> entityPatch, int type) {
      if (!entityPatch.isLogicalClient()) {
         LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
         entityPatch.playSound((SoundEvent)ModSounds.ABYSS_BLAST_ONLY_CHARGE.get(), 0.0F, 0.0F);
         entityPatch.playSound(SoundEvents.f_11868_, 0.0F, 0.0F);
         switch (type) {
            case 0:
               shootAbyssFireball(entity, new Vec3(-5.0, 3.0, 0.0), 60);
               shootFireball(entity, new Vec3(-2.0, 3.0, 0.0), 50);
               shootFireball(entity, new Vec3(0.0, 3.0, 0.0), 40);
               shootFireball(entity, new Vec3(2.0, 3.0, 0.0), 30);
               shootFireball(entity, new Vec3(5.0, 3.0, 0.0), 20);
               break;
            case 1:
               shootFireball(entity, new Vec3(-5.0, 3.0, 0.0), 60);
               shootAbyssFireball(entity, new Vec3(-2.0, 3.0, 0.0), 50);
               shootFireball(entity, new Vec3(0.0, 3.0, 0.0), 40);
               shootFireball(entity, new Vec3(2.0, 3.0, 0.0), 30);
               shootFireball(entity, new Vec3(5.0, 3.0, 0.0), 20);
               break;
            case 2:
               shootFireball(entity, new Vec3(-5.0, 3.0, 0.0), 60);
               shootFireball(entity, new Vec3(-2.0, 3.0, 0.0), 50);
               shootAbyssFireball(entity, new Vec3(0.0, 3.0, 0.0), 40);
               shootFireball(entity, new Vec3(2.0, 3.0, 0.0), 30);
               shootFireball(entity, new Vec3(5.0, 3.0, 0.0), 20);
               break;
            case 3:
               shootFireball(entity, new Vec3(-5.0, 3.0, 0.0), 60);
               shootFireball(entity, new Vec3(-2.0, 3.0, 0.0), 50);
               shootFireball(entity, new Vec3(0.0, 3.0, 0.0), 40);
               shootAbyssFireball(entity, new Vec3(2.0, 3.0, 0.0), 30);
               shootFireball(entity, new Vec3(5.0, 3.0, 0.0), 20);
               break;
            case 4:
               shootFireball(entity, new Vec3(-5.0, 3.0, 0.0), 60);
               shootFireball(entity, new Vec3(-2.0, 3.0, 0.0), 50);
               shootFireball(entity, new Vec3(0.0, 3.0, 0.0), 40);
               shootFireball(entity, new Vec3(2.0, 3.0, 0.0), 30);
               shootAbyssFireball(entity, new Vec3(5.0, 3.0, 0.0), 20);
               break;
            case 5:
               shootAbyssFireball(entity, new Vec3(-5.0, 3.0, 0.0), 60);
               shootFireball(entity, new Vec3(-2.0, 3.0, 0.0), 20);
               shootAbyssFireball(entity, new Vec3(0.0, 3.0, 0.0), 60);
               shootFireball(entity, new Vec3(2.0, 3.0, 0.0), 20);
               shootAbyssFireball(entity, new Vec3(5.0, 3.0, 0.0), 60);
               break;
            case 6:
               shootFireball(entity, new Vec3(-5.0, 3.0, 0.0), 40);
               shootAbyssFireball(entity, new Vec3(-2.0, 3.0, 0.0), 60);
               shootFireball(entity, new Vec3(0.0, 3.0, 0.0), 20);
               shootAbyssFireball(entity, new Vec3(2.0, 3.0, 0.0), 60);
               shootFireball(entity, new Vec3(5.0, 3.0, 0.0), 40);
               break;
            case 7:
               shootFireball(entity, new Vec3(-5.0, 3.0, 0.0), 40);
               shootFireball(entity, new Vec3(0.0, 3.0, 0.0), 20);
               shootFireball(entity, new Vec3(5.0, 3.0, 0.0), 60);
               break;
            default:
               shootFireball(entity, new Vec3(-5.0, 3.0, 0.0), 60);
               shootFireball(entity, new Vec3(-2.0, 3.0, 0.0), 50);
               shootFireball(entity, new Vec3(0.0, 3.0, 0.0), 40);
               shootFireball(entity, new Vec3(2.0, 3.0, 0.0), 30);
               shootFireball(entity, new Vec3(5.0, 3.0, 0.0), 20);
         }

      }
   }

   static {
      NORMAL = NFICombatBehaviors.builder().newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(60).cooldown(100).addFirstBehavior(Behavior.builder().withinDistance(0.0, 4.0).health(0.5F, Comparator.GREATER_RATIO).animationBehavior(EFNDodgeAnimations.DODGE_STEP_B, 0.0F)).addFirstBehavior(Behavior.builder().withinDistance(0.0, 4.0).health(0.5F, Comparator.GREATER_RATIO).animationBehavior(EFNDodgeAnimations.DODGE_STEP_L, 0.0F)).addFirstBehavior(Behavior.builder().withinDistance(0.0, 4.0).health(0.5F, Comparator.GREATER_RATIO).animationBehavior(EFNDodgeAnimations.DODGE_STEP_R, 0.0F))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(5.0).maxCooldown(60).cooldown(200).addFirstBehavior(Behavior.builder().withinDistance(0.0, 4.0).attackLevel(1, 2).health(0.5F, Comparator.GREATER_RATIO).animationBehavior(EFNDodgeAnimations.DODGE_STEP_B, 0.0F)).addFirstBehavior(Behavior.builder().withinDistance(0.0, 4.0).attackLevel(1, 2).health(0.5F, Comparator.GREATER_RATIO).animationBehavior(EFNDodgeAnimations.DODGE_STEP_L, 0.0F)).addFirstBehavior(Behavior.builder().withinDistance(0.0, 4.0).attackLevel(1, 2).health(0.5F, Comparator.GREATER_RATIO).animationBehavior(EFNDodgeAnimations.DODGE_STEP_R, 0.0F))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(300).cooldown(300).addFirstBehavior(Behavior.builder().withinDistance(0.0, 2.5).attackLevel(0, 0).health(0.75F, Comparator.GREATER_RATIO).guard(100).maxGuardHit(3).counterAnimation(EFNLanceAnimations.NF_MEEN_AUTO3, 0.25F, StunType.SHORT).counterType(CounterType.END).onCounterStart((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
      }))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(5.0).maxCooldown(300).cooldown(200).addFirstBehavior(Behavior.builder().withinDistance(0.0, 4.0).attackLevel(1, 2).health(0.75F, Comparator.GREATER_RATIO).guard(60).maxGuardHit(3).counterAnimation(EFNLanceAnimations.NF_MEEN_AUTO3, 0.25F, StunType.SHORT).counterType(CounterType.END).onCounterStart((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
      }))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(15.0).maxCooldown(60).addFirstBehavior(Behavior.builder().withinDistance(0.0, 5.0).attackLevel(1, 3).health(0.5F, Comparator.LESS_RATIO_CONTAIN).animationBehavior(EFNDodgeAnimations.DODGE_STEP_B, 0.0F).addNextBehavior(Behavior.builder().withinDistance(0.0, 5.0).attackLevel(1, 3).animationBehavior(EFNDodgeAnimations.DODGE_STEP_B, 0.0F)).addNextBehavior(Behavior.builder().withinDistance(0.0, 5.0).attackLevel(1, 3).randomChance(0.65F).addCooldown(140).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE2, 0.45F, 1.0F, 0.65F, 1.0F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         summonFireBall(mobPatch, 7);
      }))).addFirstBehavior(Behavior.builder().withinDistance(0.0, 5.0).attackLevel(1, 3).health(0.5F, Comparator.LESS_RATIO_CONTAIN).animationBehavior(EFNDodgeAnimations.DODGE_STEP_L, 0.0F).addNextBehavior(Behavior.builder().withinDistance(0.0, 5.0).attackLevel(1, 3).animationBehavior(EFNDodgeAnimations.DODGE_STEP_R, 0.0F)).addNextBehavior(Behavior.builder().withinDistance(0.0, 5.0).attackLevel(1, 3).randomChance(0.65F).addCooldown(140).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE2, 0.45F, 1.0F, 0.65F, 1.0F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         summonFireBall(mobPatch, 7);
      }))).addFirstBehavior(Behavior.builder().withinDistance(0.0, 5.0).attackLevel(1, 3).health(0.5F, Comparator.LESS_RATIO_CONTAIN).animationBehavior(EFNDodgeAnimations.DODGE_STEP_R, 0.0F).addNextBehavior(Behavior.builder().withinDistance(0.0, 5.0).attackLevel(1, 3).animationBehavior(EFNDodgeAnimations.DODGE_STEP_L, 0.0F)).addNextBehavior(Behavior.builder().withinDistance(0.0, 5.0).attackLevel(1, 3).randomChance(0.65F).addCooldown(140).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE2, 0.45F, 1.0F, 0.65F, 1.0F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         summonFireBall(mobPatch, 7);
      })))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(15.0).maxCooldown(300).addFirstBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 5.0).attackLevel(1, 2).health(0.75F, Comparator.LESS_RATIO_CONTAIN).health(0.25F, Comparator.GREATER_RATIO).guard(80).counterType(CounterType.RANDOM).counterChance(0.75).counterAnimation(EFNLanceAnimations.NF_MEEN_CHARGE1, 0.35F).onCounterStart((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float rot = caster.m_146908_() + 90.0F;
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 1.5F;
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 35.0F, 12, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 15.0F, 12, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 15.0F, 12, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 35.0F, 12, 30, 1.0, damage, caster);
      })).addFirstBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 5.0).attackLevel(1, 2).health(0.75F, Comparator.LESS_RATIO_CONTAIN).health(0.25F, Comparator.GREATER_RATIO).guard(80).counterType(CounterType.RANDOM).counterChance(0.75).counterAnimation(EFNLanceAnimations.NF_MEEN_CHARGE1, 0.35F).onCounterStart((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float rot = caster.m_146908_() + 90.0F;
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 1.5F;
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 35.0F, 12, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 0.0F, 12, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 35.0F, 12, 30, 1.0, damage, caster);
      })).addFirstBehavior(Behavior.builder().priority(1.0).weight(0.5).withinDistance(0.0, 5.0).attackLevel(1, 2).health(0.75F, Comparator.LESS_RATIO_CONTAIN).health(0.25F, Comparator.GREATER_RATIO).guard(80).counterType(CounterType.RANDOM).counterChance(0.75).counterAnimation(EFNLanceAnimations.NF_MEEN_AUTO3, 0.4F, StunType.SHORT).onCounterStart((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
      }))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(100).addFirstBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(6.0, 12.0).withinAngle(0.0, 60.0).animationBehavior(EFNDodgeAnimations.DODGE_ROLL_F, 0.0F))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(10).addFirstBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 4.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO1, 0.0F, StunType.SHORT).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 8.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO2, 0.0F).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).health(0.5F, Comparator.LESS_RATIO_CONTAIN).withinDistance(5.0, 12.0).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE2, 0.45F, 1.0F, 0.65F, 1.0F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         summonFireBall(mobPatch, 7);
      })).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(5.0, 12.0).interruptedByLevel(new Integer[]{3}).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_FIRST, 0.25F, 1.0F, 0.6F, 1.0F).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).attackLevel(1, 2).canInterruptParent(true).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_SECOND, 0.4F)).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).randomChance(0.5F).canInterruptParent(true).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_SECOND, 0.4F)).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).randomChance(0.65F).health(0.5F, Comparator.LESS_RATIO_CONTAIN).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE1, 0.45F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
      }).addTimeEvent(new TimeEvent(1.0F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float rot = caster.m_146908_() + 90.0F;
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 1.5F;
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 35.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 15.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 0.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 15.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 35.0F, 12, 1.0, damage, caster);
      })))).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 5.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO3, 0.15F, 1.25F, 1.3F, 1.6F, StunType.SHORT).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 6.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO4, 0.25F, 1.35F, 1.3F, 1.6F)))).addNextBehavior(Behavior.builder().priority(1.0).weight(0.5).health(0.75F, Comparator.LESS_RATIO_CONTAIN).withinDistance(0.0, 4.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE1, 0.35F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
      }).addTimeEvent(new TimeEvent(1.0F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float rot = caster.m_146908_() + 90.0F;
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 1.5F;
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 30.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 0.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 30.0F, 12, 1.0, damage, caster);
      }))))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(10).addFirstBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 4.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO1, 0.0F, StunType.SHORT).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 4.0).animationBehavior(EFNDodgeAnimations.DODGE_ROLL_B, 0.0F).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, 0.0F).addNextBehavior(Behavior.builder().wander(12, 0.0F, 0.0F).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).health(0.65F, Comparator.LESS_RATIO_CONTAIN).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE1, 0.25F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 60), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
      }).addTimeEvent(new TimeEvent(1.0F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float rot = caster.m_146908_() + 90.0F;
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 1.5F;
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 35.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 15.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 0.0F, 30, 2.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 15.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 35.0F, 12, 1.0, damage, caster);
      })))))).addNextBehavior(Behavior.builder().priority(1.0).weight(1.5).withinDistance(0.0, 8.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO2, 0.0F).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 6.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO3, 0.0F, StunType.SHORT).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 4.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO4, 0.0F)).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).health(0.75F, Comparator.LESS_RATIO_CONTAIN).withinDistance(0.0, 5.0).withinAngle(0.0, 120.0).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE1, 0.35F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 60), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
      }).addTimeEvent(new TimeEvent(1.0F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float rot = caster.m_146908_() + 90.0F;
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 1.5F;
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 35.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 15.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 0.0F, 30, 2.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 15.0F, 12, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 35.0F, 12, 1.0, damage, caster);
      })))).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(0.0, 6.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AIRSLASH, 0.0F).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO4, 0.25F))).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).withinDistance(5.0, 12.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, 0.25F).addNextBehavior(Behavior.builder().wander(8, 0.0F, 0.0F).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO4, 0.25F))))))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(400).addFirstBehavior(Behavior.builder().health(0.75F, Comparator.LESS_RATIO).withinDistance(6.0, 12.0).withinAngle(0.0, 60.0).interruptedByTime(2.1F, 2.2F).animationBehavior(EFNLanceAnimations.NF_MEEN_FINISHER, 0.25F).addTimeEvent(new TimeEvent[]{new TimeEvent(0.0F, 0.2F, (mobPatch) -> {
         if (mobPatch.getTarget() != null) {
            mobPatch.rotateTo(mobPatch.getTarget(), 360.0F, false);
         }

      }), new TimeEvent(0.5F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float rot = caster.m_146908_() + 90.0F;
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 2.0F;
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 30.0F, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 0.0F, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 30.0F, 30, 1.0, damage, caster);
      }), new TimeEvent(0.85F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float rot = caster.m_146908_() + 90.0F;
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 2.0F;
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 35.0F, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot - 15.0F, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 15.0F, 30, 1.0, damage, caster);
         spawnJetsLine(world, spawnX, spawnY, spawnZ, rot + 35.0F, 30, 1.0, damage, caster);
      })}).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).canInterruptParent(true).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_SECOND, 0.5F).addTimeEvent(new TimeEvent(0.25F, (mobPatch) -> {
         if (mobPatch.getTarget() != null) {
            teleportInFrontAlongLine(mobPatch.getOriginal(), mobPatch.getTarget(), 1.0, 0.0);
         }

      }))).addNextBehavior(Behavior.builder().priority(1.0).weight(0.5).addCooldown(100).health(0.5F, Comparator.LESS_RATIO).canInterruptParent(true).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_SECOND, 0.5F).addTimeEvent(new TimeEvent[]{new TimeEvent(0.05F, (mobPatch) -> {
         int random = ((Mob)mobPatch.getOriginal()).m_217043_().m_188503_(5);
         summonFireBall(mobPatch, random);
      }), new TimeEvent(0.25F, (mobPatch) -> {
         if (mobPatch.getTarget() != null) {
            teleportInFrontAlongLine(mobPatch.getOriginal(), mobPatch.getTarget(), 1.0, 0.0);
         }

      })})).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).addCooldown(100).health(0.25F, Comparator.LESS_RATIO).canInterruptParent(true).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_SECOND, 0.5F).addTimeEvent(new TimeEvent[]{new TimeEvent(0.25F, (mobPatch) -> {
         if (mobPatch.getTarget() != null) {
            teleportInFrontAlongLine(mobPatch.getOriginal(), mobPatch.getTarget(), 1.0, 0.0);
         }

      }), new TimeEvent(1.4F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 2.35F;
         spawnFlameStrikeRing(world, spawnX, spawnY, spawnZ, 7.0F, 12, 20, 0, 1.15F, damage, caster);
      })})))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(800).rootName("ArteriusDashing").addFirstBehavior(Behavior.builder().priority(1.0).weight(1.0).health(0.9F, Comparator.LESS_RATIO_CONTAIN).health(0.4F, Comparator.GREATER_RATIO).withinDistance(4.5, 8.0).withinAngle(0.0, 60.0).randomChance(0.35F).animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, 0.5F, 1.0F, 0.5F, 0.25F, StunType.LONG).addExBehavior((mobPatch) -> {
         if (mobPatch instanceof ArteriusPatch arteriusPatch) {
            arteriusPatch.setBlockTime(arteriusPatch.getMaxBlockTime());
         }

         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 40), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
      }).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, -0.45F, 1.0F, 0.65F, 0.5F, StunType.LONG).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 40), mobPatch.getOriginal());
      }).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, -0.45F, 1.0F, 0.65F, 0.5F, StunType.LONG).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 40), mobPatch.getOriginal());
      }).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, -0.45F, 1.0F, 0.65F, 0.5F, StunType.LONG).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 40), mobPatch.getOriginal());
      }).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, -0.45F, 1.0F, 0.65F, 0.5F, StunType.LONG).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 40), mobPatch.getOriginal());
      }).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, -0.45F, 1.0F, 0.65F, 0.5F, StunType.LONG).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 40), mobPatch.getOriginal());
      }).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, -0.45F, 1.0F, 1.3F, 2.5F, StunType.LONG).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 40), mobPatch.getOriginal());
      }))))))))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(10).addFirstBehavior(Behavior.builder().health(0.8F, Comparator.LESS_RATIO_CONTAIN).withinDistance(0.0, 4.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO3, 0.35F, StunType.SHORT).addNextBehavior(Behavior.builder().withinDistance(0.0, 6.0).withinAngle(0.0, 120.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO4, 0.25F).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).health(0.5F, Comparator.LESS_RATIO_CONTAIN).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE2, 0.45F, 1.0F, 0.65F, 1.0F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         summonFireBall(mobPatch, 7);
      })).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).animationBehavior(Animations.GRASPING_SPIRAL_FIRST, 0.35F))))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(10).addFirstBehavior(Behavior.builder().health(0.7F, Comparator.LESS_RATIO_CONTAIN).withinDistance(0.0, 4.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AIRSLASH, 0.25F).addNextBehavior(Behavior.builder().withinDistance(0.0, 8.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, 0.25F).addNextBehavior(Behavior.builder().wander(8, 0.0F, 0.0F).addNextBehavior(Behavior.builder().animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO3, 0.25F, StunType.SHORT)).addNextBehavior(Behavior.builder().priority(1.0).weight(1.5).health(0.5F, Comparator.LESS_RATIO_CONTAIN).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE2, 0.45F, 1.0F, 0.65F, 1.0F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         summonFireBall(mobPatch, 7);
      })))))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(10).addFirstBehavior(Behavior.builder().health(0.7F, Comparator.LESS_RATIO_CONTAIN).withinDistance(0.0, 4.0).withinAngle(0.0, 60.0).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_AUTO1, 0.25F).addNextBehavior(Behavior.builder().withinDistance(0.0, 8.0).withinAngle(0.0, 120.0).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_AUTO2, 0.1F).addNextBehavior(Behavior.builder().withinDistance(0.0, 8.0).withinAngle(0.0, 120.0).animationBehavior(EFNLanceAnimations.NF_MEEN_AUTO3, 0.15F, StunType.SHORT).addNextBehavior(Behavior.builder().withinDistance(0.0, 8.0).withinAngle(0.0, 120.0).animationBehavior(EFNLanceAnimations.NF_MEEN_DASH, 0.25F)))))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(1.0).maxCooldown(400).addFirstBehavior(Behavior.builder().priority(1.0).weight(1.0).health(0.65F, Comparator.LESS_RATIO_CONTAIN).withinDistance(6.0, 12.0).withinAngle(0.0, 60.0).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_FIRST, 0.4F, 1.0F, 0.6F, 1.0F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
      }).addNextBehavior(Behavior.builder().priority(1.0).weight(1.0).health(0.25F, Comparator.GREATER_RATIO).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_SECOND, 0.25F)).addNextBehavior(Behavior.builder().priority(2.0).weight(1.0).health(0.25F, Comparator.LESS_RATIO_CONTAIN).animationBehavior(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_SECOND, 0.25F).addTimeEvent(new TimeEvent(1.4F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 2.5F;
         spawnFlameStrikeRing(world, spawnX, spawnY, spawnZ, 8.0F, 14, 20, 0, 1.25F, damage, caster);
      }))))).newBehaviorRoot(BehaviorRoot.builder().priority(7.0).weight(1000.0).addFirstBehavior(Behavior.builder().health(0.75F, Comparator.LESS_RATIO_CONTAIN).custom((mobPatch) -> {
         return ((Arterius)mobPatch.getOriginal()).getSkillReleased() == 0;
      }).interruptedByTime(1.85F, 1.95F).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGING_MOB, 0.15F).addExBehavior((mobPatch) -> {
         ((Arterius)mobPatch.getOriginal()).setSkillReleased(1);
         ((Arterius)mobPatch.getOriginal()).setPhaseChangeTimer(20);
         mobPatch.playSound(SoundEvents.f_11874_, 0.0F, 0.0F);
         if (!mobPatch.isLogicalClient()) {
            ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
            ServerLevel serverLevel = (ServerLevel)((Mob)mobPatch.getOriginal()).m_9236_();
            Vec3 pos = ((Mob)mobPatch.getOriginal()).m_20182_();
            serverLevel.m_8767_(ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 200, 0.0, 1.0, 0.0, 0.5);
         }

      }).addTimeEvent(new TimeEvent(0.0F, 1.0F, (mobPatch) -> {
         if (mobPatch.getTarget() != null) {
            mobPatch.rotateTo(mobPatch.getTarget(), 360.0F, false);
         }

      })).addNextBehavior(Behavior.builder().canInterruptParent(true).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE1, 0.1F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
      }).addTimeEvent(new TimeEvent(1.0F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 3.0F;
         spawnEightDirectionJets(world, spawnX, spawnY, spawnZ, caster.m_146908_(), 30, 2.0, damage, caster);
         spawnEightDirectionJets(world, spawnX, spawnY, spawnZ, caster.m_146908_() + 22.5F, 30, 1.0, damage, caster);
      }))))).newBehaviorRoot(BehaviorRoot.builder().priority(6.0).weight(1000.0).addFirstBehavior(Behavior.builder().health(0.5F, Comparator.LESS_RATIO_CONTAIN).custom((mobPatch) -> {
         return ((Arterius)mobPatch.getOriginal()).getSkillReleased() == 1;
      }).interruptedByTime(3.0F, 3.1F).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGING_MOB, 0.15F).addExBehavior((mobPatch) -> {
         ((Arterius)mobPatch.getOriginal()).setSkillReleased(2);
         ((Arterius)mobPatch.getOriginal()).setPhaseChangeTimer(20);
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 70), mobPatch.getOriginal());
         mobPatch.playSound(SoundEvents.f_11874_, 0.0F, 0.0F);
         if (!mobPatch.isLogicalClient()) {
            ServerLevel serverLevel = (ServerLevel)((Mob)mobPatch.getOriginal()).m_9236_();
            Vec3 pos = ((Mob)mobPatch.getOriginal()).m_20182_();
            serverLevel.m_8767_(ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 200, 0.0, 1.0, 0.0, 0.5);
         }

      }).addTimeEvent(new TimeEvent(0.0F, 1.0F, (mobPatch) -> {
         if (mobPatch.getTarget() != null) {
            mobPatch.rotateTo(mobPatch.getTarget(), 360.0F, false);
         }

      })).addNextBehavior(Behavior.builder().canInterruptParent(true).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGE2, 0.45F, 1.0F, 0.65F, 1.0F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         int random = ((Mob)mobPatch.getOriginal()).m_217043_().m_188503_(5);
         summonFireBall(mobPatch, random);
      })))).newBehaviorRoot(BehaviorRoot.builder().priority(5.0).weight(1000.0).addFirstBehavior(Behavior.builder().health(0.25F, Comparator.LESS_RATIO_CONTAIN).custom((mobPatch) -> {
         return ((Arterius)mobPatch.getOriginal()).getSkillReleased() == 2;
      }).animationBehavior(EFNLanceAnimations.NF_MEEN_CHARGING_MOB, 0.15F).addExBehavior((mobPatch) -> {
         ((Arterius)mobPatch.getOriginal()).setSkillReleased(3);
         ((Arterius)mobPatch.getOriginal()).setPhaseChangeTimer(20);
         ((Mob)mobPatch.getOriginal()).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 90), mobPatch.getOriginal());
         mobPatch.playSound(SoundEvents.f_11874_, 0.0F, 0.0F);
         if (!mobPatch.isLogicalClient()) {
            ServerLevel serverLevel = (ServerLevel)((Mob)mobPatch.getOriginal()).m_9236_();
            Vec3 pos = ((Mob)mobPatch.getOriginal()).m_20182_();
            serverLevel.m_8767_(ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 200, 0.0, 1.0, 0.0, 0.5);
         }

      }).addTimeEvent(new TimeEvent[]{new TimeEvent(0.0F, 1.0F, (mobPatch) -> {
         if (mobPatch.getTarget() != null) {
            mobPatch.rotateTo(mobPatch.getTarget(), 360.0F, false);
         }

      }), new TimeEvent(4.25F, (mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         summonFireBall(mobPatch, 6);
      }), new TimeEvent(4.5F, (mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.MEEN_LANCE.get(), Integer.MAX_VALUE, 1));
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 3.0F;
         spawnSixDirectionFlameStrike(world, spawnX, spawnY, spawnZ, caster.m_146908_() + 22.5F, 20, 1.25F, damage, caster);
      }), new TimeEvent(4.75F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 3.2F;
         spawnFlameStrikeRing(world, spawnX, spawnY, spawnZ, 8.0F, 12, 4, 1.2F, damage, caster);
      }), new TimeEvent(5.0F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 3.2F;
         spawnFlameStrikeRing(world, spawnX, spawnY, spawnZ, 20.0F, 24, 12, 1.2F, damage, caster);
      })}))).newBehaviorRoot(BehaviorRoot.builder().priority(1.0).weight(10.0).maxCooldown(600).addFirstBehavior(Behavior.builder().health(0.25F, Comparator.LESS_RATIO_CONTAIN).withinDistance(0.0, 5.0).withinAngle(0.0, 60.0).animationBehavior(EFNLanceAnimations.NF_MEEN_FINISHER, 0.8F).addExBehavior((mobPatch) -> {
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.BYPASS_DODGE_EFFECT.get(), 100));
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.GUARD_PUNCTURE_EFFECT.get(), 100));
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 100));
         ((Mob)mobPatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
         mobPatch.playSound(SoundEvents.f_11668_, 0.0F, 0.0F);
         summonFireBall(mobPatch, 5);
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 10.0F;
         spawnFlameStrike(world, spawnX, spawnZ, spawnY - 2.0, spawnY + 2.0, caster.m_146908_(), 40, 40, 0, 3.0F, damage, true, caster);
      }).addTimeEvent(new TimeEvent[]{new TimeEvent((mobPatch) -> {
         if (mobPatch.getTarget() != null) {
            mobPatch.rotateTo(mobPatch.getTarget(), 360.0F, false);
         }

      }), new TimeEvent(1.0F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 3.2F;
         spawnEightDirectionJets(world, spawnX, spawnY, spawnZ, caster.m_146908_(), 15, 2.0, damage, caster);
      }), new TimeEvent(1.25F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 3.2F;
         spawnFlameStrikeRing(world, spawnX, spawnY, spawnZ, 6.0F, 12, 2, 1.0F, damage, caster);
      }), new TimeEvent(1.5F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 3.2F;
         spawnFlameStrikeRing(world, spawnX, spawnY, spawnZ, 14.0F, 22, 6, 1.0F, damage, caster);
      }), new TimeEvent(1.75F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 3.2F;
         spawnEightDirectionJets(world, spawnX, spawnY, spawnZ, caster.m_146908_() + 22.5F, 15, 2.0, damage, caster);
      }), new TimeEvent(1.75F, (mobPatch) -> {
         Level world = ((Mob)mobPatch.getOriginal()).m_9236_();
         LivingEntity caster = (LivingEntity)mobPatch.getOriginal();
         double spawnX = caster.m_20185_();
         double spawnY = caster.m_20186_();
         double spawnZ = caster.m_20189_();
         float damage = (float)caster.m_21133_(Attributes.f_22281_) * 3.2F;
         spawnFlameStrikeRing(world, spawnX, spawnY, spawnZ, 22.0F, 32, 10, 1.5F, damage, caster);
      })})));
   }
}
