package net.shelmarow.nightfall_invade.entity.spear_knight;

import com.google.common.collect.ImmutableMap;
import com.hm.efn.gameasset.animations.EFNDodgeAnimations;
import com.hm.efn.gameasset.animations.EFNLanceAnimations;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.shelmarow.nightfall_invade.ai.BehaviorUtils;
import net.shelmarow.nightfall_invade.ai.NFICombatBehaviors;
import net.shelmarow.nightfall_invade.ai.NFIHumanoidPatch;
import net.shelmarow.nightfall_invade.config.boss.BossConfig;
import net.shelmarow.nightfall_invade.entity.spear_knight.ai.ArteriusAI;
import net.shelmarow.nightfall_invade.gameassets.ExecutionSkillAnimations;
import net.shelmarow.nightfall_invade.iml.CustomExecuteEntity;
import net.shelmarow.nightfall_invade.iml.ILivingEntityData;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.AttackResult.ResultType;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.CapabilityItem.Styles;
import yesman.epicfight.world.capabilities.item.CapabilityItem.WeaponCategories;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class ArteriusPatch extends NFIHumanoidPatch implements CustomExecuteEntity {
   private int stunLevel = 0;
   private int lastStunTime = 0;
   private int blockTime = 5;
   private int maxBlockTime = 5;

   public ArteriusPatch() {
      super(Factions.NEUTRAL);
   }

   public void initAnimator(Animator animator) {
      super.initAnimator(animator);
      animator.addLivingAnimation(LivingMotions.BLOCK, Animations.SPEAR_GUARD);
      animator.addLivingAnimation(LivingMotions.IDLE, EFNLanceAnimations.NF_MEEN_IDLE);
      animator.addLivingAnimation(LivingMotions.WALK, EFNLanceAnimations.NF_MEEN_WALK);
      animator.addLivingAnimation(LivingMotions.RUN, EFNLanceAnimations.NF_MEEN_RUN);
      animator.addLivingAnimation(LivingMotions.CHASE, EFNLanceAnimations.NF_MEEN_RUN);
      animator.addLivingAnimation(LivingMotions.DEATH, Animations.BIPED_COMMON_NEUTRALIZED);
   }

   protected void setWeaponMotions() {
      this.weaponLivingMotions.put(WeaponCategories.SPEAR, ImmutableMap.of(Styles.TWO_HAND, Set.of(Pair.of(LivingMotions.BLOCK, Animations.SPEAR_GUARD), Pair.of(LivingMotions.IDLE, EFNLanceAnimations.NF_MEEN_IDLE), Pair.of(LivingMotions.WALK, EFNLanceAnimations.NF_MEEN_WALK), Pair.of(LivingMotions.RUN, EFNLanceAnimations.NF_MEEN_RUN), Pair.of(LivingMotions.CHASE, EFNLanceAnimations.NF_MEEN_RUN))));
      this.guardHitMotions.put(WeaponCategories.SPEAR, ImmutableMap.of(Styles.TWO_HAND, List.of(Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2, Animations.SWORD_GUARD_ACTIVE_HIT1, Animations.SWORD_GUARD_ACTIVE_HIT2, Animations.SWORD_GUARD_ACTIVE_HIT3)));
      this.weaponAttackMotions.put(WeaponCategories.SPEAR, ImmutableMap.of(Styles.TWO_HAND, ArteriusAI.NORMAL));
   }

   public void playGuardBreakSound() {
      this.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_BOSSES.get(), 1.0F, 1.0F);
   }

   public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
      AttackResult result = super.attack(damageSource, target, hand);
      if (result.resultType == ResultType.SUCCESS && target.m_6084_()) {
         if (target.m_20094_() <= 0) {
            target.m_20254_(5);
         }

         EpicFightDamageSource source = this.getDamageSource(damageSource.getAnimation(), hand).addRuntimeTag(DamageTypeTags.f_268745_);
         int pre = target.f_19802_;
         target.f_19802_ = 0;
         float fireDamage = ((Double)BossConfig.ARTERIUS_EX_FIRE_DAMAGE.get()).floatValue();
         target.m_6469_(source, (float)(((PathfinderMob)this.original).m_21133_(Attributes.f_22281_) * (double)fireDamage));
         target.f_19802_ = pre;
      }

      return result;
   }

   public void tick(LivingEvent.LivingTickEvent event) {
      super.tick(event);
      Entity var3 = this.original;
      if (var3 instanceof Arterius entity) {
         double maxStamina = entity.m_21133_((Attribute)EpicFightAttributes.MAX_STAMINA.get());
         ILivingEntityData entityData = (ILivingEntityData)this;
         entity.setStamina((float)((double)entityData.nightFall_Invade$getStamina((LivingEntity)this.original) / maxStamina));
      }

      if (this.stunLevel > 0 && ((PathfinderMob)this.original).f_19797_ - this.lastStunTime >= 100) {
         --this.stunLevel;
         this.lastStunTime = ((PathfinderMob)this.original).f_19797_;
      }

   }

   public void onCommonHurt(DamageSource damageSource) {
      Arterius arterius = (Arterius)this.getOriginal();
      if (arterius.isInBattle()) {
         hurtImpactPercent = 0.35F;
         Entity entity = damageSource.m_7639_();
         if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability(livingEntity.m_21120_(InteractionHand.MAIN_HAND));
            if (capabilityItem != null && (capabilityItem.getWeaponCategory() == WeaponCategories.SPEAR || capabilityItem.getWeaponCategory() == WeaponCategories.GREATSWORD)) {
               hurtImpactPercent = 0.5F;
            }
         }

         super.onCommonHurt(damageSource);
      }

   }

   public int getBlockTime() {
      return this.blockTime;
   }

   public void setBlockTime(int blockTime) {
      this.blockTime = blockTime;
   }

   public int getMaxBlockTime() {
      return this.maxBlockTime;
   }

   public void setMaxBlockTime(int maxBlockTime) {
      this.maxBlockTime = maxBlockTime;
   }

   public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> blocker) {
   }

   public void onAttackParried(DamageSource damageSource, LivingEntityPatch<?> blocker) {
      NFICombatBehaviors.Behavior<?> currentBehavior = BehaviorUtils.getCurrentBehavior(this);
      if (currentBehavior != null) {
         String name = currentBehavior.getBehaviorRoot().getRootName();
         if (name == null || !name.equals("ArteriusDashing")) {
            this.dealStaminaDamage((EpicFightDamageSource)null, (float)(((PathfinderMob)this.original).m_21133_((Attribute)EpicFightAttributes.MAX_STAMINA.get()) * 0.012000000104308128));
         }
      }

   }

   public boolean applyStun(StunType stunType, float stunTime) {
      if (stunTime > 0.5F) {
         stunTime = 0.5F;
      }

      boolean applied = super.applyStun(stunType, stunTime);
      if (applied && stunType != StunType.NEUTRALIZE && stunType != StunType.NONE) {
         ++this.stunLevel;
         this.lastStunTime = ((PathfinderMob)this.original).f_19797_;
         if (this.stunLevel >= 3) {
            double percent = Mth.m_14008_(0.25 * (double)(this.stunLevel - 2), 0.0, 1.0);
            double random = Math.random();
            if (random < percent) {
               ((PathfinderMob)this.original).m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), (this.stunLevel - 2) * 80), this.original);
               if (!this.isLogicalClient()) {
                  this.playAnimationSynchronized(EFNDodgeAnimations.DODGE_ROLL_B, 0.0F, SPAnimatorControl::new);
               }

               this.stunLevel = 0;
            }
         }
      }

      return applied;
   }

   public OpenMatrix4f getModelMatrix(float partialTicks) {
      float scale = ((PathfinderMob)this.original).m_6134_();
      return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
   }

   public boolean canBeExecuted(LivingEntityPatch<?> entityPatch) {
      return ((Arterius)this.original).isInBattle();
   }

   public AnimationManager.AnimationAccessor<? extends StaticAnimation> getExecutionAnimation() {
      return ExecutionSkillAnimations.EXECUTION;
   }

   public AnimationManager.AnimationAccessor<? extends StaticAnimation> getExecutedAnimation(boolean isFont) {
      return ExecutionSkillAnimations.EXECUTED_FULL;
   }

   public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
      switch (stunType) {
         case LONG:
            return Animations.BIPED_HIT_LONG;
         case SHORT:
         case HOLD:
            return Animations.BIPED_HIT_SHORT;
         case KNOCKDOWN:
            return Animations.BIPED_KNOCKDOWN;
         case NEUTRALIZE:
            return Animations.GREATSWORD_GUARD_BREAK;
         case FALL:
            return Animations.BIPED_LANDING;
         default:
            return null;
      }
   }
}
