package net.shelmarow.nightfall_invade.entity.spear_knight;

import com.github.L_Ender.cataclysm.entity.effect.Flame_Strike_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Abyss_Fireball_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Fireball_Entity;
import com.hm.efn.registries.EFNItem;
import com.hm.efn.registries.EFNMobEffectRegistry;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.AttributeModifier.Operation;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.shelmarow.nightfall_invade.client.bossbar.NFIBossEvent;
import net.shelmarow.nightfall_invade.config.boss.BossConfig;
import net.shelmarow.nightfall_invade.iml.ILivingEntityData;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class Arterius extends PathfinderMob {
   private final NFIBossEvent bossEvent = new NFIBossEvent(Component.m_237113_("[NightFallInvade:Arterius]"));
   private boolean inBattle = true;
   private Vec3 homePos = null;
   private float damageReduction = 0.0F;
   private float totalDamageCount = 0.0F;
   private int bossPhase = 0;
   private int skillReleased = 0;
   private int phaseChangeTimer = 0;

   public Arterius(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
      super(pEntityType, pLevel);
      this.m_21530_();
      this.setEquipment();
      this.bossEvent.m_8321_(false);
   }

   public void onAddedToWorld() {
      super.onAddedToWorld();
      this.setAttributesFromConfig();
      this.resetBossStatus(false);
      this.resetGoalsByInBattle();
      if (this.homePos == null) {
         this.homePos = this.m_20182_();
      }

   }

   private void setAttributesFromConfig() {
      float healthConfig = ((Double)BossConfig.ARTERIUS_MAX_HEALTH_MULTIPLIER.get()).floatValue();
      float damageConfig = ((Double)BossConfig.ARTERIUS_ATTACK_DAMAGE_MULTIPLIER.get()).floatValue();
      UUID att = UUID.fromString("31898599-9b54-4600-a8c5-81845eb664f7");
      AttributeInstance healthInstance = this.m_21051_(Attributes.f_22276_);
      AttributeInstance damageInstance = this.m_21051_(Attributes.f_22281_);
      AttributeModifier healthModifier = new AttributeModifier(att, "health_modifier", (double)(healthConfig - 1.0F), Operation.MULTIPLY_TOTAL);
      AttributeModifier damageModifier = new AttributeModifier(att, "damage_modifier", (double)(damageConfig - 1.0F), Operation.MULTIPLY_TOTAL);
      if (healthInstance != null) {
         float ratio = this.m_21223_() / this.m_21233_();
         if (healthInstance.m_22109_(healthModifier)) {
            healthInstance.m_22130_(healthModifier);
         }

         healthInstance.m_22125_(healthModifier);
         this.m_21153_(this.m_21233_() * ratio);
         if (this.m_21223_() > this.m_21233_()) {
            this.m_21153_(this.m_21233_());
         }
      }

      if (damageInstance != null) {
         if (damageInstance.m_22109_(damageModifier)) {
            damageInstance.m_22130_(damageModifier);
         }

         damageInstance.m_22125_(damageModifier);
      }

   }

   private void setEquipment() {
      this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)EFNItem.MEEN_SPEAR.get()));
      this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)EFNItem.DUSKFIRE_HELMET.get()));
      this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)EFNItem.DUSKFIRE_CHESTPLATE.get()));
      this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)EFNItem.DUSKFIRE_LEGGINGS.get()));
      this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)EFNItem.DUSKFIRE_BOOTS.get()));
      this.m_21409_(EquipmentSlot.MAINHAND, 0.0F);
      this.m_21409_(EquipmentSlot.OFFHAND, 0.0F);
      this.m_21409_(EquipmentSlot.HEAD, 0.0F);
      this.m_21409_(EquipmentSlot.CHEST, 0.0F);
      this.m_21409_(EquipmentSlot.LEGS, 0.0F);
      this.m_21409_(EquipmentSlot.FEET, 0.0F);
   }

   public static AttributeSupplier.Builder createAttributes() {
      return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.45).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22284_, 30.0).m_22268_(Attributes.f_22285_, 20.0).m_22268_(Attributes.f_22278_, 0.25).m_22268_((Attribute)EpicFightAttributes.IMPACT.get(), 4.0).m_22268_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), 50.0).m_22268_((Attribute)EpicFightAttributes.STUN_ARMOR.get(), 16.0).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 100.0).m_22268_((Attribute)EpicFightAttributes.MAX_STAMINA.get(), 40.0);
   }

   public boolean m_7341_(@NotNull Entity entity) {
      return false;
   }

   public void m_6083_() {
      this.m_19877_();
   }

   public @NotNull InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
      return super.m_6071_(pPlayer, pHand);
   }

   protected void m_8099_() {
      this.f_21345_.m_25352_(1, new LookAtPlayerGoal(this, Player.class, 12.0F));
      this.f_21345_.m_25352_(2, new RandomLookAroundGoal(this));
      this.f_21346_.m_25352_(1, new NearestAttackableTargetGoal(this, Player.class, true));
      this.f_21346_.m_25352_(2, new HurtByTargetGoal(this, new Class[0]));
   }

   public void resetGoalsByInBattle() {
      Iterator var1 = this.f_21346_.m_25386_().toList().iterator();

      WrappedGoal goal;
      while(var1.hasNext()) {
         goal = (WrappedGoal)var1.next();
         goal.m_8041_();
      }

      this.f_21346_.m_262460_((goalx) -> {
         return true;
      });
      if (this.isInBattle()) {
         this.f_21346_.m_25352_(1, new NearestAttackableTargetGoal(this, Player.class, true));
         this.f_21346_.m_25352_(2, new HurtByTargetGoal(this, new Class[0]));
         var1 = this.f_21346_.m_148105_().iterator();

         while(var1.hasNext()) {
            goal = (WrappedGoal)var1.next();
            goal.m_8056_();
         }
      } else {
         this.m_6710_((LivingEntity)null);
      }

   }

   public void m_7380_(@NotNull CompoundTag tag) {
      super.m_7380_(tag);
      if (this.homePos != null) {
         CompoundTag posTag = new CompoundTag();
         posTag.m_128347_("x", this.homePos.f_82479_);
         posTag.m_128347_("y", this.homePos.f_82480_);
         posTag.m_128347_("z", this.homePos.f_82481_);
         tag.m_128365_("homePos", posTag);
      }

      tag.m_128379_("InBattle", this.isInBattle());
      this.resetGoalsByInBattle();
   }

   public void m_7378_(@NotNull CompoundTag tag) {
      super.m_7378_(tag);
      if (this.homePos != null && tag.m_128425_("homePos", 10)) {
         CompoundTag posTag = tag.m_128469_("TargetPos");
         this.homePos = new Vec3(posTag.m_128459_("x"), posTag.m_128459_("y"), posTag.m_128459_("z"));
      }

      if (tag.m_128425_("InBattle", 1)) {
         this.setInBattle(tag.m_128471_("InBattle"));
      } else {
         this.resetGoalsByInBattle();
      }

   }

   public Vec3 getHomePos() {
      return this.homePos;
   }

   public void setHomePos(Vec3 homePos) {
      this.homePos = homePos;
   }

   public void backToHomePos() {
      if (this.homePos != null) {
         this.m_6021_(this.homePos.f_82479_, this.homePos.f_82480_, this.homePos.f_82481_);
      }

   }

   public boolean isInBattle() {
      return this.inBattle;
   }

   public void setInBattle(boolean inBattle) {
      this.inBattle = inBattle;
      this.resetGoalsByInBattle();
   }

   public void resetBossStatus(boolean resetHealth) {
      if (resetHealth) {
         this.m_21153_(this.m_21233_());
      }

      ArteriusPatch arteriusPatch = (ArteriusPatch)EpicFightCapabilities.getEntityPatch(this, ArteriusPatch.class);
      if (arteriusPatch instanceof ILivingEntityData patchData) {
         patchData.nightFall_Invade$setStamina(this, (float)this.m_21133_((Attribute)EpicFightAttributes.MAX_STAMINA.get()));
      }

      this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)EFNItem.MEEN_SPEAR.get()));
      this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)EFNItem.DUSKFIRE_HELMET.get()));
      this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)EFNItem.DUSKFIRE_CHESTPLATE.get()));
      this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)EFNItem.DUSKFIRE_LEGGINGS.get()));
      this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)EFNItem.DUSKFIRE_BOOTS.get()));
      this.setPhaseByHealth();
   }

   public int getPhaseChangeTimer() {
      return this.phaseChangeTimer;
   }

   public void setPhaseChangeTimer(int phaseChangeTimer) {
      this.phaseChangeTimer = phaseChangeTimer;
   }

   public int getSkillReleased() {
      return this.skillReleased;
   }

   public void setSkillReleased(int skillReleased) {
      this.skillReleased = skillReleased;
   }

   public int getBossPhase() {
      return this.bossPhase;
   }

   public void setBossPhase(int bossPhase) {
      this.bossPhase = bossPhase;
   }

   public void setPhaseByHealth() {
      this.phaseChangeTimer = 0;
      float health = this.m_21223_();
      float maxHealth = this.m_21233_();
      if (health > maxHealth * 0.75F) {
         this.setBossPhase(0);
         this.setSkillReleased(0);
      } else if (health > maxHealth * 0.5F) {
         this.setBossPhase(1);
         this.setSkillReleased(1);
      } else if (health > maxHealth * 0.25F) {
         this.setBossPhase(2);
         this.setSkillReleased(2);
      } else {
         this.setBossPhase(3);
         this.setSkillReleased(3);
      }

   }

   public void adjustDamageReduction() {
      float maxRatio = ((Double)BossConfig.ARTERIUS_DAMAGE_MAX_THRESHOLD.get()).floatValue();
      float damageThreshold = ((Double)BossConfig.ARTERIUS_DAMAGE_THRESHOLD.get()).floatValue();
      int decaySecond = (Integer)BossConfig.ARTERIUS_DECAY_SECOND.get();
      float speed = (maxRatio - damageThreshold) * this.m_21233_() / (float)decaySecond;
      this.totalDamageCount = Math.max(this.totalDamageCount - speed, 0.0F);
      if (this.totalDamageCount <= this.m_21233_() * damageThreshold) {
         this.damageReduction = 0.0F;
      }

   }

   public void m_8119_() {
      super.m_8119_();
      if (this.isInBattle() && !this.bossEvent.m_8323_()) {
         this.bossEvent.m_8321_(true);
      } else if (!this.isInBattle() && this.bossEvent.m_8323_()) {
         this.bossEvent.m_8321_(false);
      }

      if (this.m_21223_() < this.m_21233_() * 0.25F && this.m_21023_((MobEffect)EFNMobEffectRegistry.MEEN_LANCE.get())) {
         MobEffectInstance effect = this.m_21124_((MobEffect)EFNMobEffectRegistry.MEEN_LANCE.get());
         if (effect != null && effect.m_19564_() != 255) {
            this.m_147215_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.MEEN_LANCE.get(), 200, 200), this);
         }
      }

      if (this.phaseChangeTimer > 0) {
         --this.phaseChangeTimer;
         if (this.bossPhase == 1 && this.m_21223_() < this.m_21233_() * 0.75F) {
            this.m_21153_(this.m_21233_() * 0.75F);
         } else if (this.bossPhase == 2 && this.m_21223_() < this.m_21233_() * 0.5F) {
            this.m_21153_(this.m_21233_() * 0.5F);
         } else if (this.bossPhase == 3 && this.m_21223_() < this.m_21233_() * 0.25F) {
            this.m_21153_(this.m_21233_() * 0.25F);
         }
      }

      if (!this.m_9236_().m_5776_()) {
         this.adjustDamageReduction();
      }

   }

   public boolean m_6673_(DamageSource damageSource) {
      return damageSource.m_7640_() instanceof Ignis_Fireball_Entity || damageSource.m_7640_() instanceof Ignis_Abyss_Fireball_Entity || damageSource.m_7640_() instanceof Flame_Strike_Entity || damageSource.m_269533_(DamageTypeTags.f_268415_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || super.m_6673_(damageSource);
   }

   public boolean m_7301_(MobEffectInstance pEffectInstance) {
      return pEffectInstance.m_19544_().m_19483_() != MobEffectCategory.HARMFUL && pEffectInstance.m_19544_() != EFNMobEffectRegistry.STOP.get() && super.m_7301_(pEffectInstance);
   }

   public void m_6475_(@NotNull DamageSource pDamageSource, float originalDamage) {
      if (pDamageSource.m_7639_() == null || !pDamageSource.m_269533_(DamageTypeTags.f_268524_) || !(pDamageSource.m_7639_().m_20280_(this) >= 144.0)) {
         if (pDamageSource.m_276093_(DamageTypes.f_268612_)) {
            this.backToHomePos();
         } else {
            Entity attacker = pDamageSource.m_7639_();
            if (!this.m_6673_(pDamageSource)) {
               if (!pDamageSource.m_269533_(DamageTypeTags.f_268738_)) {
                  label101: {
                     if (this.phaseChangeTimer <= 0) {
                        if (this.isInBattle()) {
                           break label101;
                        }

                        if (attacker instanceof Player) {
                           Player player = (Player)attacker;
                           if (player.m_7500_()) {
                              break label101;
                           }
                        }
                     }

                     return;
                  }
               }

               originalDamage = ForgeHooks.onLivingHurt(this, pDamageSource, originalDamage);
               if (originalDamage <= 0.0F) {
                  return;
               }

               originalDamage = this.m_21161_(pDamageSource, originalDamage);
               originalDamage = this.m_6515_(pDamageSource, originalDamage);
               float damage = Math.max(originalDamage - this.m_6103_(), 0.0F);
               this.m_7911_(this.m_6103_() - (originalDamage - damage));
               float f = originalDamage - damage;
               if (f > 0.0F && f < 3.4028235E37F) {
                  Entity entity = pDamageSource.m_7639_();
                  if (entity instanceof ServerPlayer) {
                     ServerPlayer serverplayer = (ServerPlayer)entity;
                     serverplayer.m_36222_(Stats.f_12929_, Math.round(f * 10.0F));
                  }
               }

               float damageCap = ((Double)BossConfig.ARTERIUS_DAMAGE_CAP.get()).floatValue();
               float maxRatio = ((Double)BossConfig.ARTERIUS_DAMAGE_MAX_THRESHOLD.get()).floatValue();
               float damageThreshold = ((Double)BossConfig.ARTERIUS_DAMAGE_THRESHOLD.get()).floatValue();
               float maxReduction = ((Double)BossConfig.ARTERIUS_MAX_REDUCTION.get()).floatValue();
               float bossDamageCap = this.m_21233_() * damageCap;
               if (!pDamageSource.m_269533_(DamageTypeTags.f_268738_) && (!pDamageSource.m_269533_(DamageTypeTags.f_268490_) || !pDamageSource.m_269533_(DamageTypeTags.f_268413_) || !pDamageSource.m_269533_(DamageTypeTags.f_268437_))) {
                  if (damage > bossDamageCap) {
                     damage = bossDamageCap;
                  }

                  this.damageReduction = Mth.m_14036_((this.totalDamageCount - this.m_21233_() * damageThreshold) / (this.m_21233_() * (maxRatio - damageThreshold)), 0.0F, maxReduction);
                  damage *= 1.0F - this.damageReduction;
                  this.totalDamageCount = Math.min(this.totalDamageCount + damage, this.m_21233_() * maxRatio);
               }

               if (damage != 0.0F) {
                  this.m_21231_().m_289194_(pDamageSource, damage);
                  if (!pDamageSource.m_269533_(DamageTypeTags.f_268738_)) {
                     if (this.bossPhase == 0 && this.m_21223_() - damage <= this.m_21233_() * 0.75F) {
                        damage = 0.0F;
                        this.bossPhase = 1;
                        this.phaseChangeTimer = 200;
                        this.m_21153_(this.m_21233_() * 0.75F);
                        this.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 160));
                     } else if (this.bossPhase == 1 && this.m_21223_() - damage <= this.m_21233_() * 0.5F) {
                        damage = 0.0F;
                        this.bossPhase = 2;
                        this.phaseChangeTimer = 200;
                        this.m_21153_(this.m_21233_() * 0.5F);
                        this.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 160));
                     } else if (this.bossPhase == 2 && this.m_21223_() - damage <= this.m_21233_() * 0.25F) {
                        damage = 0.0F;
                        this.bossPhase = 3;
                        this.phaseChangeTimer = 200;
                        this.m_21153_(this.m_21233_() * 0.25F);
                        this.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 160));
                     }
                  }

                  damage = ForgeHooks.onLivingDamage(this, pDamageSource, damage);
                  this.m_21153_(this.m_21223_() - damage);
                  this.m_7911_(this.m_6103_() - damage);
                  this.m_146850_(GameEvent.f_223706_);
               }
            }

         }
      }
   }

   public SoundEvent m_7975_(@NotNull DamageSource source) {
      return SoundEvents.f_11704_;
   }

   public SoundEvent m_5592_() {
      return SoundEvents.f_11703_;
   }

   public void m_6667_(@NotNull DamageSource cause) {
      this.m_5496_(SoundEvents.f_12496_, 1.0F, 1.0F);
      super.m_6667_(cause);
   }

   public float m_6134_() {
      return 1.4F;
   }

   public void m_6457_(@NotNull ServerPlayer pPlayer) {
      super.m_6457_(pPlayer);
      this.bossEvent.m_6543_(pPlayer);
   }

   public void m_6452_(@NotNull ServerPlayer pPlayer) {
      super.m_6452_(pPlayer);
      this.bossEvent.m_6539_(pPlayer);
   }

   public void setStamina(float value) {
      this.bossEvent.setStamina(value);
   }

   public void m_8107_() {
      super.m_8107_();
      this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
   }
}
