package net.shelmarow.nightfall_invade.efcondition;

import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HealthCheck extends Condition.EntityPatchCondition {
   private float health;
   private Comparator comparator;

   public HealthCheck() {
      this.health = 0.0F;
   }

   public HealthCheck(float health, Comparator comparator) {
      this.health = health;
      this.comparator = comparator;
   }

   public HealthCheck read(CompoundTag tag) {
      this.health = (Float)this.assertTag("health", "decimal", tag, NumericTag.class, CompoundTag::m_128457_);
      this.comparator = (Comparator)this.assertEnumTag("comparator", Comparator.class, tag);
      return this;
   }

   public CompoundTag serializePredicate() {
      CompoundTag tag = new CompoundTag();
      tag.m_128359_("comparator", this.comparator.toString().toLowerCase(Locale.ROOT));
      tag.m_128350_("health", this.health);
      return tag;
   }

   public boolean predicate(LivingEntityPatch<?> target) {
      switch (this.comparator) {
         case LESS_ABSOLUTE -> return this.health > ((LivingEntity)target.getOriginal()).m_21223_();
         case LESS_ABSOLUTE_CONTAIN -> return this.health >= ((LivingEntity)target.getOriginal()).m_21223_();
         case GREATER_ABSOLUTE -> return this.health < ((LivingEntity)target.getOriginal()).m_21223_();
         case GREATER_ABSOLUTE_CONTAIN -> return this.health <= ((LivingEntity)target.getOriginal()).m_21223_();
         case LESS_RATIO -> return this.health > ((LivingEntity)target.getOriginal()).m_21223_() / ((LivingEntity)target.getOriginal()).m_21233_();
         case LESS_RATIO_CONTAIN -> return this.health >= ((LivingEntity)target.getOriginal()).m_21223_() / ((LivingEntity)target.getOriginal()).m_21233_();
         case GREATER_RATIO -> return this.health < ((LivingEntity)target.getOriginal()).m_21223_() / ((LivingEntity)target.getOriginal()).m_21233_();
         case GREATER_RATIO_CONTAIN -> return this.health <= ((LivingEntity)target.getOriginal()).m_21223_() / ((LivingEntity)target.getOriginal()).m_21233_();
         default -> return true;
      }
   }

   @OnlyIn(Dist.CLIENT)
   public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
      return null;
   }

   public static enum Comparator {
      GREATER_ABSOLUTE,
      GREATER_ABSOLUTE_CONTAIN,
      LESS_ABSOLUTE,
      LESS_ABSOLUTE_CONTAIN,
      GREATER_RATIO,
      GREATER_RATIO_CONTAIN,
      LESS_RATIO,
      LESS_RATIO_CONTAIN;

      // $FF: synthetic method
      private static Comparator[] $values() {
         return new Comparator[]{GREATER_ABSOLUTE, GREATER_ABSOLUTE_CONTAIN, LESS_ABSOLUTE, LESS_ABSOLUTE_CONTAIN, GREATER_RATIO, GREATER_RATIO_CONTAIN, LESS_RATIO, LESS_RATIO_CONTAIN};
      }
   }
}
