package net.shelmarow.nightfall_invade.efcondition;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class CurrentAngle implements Condition<LivingEntityPatch<?>> {
   private String side;
   private double degreeFirst;
   private double degreeSecond;

   public CurrentAngle(String side, double degreeFirst, double degreeSecond) {
      this.side = side;
      this.degreeFirst = degreeFirst;
      this.degreeSecond = degreeSecond;
   }

   public CurrentAngle() {
   }

   public Condition<LivingEntityPatch<?>> read(CompoundTag tag) {
      this.side = tag.m_128461_("side");
      this.degreeFirst = tag.m_128459_("first");
      this.degreeSecond = tag.m_128459_("second");
      return this;
   }

   public CompoundTag serializePredicate() {
      CompoundTag tag = new CompoundTag();
      tag.m_128359_("side", this.side);
      tag.m_128347_("first", this.degreeFirst);
      tag.m_128347_("second", this.degreeSecond);
      return tag;
   }

   public boolean predicate(LivingEntityPatch<?> livingEntityPatch) {
      if (livingEntityPatch.getTarget() != null) {
         LivingEntity target = livingEntityPatch.getTarget();
         return isInSideAngleRange((LivingEntity)livingEntityPatch.getOriginal(), target, this.side, this.degreeFirst, this.degreeSecond);
      } else {
         return false;
      }
   }

   public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
      return null;
   }

   public static double getSideAngle(LivingEntity observer, LivingEntity target) {
      Vec3 lookVec = observer.m_20154_().m_82541_();
      lookVec = (new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_)).m_82541_();
      Vec3 toTarget = (new Vec3(target.m_20185_() - observer.m_20185_(), 0.0, target.m_20189_() - observer.m_20189_())).m_82541_();
      double dot = lookVec.m_82526_(toTarget);
      dot = Math.max(-1.0, Math.min(1.0, dot));
      double angle = Math.toDegrees(Math.acos(dot));
      double crossY = lookVec.m_82537_(toTarget).f_82480_;
      if (crossY > 0.0) {
         return -angle;
      } else {
         return crossY < 0.0 ? angle : 0.0;
      }
   }

   public static boolean isInSideAngleRange(LivingEntity observer, LivingEntity target, String side, double startAngle, double endAngle) {
      double angle = getSideAngle(observer, target);
      double absAngle = Math.abs(angle);
      if ("left".equalsIgnoreCase(side) && angle < 0.0) {
         return isAngleInRange(absAngle, startAngle, endAngle);
      } else {
         return "right".equalsIgnoreCase(side) && angle > 0.0 ? isAngleInRange(absAngle, startAngle, endAngle) : false;
      }
   }

   private static boolean isAngleInRange(double angle, double start, double end) {
      if (start <= end) {
         return angle >= start && angle <= end;
      } else {
         return angle >= start || angle <= end;
      }
   }
}
