package net.shelmarow.nightfall_invade.client.execution;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat.Mode;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.TickEvent.Phase;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;
import net.shelmarow.nightfall_invade.tickTask.handler.ExecutionHandler;
import org.joml.Matrix4f;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.StunType;

@EventBusSubscriber(
   modid = "nightfall_invade",
   bus = Bus.FORGE,
   value = {Dist.CLIENT}
)
public class ExecutionHUD {
   private static final ResourceLocation OVERLAY_1 = ResourceLocation.fromNamespaceAndPath("nightfall_invade", "textures/gui/execution/overlay_1.png");
   private static final ResourceLocation OVERLAY_2 = ResourceLocation.fromNamespaceAndPath("nightfall_invade", "textures/gui/execution/overlay_2.png");
   private static final ResourceLocation OVERLAY_3 = ResourceLocation.fromNamespaceAndPath("nightfall_invade", "textures/gui/execution/overlay_3.png");
   private static final ResourceLocation BG_OUTLINE = ResourceLocation.fromNamespaceAndPath("nightfall_invade", "textures/gui/execution/bg_outline.png");
   private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath("nightfall_invade", "textures/gui/execution/bg.png");
   private static final Minecraft mc = Minecraft.m_91087_();
   private static boolean showExecutionIcon = false;
   private static float timePercent = 1.0F;

   @SubscribeEvent
   public static void onPlayerClientTick(TickEvent.PlayerTickEvent event) {
      if (event.player.m_9236_().f_46443_ && event.phase == Phase.END) {
         LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
         if (localPlayerPatch != null) {
            LivingEntity target = localPlayerPatch.getTarget();
            if (target != null) {
               LivingEntityPatch<?> targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(target, LivingEntityPatch.class);
               if (event.player.m_6084_() && target.m_6084_() && ExecutionHandler.isExecutingTarget(event.player, target) && ExecutionHandler.canBeExecuted(targetPatch) && ExecutionHandler.isHoldingWeapon(event.player)) {
                  AnimationPlayer animationPlayer = targetPatch.getAnimator().getPlayerFor((AssetAccessor)null);
                  if (animationPlayer != null) {
                     AssetAccessor<? extends DynamicAnimation> stunAnimation = animationPlayer.getAnimation();
                     if (stunAnimation != null && stunAnimation == targetPatch.getHitAnimation(StunType.NEUTRALIZE)) {
                        float totalTime = ((DynamicAnimation)stunAnimation.get()).getTotalTime();
                        float currentTime = animationPlayer.getElapsedTime();
                        timePercent = currentTime / totalTime;
                        showExecutionIcon = true;
                        return;
                     }
                  }
               }
            }
         }

         showExecutionIcon = false;
      }

   }

   @SubscribeEvent
   public static void OnRenderGUI(RenderGuiEvent.Post event) {
      if (mc.f_91073_ != null && mc.f_91074_ != null) {
         if (showExecutionIcon) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            PoseStack poseStack = guiGraphics.m_280168_();
            int renderX = event.getWindow().m_85445_() / 2 + 40;
            int renderY = event.getWindow().m_85446_() / 2 + 40;
            Component text = Component.m_237115_("hud.nightfall_invade.execution_tooltip");
            List<FormattedCharSequence> lines = mc.f_91062_.m_92923_(text, Integer.MAX_VALUE);
            int textWidth = 0;
            Objects.requireNonNull(mc.f_91062_);
            int textHeight = 9 * lines.size();
            Iterator var9 = lines.iterator();

            while(var9.hasNext()) {
               FormattedCharSequence line = (FormattedCharSequence)var9.next();
               int width = mc.f_91062_.m_92724_(line);
               if (width > textWidth) {
                  textWidth = width;
               }
            }

            poseStack.m_85836_();
            poseStack.m_252880_((float)renderX, (float)renderY, 0.0F);
            poseStack.m_85841_(0.75F, 0.75F, 0.75F);
            guiGraphics.m_280509_(-2 - textWidth / 2, -2, textWidth + 2 - textWidth / 2, textHeight + 2, -16777216);
            guiGraphics.m_280637_(-2 - textWidth / 2, -2, textWidth + 4, textHeight + 4, -1);
            int offsetY = 0;

            for(Iterator var13 = lines.iterator(); var13.hasNext(); offsetY += 9) {
               FormattedCharSequence line = (FormattedCharSequence)var13.next();
               guiGraphics.m_280648_(mc.f_91062_, line, -textWidth / 2, offsetY, -1);
               Objects.requireNonNull(mc.f_91062_);
            }

            poseStack.m_85849_();
            drawExecutionIcon(event.getGuiGraphics(), (float)(renderX - 16), (float)(renderY - 32), 32.0F);
         }

      }
   }

   public static void drawExecutionIcon(GuiGraphics guiGraphics, float x, float y, float iconSize) {
      RenderSystem.enableBlend();
      RenderSystem.defaultBlendFunc();
      RenderSystem.disableDepthTest();
      RenderSystem.disableCull();
      RenderSystem.setShader(GameRenderer::m_172817_);
      Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
      Tesselator tess = Tesselator.m_85913_();
      BufferBuilder buf = tess.m_85915_();
      RenderSystem.setShaderTexture(0, BG);
      buf.m_166779_(Mode.QUADS, DefaultVertexFormat.f_85817_);
      buf.m_252986_(matrix, x, y, 0.0F).m_7421_(0.0F, 0.0F).m_6122_(1, 1, 1, 1).m_5752_();
      buf.m_252986_(matrix, x + iconSize, y, 0.0F).m_7421_(1.0F, 0.0F).m_6122_(1, 1, 1, 1).m_5752_();
      buf.m_252986_(matrix, x + iconSize, y + iconSize, 0.0F).m_7421_(1.0F, 1.0F).m_6122_(1, 1, 1, 1).m_5752_();
      buf.m_252986_(matrix, x, y + iconSize, 0.0F).m_7421_(0.0F, 1.0F).m_6122_(1, 1, 1, 1).m_5752_();
      BufferUploader.m_231202_(buf.m_231175_());
      RenderSystem.setShaderTexture(0, BG_OUTLINE);
      buf.m_166779_(Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
      float cx = x + iconSize / 2.0F;
      float cy = y + iconSize / 2.0F;
      buf.m_252986_(matrix, cx, cy, 0.0F).m_7421_(0.5F, 0.5F).m_5752_();
      int segments = 100;
      float filled = 1.0F - timePercent;
      float filledAngle = 360.0F * filled;
      double startRad = Math.toRadians(90.0);
      double step = Math.toRadians((double)(filledAngle / (float)segments));

      for(int i = 0; i <= segments; ++i) {
         double angle = startRad - step * (double)i;
         float cos = (float)Math.cos(angle);
         float sin = (float)Math.sin(angle);
         float px = cx + cos * iconSize / 2.0F;
         float py = cy - sin * iconSize / 2.0F;
         float u = 0.5F + cos * 0.5F;
         float v = 0.5F - sin * 0.5F;
         buf.m_252986_(matrix, px, py, 0.0F).m_7421_(u, v).m_5752_();
      }

      BufferUploader.m_231202_(buf.m_231175_());
      if (filled > 0.75F) {
         RenderSystem.setShaderTexture(0, OVERLAY_1);
      } else if (filled > 0.25F) {
         RenderSystem.setShaderTexture(0, OVERLAY_2);
      } else {
         RenderSystem.setShaderTexture(0, OVERLAY_3);
      }

      buf.m_166779_(Mode.QUADS, DefaultVertexFormat.f_85817_);
      buf.m_252986_(matrix, x, y, 0.0F).m_7421_(0.0F, 0.0F).m_6122_(1, 1, 1, 1).m_5752_();
      buf.m_252986_(matrix, x + iconSize, y, 0.0F).m_7421_(1.0F, 0.0F).m_6122_(1, 1, 1, 1).m_5752_();
      buf.m_252986_(matrix, x + iconSize, y + iconSize, 0.0F).m_7421_(1.0F, 1.0F).m_6122_(1, 1, 1, 1).m_5752_();
      buf.m_252986_(matrix, x, y + iconSize, 0.0F).m_7421_(0.0F, 1.0F).m_6122_(1, 1, 1, 1).m_5752_();
      BufferUploader.m_231202_(buf.m_231175_());
      RenderSystem.enableCull();
      RenderSystem.disableBlend();
   }
}
