package net.shelmarow.nightfall_invade.client.bossbar;

import java.util.Iterator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent.BossBarColor;
import net.minecraft.world.BossEvent.BossBarOverlay;
import net.minecraftforge.network.PacketDistributor;
import net.shelmarow.nightfall_invade.NightFallInvade;
import net.shelmarow.nightfall_invade.client.bossbar.network.ClientboundBossDataPacket;

public class NFIBossEvent extends ServerBossEvent {
   private float stamina = -1.0F;

   public NFIBossEvent(Component pName) {
      super(pName, BossBarColor.RED, BossBarOverlay.PROGRESS);
   }

   public void m_7706_() {
      super.m_7706_();
      ClientBossData.removeBoss(this.m_18860_());
   }

   public void setStamina(float value) {
      if (this.stamina != value && !this.m_8324_().isEmpty()) {
         this.stamina = value;
         Iterator var2 = this.m_8324_().iterator();

         while(var2.hasNext()) {
            ServerPlayer player = (ServerPlayer)var2.next();
            this.syncStamina(player);
         }
      }

   }

   public float getStamina() {
      return this.stamina;
   }

   private void syncStamina(ServerPlayer player) {
      NightFallInvade.CHANNEL.send(PacketDistributor.PLAYER.with(() -> {
         return player;
      }), new ClientboundBossDataPacket(this.m_18860_(), this.stamina));
   }
}
