package net.shelmarow.nightfall_invade.client.bossbar;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;

@EventBusSubscriber(
   modid = "nightfall_invade",
   bus = Bus.FORGE,
   value = {Dist.CLIENT}
)
public class BossBarRenderEvent {
   private static final ResourceLocation BOSS_BAR_HEALTH = ResourceLocation.fromNamespaceAndPath("nightfall_invade", "textures/gui/bossbar/boss_bar_health.png");
   private static final ResourceLocation BOSS_BAR_STAMINA = ResourceLocation.fromNamespaceAndPath("nightfall_invade", "textures/gui/bossbar/boss_bar_stamina.png");
   private static final ResourceLocation BOSS_BAR_BG = ResourceLocation.fromNamespaceAndPath("nightfall_invade", "textures/gui/bossbar/boss_bar_bg.png");

   @SubscribeEvent
   public static void onBossBarRender(CustomizeGuiOverlayEvent.BossEventProgress event) {
      LerpingBossEvent boss = event.getBossEvent();
      String rawName = boss.m_18861_().getString();
      if (rawName.equals("[NightFallInvade:Arterius]")) {
         event.setCanceled(true);
         Component displayName = Component.m_237115_("boss_bar.nightfall_invade.arterius").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD});
         Minecraft mc = Minecraft.m_91087_();
         GuiGraphics guiGraphics = event.getGuiGraphics();
         int x = event.getX();
         int y = event.getY();
         float progress = Mth.m_14036_(boss.m_142717_(), 0.0F, 1.0F);
         float stamina = Mth.m_14036_(ClientBossData.getStamina(event.getBossEvent().m_18860_()), 0.0F, 1.0F);
         ResourceLocation var10001 = BOSS_BAR_HEALTH;
         int var10002 = x + 91 - 128 + 13;
         Objects.requireNonNull(mc.f_91062_);
         guiGraphics.m_280163_(var10001, var10002, y - 9, 13.0F, 0.0F, Math.round(230.0F * progress), 32, 256, 32);
         var10001 = BOSS_BAR_STAMINA;
         var10002 = x + 91 - 128 + 11;
         Objects.requireNonNull(mc.f_91062_);
         guiGraphics.m_280163_(var10001, var10002, y - 9, 11.0F, 0.0F, Math.round(234.0F * stamina), 32, 256, 32);
         var10001 = BOSS_BAR_BG;
         var10002 = x + 91 - 128;
         Objects.requireNonNull(mc.f_91062_);
         guiGraphics.m_280163_(var10001, var10002, y - 9, 0.0F, 0.0F, 256, 32, 256, 32);
         Font var10 = mc.f_91062_;
         int var10003 = x + 91 - mc.f_91062_.m_92852_(displayName) / 2;
         Objects.requireNonNull(mc.f_91062_);
         guiGraphics.m_280614_(var10, displayName, var10003, y - 9 + 23, 16777215, false);
         Objects.requireNonNull(mc.f_91062_);
         event.setIncrement(48 - 9);
      }

   }
}
